/*
 * \file       dia_RoutineCtrlCISSWUpdateStage1.cpp
 */

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif
/*
#ifndef dia_SAFeatureTestPatternAIVI_H_
#include "project/framework/sysadapters/dia_SAFeatureTestPatternAIVI.h"
#endif
*/
#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_SUBSYSTEM_DIAGNOSIS_MANAGER__
#include "project/framework/cis/subsystem/dia_SubsystemDiagnosisManager.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_CIS_SW_UPDATE_STAGE1_H__
#include "project/services/customer/dia_RoutineCtrlCISSWUpdateStage1.h"
#endif

dia_eRoutineStatus dia_RoutineCtrlCISSWUpdateStage1::RtctrlStatus = DIA_EN_RTCTRL_STATUS_UNKNOWN;

static tU8 sResultMapping[DIA_EN_RTCTRL_STATUS_COUNT] = {
   0xFF, // DIA_EN_RTCTRL_STATUS_UNKNOWN
   0xFF, // DIA_EN_RTCTRL_STATUS_IDLE
   0x03, // DIA_EN_RTCTRL_STATUS_IN_PROGRESS
   0x00, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK
   0x01, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK
   0x02, // DIA_EN_RTCTRL_STATUS_ABORTED
   0xFF  // DIA_EN_RTCTRL_STATUS_TIMED_OUT
};

//------------------------------------------------------------------------------

dia_RoutineCtrlCISSWUpdateStage1::dia_RoutineCtrlCISSWUpdateStage1( void )
   : dia_Routine("dia_RoutineCtrlCISSWUpdateStage1", DIA_C_U16_DID_CENTER_CMC_19_CIS_SW_UPDATE_STAGE1, DIA_EN_RTCTRL_ID_PROJECT_15, DIA_EN_RTCTRL_TYPE_LONG_TERM),
     mSWUpdateOption(0),
     mResultStage1(0),
     mSWUpdateStatus(-1),
     mStarted(false)
    // mUpdateDirection(-1)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::dia_RoutineCtrlCISSWUpdateStage1");
   /*
   CID 13224681 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
   */
}

//------------------------------------------------------------------------------

dia_RoutineCtrlCISSWUpdateStage1::~dia_RoutineCtrlCISSWUpdateStage1( void )
{
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::~dia_RoutineCtrlCISSWUpdateStage1");
}

//-----------------------------------------------------------------------------

void
dia_RoutineCtrlCISSWUpdateStage1::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::vOnServiceTimeout()");
}

//------------------------------------------------------------------------------


tDiaResult
dia_RoutineCtrlCISSWUpdateStage1::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace(" dia_RoutineCtrlCISSWUpdateStage1::start()");

   // prepare processing of the routine
   vInitialize();

   tDiaResult retCode = DIA_FAILED;
   // NRC check for parameter list sent from tester
   if (params.size() != 1)
   {
      DIA_TR_INF("INVALID PARAMETERS");
      return DIA_FAILED;
   }
   mSWUpdateOption =static_cast<tU8>(params[0]);

   mResultStage1 = DEFAULT_RESULT;
   mSWUpdateStatus = DEFAULT_STATUS;

   if(mStarted != true)
   {
       //  tBool errorDetected = TRUE;
      dia_ISWUpdatePrj* pInterface = 0;
      if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            (tVoid) setSysAdapterListener<dia_ISWUpdatePrjListener>(this);

            if (pInterface->getReleaseDoc() == DIA_SUCCESS)
               {
                  // One time request to get the actual value
                  DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::start  getUpdateErrors() OK!");
                  retCode = DIA_SUCCESS;
               }
               else
               {
                  DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::start  getUpdateErrors()  with ERRORS!");
                  (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
               }

            if (pInterface->getUpdateErrors() == DIA_SUCCESS)
               {
                  // One time request to get the actual value
                  DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::start  getUpdateErrors() OK!");
                  retCode = DIA_SUCCESS;
               }
               else
               {
                  DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::start  getUpdateErrors()  with ERRORS!");
                  (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
               }
         }
      }
      else
      {
         DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::start querySysAdapterInterface<dia_ISWUpdatePrjListener> ERROR!");
      }
   }
   else
   {
      DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::start - MIS update already done in the same power cycle!!");
   }
   DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::start retCode = 0x%08X", retCode);
   return retCode;
}

//--------------------------------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlCISSWUpdateStage1::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::requestResult(void)");
   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;
   bool hmiResult=FALSE;
   results.clear();
   if ( !(mResults.empty()) )
   {
      /* this code is executed in case of reply for start request only */
      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      // clear buffer, such reply is necessary once
      mResults.clear();
      // keep the result until new calculation is started
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult (%d)", mStatus);
      switch ( mStatus )
      {
      case DIA_EN_RTCTRL_STATUS_IN_PROGRESS:
      {
         DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::requestResult DIA_EN_RTCTRL_STATUS_IN_PROGRESS:Result=%d",mResultStage1);
         //send what we got last time
         results.push_back(sResultMapping[mStatus]);
         results.push_back(mResultStage1);
         mIsResultReady = TRUE;
         retCode = DIA_SUCCESS;
      }
         break;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      {
         DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::requestResult DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK.");
         //hmi method
         results.push_back(sResultMapping[mStatus]);
         results.push_back(mResultStage1);
         mIsResultReady = TRUE;
         retCode = DIA_SUCCESS;
      }
         break;
      case DIA_EN_RTCTRL_STATUS_ABORTED:
      {
         DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::requestResult DIA_EN_RTCTRL_STATUS_ABORTED.");
         DIA_TR_INF("if start ABORTED, then RequestResults=Sequence error needs to be sent!!!");
         mIsResultReady = TRUE;
         retCode = DIA_E_SEQUENCE_ERROR;
      }
         break;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
      {
         DIA_TR_INF("requestResult: DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK, progress %d", mResultStage1);
         results.push_back(sResultMapping[mStatus]);
         results.push_back(mResultStage1);
         mIsResultReady = TRUE;
         retCode = DIA_SUCCESS;
      }
         break;
      default:
         DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::requestResult mStatus = %d.", mStatus);
         break;
      }
   }
   return retCode;
}

//--------------------------------------------------------------------------------------------------------
void
dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors(dia_eSWUpdatePrjError eError, bool vCheck )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors");
   (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);
   DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors eError = %d, vCheck = %d",eError, vCheck);
   if(vCheck == false && eError == DIA_EN_UPDATE_PRJ_ERROR_DEFAULT_SWL_OK)
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
      RtctrlStatus = DIA_EN_RTCTRL_STATUS_ABORTED;
      DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors Invalid stick ERROR!");

      //2 bytes output
      mResults.push_back(sResultMapping[mStatus]);
      mStatus =  DIA_EN_RTCTRL_STATUS_UNKNOWN;
      mResults.push_back(DIA_EN_UPDATE_PRJ_ERROR_INCOMPATIBLE_STICK);
      mIsResultReady = TRUE;
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
      return;

   }
   switch(eError)
   {
   case DIA_EN_UPDATE_PRJ_ERROR_DEFAULT_SWL_OK:
   case DIA_EN_UPDATE_PRJ_ERROR_SAMEGRADE_STICK:
   {
      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors Valid USB Stick connected");
      mSWUpdateStatus = eError;
      dia_ISWUpdatePrj* pInterface = 0;
      if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            (tVoid) setSysAdapterListener<dia_ISWUpdatePrjListener>(this);
            //Set Release Filter as New and Same Only for UpdateSetReleaseFilter
            if (pInterface->SetReleaseFilter() == DIA_SUCCESS)
            {
                eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
                RtctrlStatus = DIA_EN_RTCTRL_STATUS_IN_PROGRESS;
                DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::start::DIA_EN_RTCTRL_STATUS_IN_PROGRESS:Code=%d",mSWUpdateStatus);
                DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors  SetReleaseFilter() OK!");
            }
            else
            {
               DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors  SetReleaseFilter()  with ERRORS!");
               (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);

               eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
               RtctrlStatus = DIA_EN_RTCTRL_STATUS_ABORTED;
               //abort send status along with errorcode to tester.
               DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors Negative response received from SWUpdate Server!!Error:%d",eError);

               //2 bytes output
               mResults.push_back(sResultMapping[mStatus]);
               mResults.push_back(mSWUpdateStatus);
               mIsResultReady = TRUE;
               dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
            }
         }
      }
      else
      {
         eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
         RtctrlStatus = DIA_EN_RTCTRL_STATUS_ABORTED;
         DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors querySysAdapterInterface<dia_ISWUpdatePrjListener> ERROR!");

         //2 bytes output
         mResults.push_back(sResultMapping[mStatus]);
         mResults.push_back(mSWUpdateStatus);
         mIsResultReady = TRUE;
         dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
      }
   }
   break;
   default:
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
      RtctrlStatus = DIA_EN_RTCTRL_STATUS_ABORTED;
      mSWUpdateStatus = eError;
      //abort send status along with errorcode to tester.
      DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateErrors Negative response received from SWUpdate Server!!Error:%d",eError);

      //2 bytes output
      mResults.push_back(sResultMapping[mStatus]);
      mResults.push_back(mSWUpdateStatus);
      mIsResultReady = TRUE;
      dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
   }
   break;
  }

}

//---------------------------------------------------------------------------------------------------------------------------
void
dia_RoutineCtrlCISSWUpdateStage1::vOnCISswUpdateProcessResult( tBool resultStage1 )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::vOnCISswUpdateProcessResult(tU8)");

   (void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);

   DIA_TR_INF("ResultStage1 %d", resultStage1);
   DIA_TR_INF("mStatus is %d. sResultMapping[mStatus] is %d.", mStatus, sResultMapping[mStatus]);
   //00-->One or more componenets not updated;01 -->All Components updated ;
   if( resultStage1 )
   {
      DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK. Result of SWUpdateStage1 is All components are updated");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      mResultStage1 = 0x01;
   }
   else
   {
      DIA_TR_INF("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK. Result of SWUpdateStage1 is One or more components not updated");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      mResultStage1 = 0x00;
   }
   RtctrlStatus = (DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   mStarted =true;
   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//---------------------------------------------------------------------------------------------------------------------------
void
dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus(tU32 releaseFilter)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus");
   if ((releaseFilter == DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWANDSAMEONLY) || (releaseFilter == DIA_EN_UPDATE_PRJ_UPDATEOPTION_NEWONLY))
   {
      // Expose Diagnosis Interface to HMI:send status request
      dia_IDisplayPatternAIVI *pDisplayPatternInterface = NULL;
      tDiaResult queryResult = querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pDisplayPatternInterface);
      if (DIA_SUCCESS == queryResult)
      {
         if (pDisplayPatternInterface)
         {
            (void)setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
            pDisplayPatternInterface->setCISswUpdateProcessStatus(TRUE);
         }
         else
         {
            eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
            RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
            DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus pDisplayPatternInterface is NULL.");
         }
      }
      else
      {
         eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
         RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
         DIA_TR_ERR("querySysAdapterInterface<dia_IDisplayPatternAIVIListener> ERROR! queryResult=0x%08X", queryResult);
      }

      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:releaseFilter=%d",releaseFilter);
      // CALL 3 SWUPDATE METHODS
      dia_ISWUpdatePrj* pInterface = 0;
      if (querySysAdapterInterface<dia_ISWUpdatePrj>(&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:setAllowRecoveryModeRequest(FALSE)");
            if (pInterface->setAllowRecoveryModeRequest(FALSE) == DIA_SUCCESS)
            { // One time request to get the actual value
               DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:setAllowRecoveryModeRequest() OK!");
            }
            else
            {
               eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
               RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
               DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:setAllowRecoveryModeRequest() failed with Errors!");
            }

            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:SetSoftwareUpdateType(option)");
            if (pInterface->SetSoftwareUpdateType(mSWUpdateOption) == DIA_SUCCESS)
            { // One time request to get the actual value
               DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:SetSoftwareUpdateType() OK!");
            }
            else
            {
               eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
               RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
               DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:SetSoftwareUpdateType() failed with Errors!");
            }
            DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:handleStartDownloadRequest()");
            if (pInterface->handleStartDownloadRequest() == DIA_SUCCESS)
            { // One time request to get the actual value
               DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:handleStartDownloadRequest() OK!");
            }
            else
            {
               eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
               RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
               DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus:handleStartDownloadRequest() failed with Errors!");
            }
         }
      }
      else
      {
    	 eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
       RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
         DIA_TR_ERR("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus querySysAdapterInterface<dia_ISWUpdatePrjListener> ERROR!");
      }
   }
   else
   {
	  eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
     RtctrlStatus = (DIA_EN_RTCTRL_STATUS_ABORTED);
      DIA_TR_INF("dia_RoutineCtrlCISSWUpdateStage1::vOnUpdateReleaseFilterStatus,wrong");
   }

   (void) unsetSysAdapterListener<dia_ISWUpdatePrjListener>(this);

   //2 bytes output
   mResults.push_back(sResultMapping[mStatus]);
   mResults.push_back(mSWUpdateStatus);
   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}
