/*
 * dia_ReadSupportedLocalIdentifiers.h
 *
 *  Created on: 30.11.2010
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_READ_SUPPORTED_LOCAL_IDENTIFIERS__
#define __INCLUDED_DIA_READ_SUPPORTED_LOCAL_IDENTIFIERS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#define DIA_SUPPORTED_LOCID_DATA_UNKNOWN         ((tU32) 0x00000000)

#define DIA_SUPPORTED_LOCID_DATA_A_BIT7          ((tU32) 0x80000000) // 01, 21, 41, 61
#define DIA_SUPPORTED_LOCID_DATA_A_BIT6          ((tU32) 0x40000000) // 02, 22, 42, 62
#define DIA_SUPPORTED_LOCID_DATA_A_BIT5          ((tU32) 0x20000000) // 03, 23, ...
#define DIA_SUPPORTED_LOCID_DATA_A_BIT4          ((tU32) 0x10000000) // 04, 24, ...
#define DIA_SUPPORTED_LOCID_DATA_A_BIT3          ((tU32) 0x08000000) // 05, 25, ...
#define DIA_SUPPORTED_LOCID_DATA_A_BIT2          ((tU32) 0x04000000) // 06, 26, ...
#define DIA_SUPPORTED_LOCID_DATA_A_BIT1          ((tU32) 0x02000000) // 07, 27, ...
#define DIA_SUPPORTED_LOCID_DATA_A_BIT0          ((tU32) 0x01000000) // 08, 28, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT7          ((tU32) 0x00800000) // 09, 29, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT6          ((tU32) 0x00400000) // 0A, 2A, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT5          ((tU32) 0x00200000) // 0B, 2B, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT4          ((tU32) 0x00100000) // 0C, 2C, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT3          ((tU32) 0x00080000) // 0D, 2D, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT2          ((tU32) 0x00040000) // 0E, 2E, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT1          ((tU32) 0x00020000) // 0F, 2F, ...
#define DIA_SUPPORTED_LOCID_DATA_B_BIT0          ((tU32) 0x00010000) // 10, 30, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT7          ((tU32) 0x00008000) // 11, 31, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT6          ((tU32) 0x00004000) // 12, 32, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT5          ((tU32) 0x00002000) // 13, 33, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT4          ((tU32) 0x00001000) // 14, 34, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT3          ((tU32) 0x00000800) // 15, 35, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT2          ((tU32) 0x00000400) // 16, 36, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT1          ((tU32) 0x00000200) // 17, 37, ...
#define DIA_SUPPORTED_LOCID_DATA_C_BIT0          ((tU32) 0x00000100) // 18, 38, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT7          ((tU32) 0x00000080) // 19, 39, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT6          ((tU32) 0x00000040) // 1A, 3A, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT5          ((tU32) 0x00000020) // 1B, 3B, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT4          ((tU32) 0x00000010) // 1C, 3C, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT3          ((tU32) 0x00000008) // 1D, 3D, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT2          ((tU32) 0x00000004) // 1E, 3E, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT1          ((tU32) 0x00000002) // 1F, 3F, ...
#define DIA_SUPPORTED_LOCID_DATA_D_BIT0          ((tU32) 0x00000001) // 20, 40, ...

struct dia_SupportedLocalID
{
   dia_SupportedLocalID ( tVoid ) {
      (tVoid) ::memset(mBitmask,0,sizeof(tU32)*4);
   }

   tU32 mBitmask[4];
};

class dia_ReadSupportedLocalIdentifiers
   : public dia_ServiceHandlerUDS
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_ReadSupportedLocalIdentifiers);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ReadSupportedLocalIdentifiers);

public:
   //! this method is used to register local identifiers
   static tDiaResult addLocalID ( tU8 sid, tU8 lid, tU32 mask );
   //! this method is used to register local identifiers
   static tDiaResult getSupportedLocalIDs ( tU8 sid, tU8 lid, tU32& supportedIDs );

   //! process the received request
   virtual tVoid vOnReqRx ( tVoid );
   //! setup a lookup key for the lookup table
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

public:
   static dia_SupportedLocalID mServiceRep[5];
};

#endif /* __INCLUDED_DIA_READ_SUPPORTED_LOCAL_IDENTIFIERS__ */
