/*
 * dia_MultiplexNetworkDiagRead.cpp
 *
 *  Created on: 22.09.2010
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "project/interfaces/dia_INissanVCanInfo.h"

#ifndef __INCLUDED_DIA_INTERFACE_ERROR_LOG__
#include "common/interfaces/dia_IErrorLog.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_NissanMultiplexNetworkDiagRead.cpp.trc.h"
#endif

#include "dia_NissanMultiplexNetworkDiagRead.h"

#define DIA_INDEX_BUS_OFF                   ((tU8)   2) //lint -esym(750,DIA_INDEX_BUS_OFF)
#define DIA_INDEX_MUTE_ERROR                ((tU8)   3) //lint -esym(750,DIA_INDEX_MUTE)
#define DIA_INDEX_ABSENT_ECM                ((tU8)   4) //lint -esym(750,DIA_INDEX_ABSENT_ECM)
//#define DIA_INDEX_ABSENT_VDC                ((tU8)   5) //lint -esym(750,DIA_INDEX_ABSENT_VDC)
#define DIA_INDEX_ABSENT_BRAKE              ((tU8)   5) //lint -esym(750,DIA_INDEX_ABSENT_BRAKE)
#define DIA_INDEX_ABSENT_CLUSTER            ((tU8)   6) //lint -esym(750,DIA_INDEX_ABSENT_CLUSTER)
#define DIA_INDEX_ABSENT_BCM                ((tU8)   7) //lint -esym(750,DIA_INDEX_ABSENT_BCM)
//#define DIA_INDEX_ABSENT_ADAS               ((tU8)  10) //lint -esym(750,DIA_INDEX_ABSENT_ADAS)
//#define DIA_INDEX_ABSENT_HVAC               ((tU8)  11) //lint -esym(750,DIA_INDEX_ABSENT_HVAC)
//#define DIA_INDEX_ABSENT_ATCVT              ((tU8)  12) //lint -esym(750,DIA_INDEX_ABSENT_ATCVT)
//#define DIA_INDEX_ABSENT_ITM                ((tU8)  13) //lint -esym(750,DIA_INDEX_ABSENT_ITM)
#define DIA_INDEX_ABSENT_RADNAV             ((tU8)  13) //lint -esym(750,DIA_INDEX_ABSENT_RADNAV)
//#define DIA_INDEX_ABSENT_STRG               ((tU8)  17) //lint -esym(750,DIA_INDEX_ABSENT_STRG)
#define DIA_INDEX_ABSENT_USM                ((tU8)  23) //lint -esym(750,DIA_INDEX_ABSENT_USM)
//#define DIA_INDEX_ABSENT_TIREP              ((tU8)  24) //lint -esym(750,DIA_INDEX_ABSENT_TIRE_P)
//#define DIA_INDEX_ABSENT_TPMS               ((tU8)  25) //lint -esym(750,DIA_INDEX_ABSENT_TPMS)
//#define DIA_INDEX_ABSENT_RCU                ((tU8)  28) //lint -esym(750,DIA_INDEX_ABSENT_RCU)
//#define DIA_INDEX_ABSENT_SBCM               ((tU8)  35) //lint -esym(750,DIA_INDEX_ABSENT_SMART_BCM)
//#define DIA_INDEX_ABSENT_RAS                ((tU8)  43) //lint -esym(750,DIA_INDEX_ABSENT_RAS)
//#define DIA_INDEX_ABSENT_SONAR              ((tU8)  44) //lint -esym(750,DIA_INDEX_ABSENT_SONAR)
#define DIA_INDEX_ABSENT_USA                ((tU8)  44) //lint -esym(750,DIA_INDEX_ABSENT_USA)
//#define DIA_INDEX_ABSENT_HCM                ((tU8)  51) //lint -esym(750,DIA_INDEX_ABSENT_HCM)
//#define DIA_INDEX_ABSENT_DSC                ((tU8)  69) //lint -esym(750,DIA_INDEX_ABSENT_DSC)
#define DIA_INDEX_ABSENT_TCU                ((tU8)  72) //lint -esym(750,DIA_INDEX_ABSENT_TCU)
//#define DIA_INDEX_ABSENT_AVM                ((tU8)  86) //lint -esym(750,DIA_INDEX_ABSENT_AVM)
//#define DIA_INDEX_ABSENT_IDM                ((tU8)  87) //lint -esym(750,DIA_INDEX_ABSENT_IDM)
//#define DIA_INDEX_ABSENT_AHL                ((tU8)  45) //lint -esym(750,DIA_INDEX_ABSENT_AHL)

static tU8 msgDefaultContent[RSID_LENGTH] = {
#if 0
      0x53, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, //9
      0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//19
      0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//29
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//39
      0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//49
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//59
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//69
      0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//79
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//89
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//99
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//109
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//119
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//129
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,//139
#else
      0x53, 0x48, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //9
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //19
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //29
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //39
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //49
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //59
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //69
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //79
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //89
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //99
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //109
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //119
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //129
      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, //139
#endif
      };

//------------------------------------------------------------------------------

dia_MultiplexNetworkDiagRead::dia_MultiplexNetworkDiagRead(void) :
      dia_ServiceHandlerUDS("dia_MultiplexNetworkDiagRead", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, (tU16) DIA_C_U16_DID_AIVI_MULTIPLEX_NETWORK_DIAG), completionMask(0x00)
{
   dia_tclFnctTrace oTrace("dia_MultiplexNetworkDiagRead::dia_MultiplexNetworkDiagRead()");
   (void) ::memset(&responseData[0], 0, RSID_LENGTH);
}

//------------------------------------------------------------------------------

dia_MultiplexNetworkDiagRead::~dia_MultiplexNetworkDiagRead(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_INissanVCanInfoListener>(this);
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_MultiplexNetworkDiagRead::~dia_MultiplexNetworkDiagRead !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

//-----------------------------------------------------------------------------
//  Msg contents:
//      byte[0] = Number of bytes in message
//      byte[1] = Service ID
//      byte[2] = DID

void dia_MultiplexNetworkDiagRead::vProcessRequest(const std::vector<void*>& /*vecArgs*/)
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vProcessRequest");

   (void) setSysAdapterListener<dia_INissanVCanInfoListener>(this);

   completionMask = 0x00;

   (void) ::memcpy(&responseData[0], &msgDefaultContent[0], RSID_LENGTH);

//   // check if we have received the right coding value length
//   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
//   if (dataLength != RSID_START) {
//      vSendNegativeResponse(DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED);
//      return;
//   }

   dia_INissanVCanInfo* pVInfo = OSAL_NULL;

   if ((querySysAdapterInterface<dia_INissanVCanInfo>(&pVInfo) == DIA_SUCCESS) && pVInfo &&
         (pVInfo->getNissanVCANInfo() == DIA_SUCCESS))
   {
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vProcessRequest - Successfully sent getNissanVCANInfo request");
   }
   else
   {
      DIA_TR_ERR("dia_MultiplexNetworkDiagRead::vProcessRequest - getNissanVCANInfo request failed. Pointer: %x", (tU32) pVInfo);
      (void) unsetSysAdapterListener<dia_INissanVCanInfoListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

}

//-----------------------------------------------------------------------------

void
dia_MultiplexNetworkDiagRead::vGetITCInfo()
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vGetITCInfo");

   dia_IErrorLog* pErrorLog = OSAL_NULL;

   if ((querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS) && (pErrorLog != OSAL_NULL))
   {
      std::vector<tU16> oITCList;

      ETG_TRACE_COMP(("dia_MultiplexNetworkDiagRead::vGetITCInfo - prepare oITCList based on responseData: %02x",
            ETG_LIST_LEN(RSID_LENGTH - DIA_INDEX_BUS_OFF),
            ETG_LIST_PTR_T8(const_cast<tU8*>(&responseData[DIA_INDEX_BUS_OFF]))
            ));

      // read available devices info from diaglog.
      for(tU8 i=DIA_INDEX_BUS_OFF; i<RSID_LENGTH; i++)
      {
         if(responseData[i]==0xFF)
         {
//            DIA_TR_INF("dia_MultiplexNetworkDiagRead::vGetITCInfo [%d] = 0xFF. Device not covered by vehicle data.", i);
            continue;   // go back to for-loop for next element
         }

         tU8 counterValue = responseData[i] & 0x3F;
//         DIA_TR_INF("dia_MultiplexNetworkDiagRead::vGetITCInfo [%d] Analyze component value 0x%02x (counter value = 0x%02x).", i, responseData[i], counterValue);
         if ((counterValue == 42) //Get decrementing M_XXX from Diaglog
               || (counterValue == 40)) //Get non-decrementing M_XXX from Diaglog
         {
            tU16 u16ITC = (tU16)(ITC_AIVI_VCAN_START + i);
//            DIA_TR_INF("dia_MultiplexNetworkDiagRead::vGetITCInfo [%d] shall be read from Diaglog. ITC=0x%04x.", i, u16ITC);
            oITCList.push_back(u16ITC);
         }
      }

      ETG_TRACE_COMP(("dia_MultiplexNetworkDiagRead::vGetITCInfo - oITCList: %04x",
            ETG_LIST_LEN(oITCList.size()),
            ETG_LIST_PTR_T16(const_cast<tU16*>(&oITCList[0]))
            ));   //lint !e864: Expression involving variable possibly depends on order of evaluation

      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      if (pErrorLog->getItcInformation(DIAGLOG_MEMORY_CUSTOMER, oITCList) == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_MultiplexNetworkDiagRead::vGetITCInfo - Read %d ITCs at getItcInformation.", oITCList.size());
      }
      else
      {
         DIA_TR_ERR("dia_MultiplexNetworkDiagRead::vGetITCInfo - bGetITCInfo request failed. Pointer: %x", (tU32) pErrorLog);
         (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
   }
}

//-----------------------------------------------------------------------------

void
dia_MultiplexNetworkDiagRead::vOnVCanInfo ( const std::list<tU8>& deviceInfoList )
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vOnVCanInfo(list<tU8>)");

   (void) unsetSysAdapterListener<dia_INissanVCanInfoListener>(this);

   if(deviceInfoList.size()==RSID_LENGTH)
   {
      // store component data to read Diaglog info
      tU8 i = 0;
      std::list<tU8>::const_iterator it = deviceInfoList.begin();
      for ( ; it != deviceInfoList.end(); it++)
      {
         DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnVCanInfo Read element [%d]=0x%02x in list.size=%d.", i, *it, deviceInfoList.size());
         responseData[i] = *it;
         i++;
      }
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnVCanInfo Component data stored.");
   }
   else
   {
      DIA_TR_ERR("dia_MultiplexNetworkDiagRead::vOnVCanInfo Component info INCOMPLETE !");
   }

   vGetITCInfo();
}

//-----------------------------------------------------------------------------

void
dia_MultiplexNetworkDiagRead::vOnVCanInfo(const dia_NissanVCanInfo& nwInfo)
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vOnVCanInfo(dia_NissanVCanInfo)");

   (void) unsetSysAdapterListener<dia_INissanVCanInfoListener>(this);

   for (tU8 i = DIA_INDEX_BUS_OFF; i < RSID_LENGTH; i++)
   {
      responseData[i] = nwInfo.getDiagByte(i);
//      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnVCanInfo => responseData[%d]=0x%02x", i, responseData[i]);
   }

   vGetITCInfo();
}

//-----------------------------------------------------------------------------

void
dia_MultiplexNetworkDiagRead::vOnITCInfo(const std::vector<dia_tITCInfo>& roITCInfoList)
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vOnITCInfo");

   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnITCInfo received %d ITC information sets.", roITCInfoList.size());

#if 0
   for(tU8 i = 0; i < roITCInfoList.size(); ++i)
   {
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnITCInfo ITC 0x%04x for position has counter 0x%08x .", roITCInfoList[i].m_u16ITC, roITCInfoList[i].m_u16ITC-ITC_AIVI_VCAN_START, roITCInfoList[i].m_u32AgeingCounter);
      // Beside the first two bits the item is empty so you can just add it
      responseData[roITCInfoList[i].m_u16ITC-ITC_AIVI_VCAN_START] += (tU8) roITCInfoList[i].m_u32AgeingCounter;
   }
#else
   for(::size_t i = 0; i < roITCInfoList.size(); ++i)
   {
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vOnITCInfo [%d] ITC=0x%04x.", i, roITCInfoList[i].m_u16ITC);

      vAssembleDiagByte((tU8) (roITCInfoList[i].m_u16ITC - ITC_AIVI_VCAN_START),
            roITCInfoList[i].m_u32AgeingCounter, roITCInfoList[i].m_u8Status);
   }
#endif

   vAssemblePositiveResponse();
}

//-----------------------------------------------------------------------------

void dia_MultiplexNetworkDiagRead::vAssembleDiagByte(tU8 u8Index, tU32 u32AgeingCounter, tU8 u8Status)
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vAssembleDiagByte");
   const tU8 c_maxAge = 40;
   const tU8 c_confirmedBit = 0x08;
   const tU8 c_faultCountMask = 0x3f;
   const tU8 c_confirmedMask = 0xc0;
   const tU8 c_maskedMask = 0xff;

   DIA_TR_INF("dia_MultiplexNetworkDiagRead::vAssembleDiagByte - Pos [%d], AgeingCounter=%d, Status=0x%02x.",
         u8Index, u32AgeingCounter, u8Status);
   DIA_TR_INF("dia_MultiplexNetworkDiagRead::vAssembleDiagByte - responseData before: 0x%02x", responseData[u8Index]);

   // byte is masked so return
   if (responseData[u8Index] == c_maskedMask)
   {
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vAssembleDiagByte - byte is masked so return.");
      return;
   }

   tU32 faultCount = 0;
   // if error is confirmed in diaglog compute M_xxx
   if (u8Status & c_confirmedBit)
   {
      tU8 u8Hint = responseData[u8Index] & c_faultCountMask;
      //Decide wether to decrement
      if (u8Hint == 40)
      {
         faultCount = c_maxAge;
      }
      else if (u8Hint == 42)
      {
         faultCount = (u32AgeingCounter == c_maxAge) ? 1 : c_maxAge - u32AgeingCounter;
      }
      DIA_TR_INF("dia_MultiplexNetworkDiagRead::vAssembleDiagByte - faultCount: %d", faultCount);
   }

   tU8 diagByte = faultCount & c_faultCountMask;
   responseData[u8Index] &= c_confirmedMask;
   responseData[u8Index] |= diagByte;

   DIA_TR_INF("dia_MultiplexNetworkDiagRead::vAssembleDiagByte - responseData after: 0x%02x", responseData[u8Index]);
}

//-----------------------------------------------------------------------------

void dia_MultiplexNetworkDiagRead::vAssemblePositiveResponse(void)
{
   dia_tclFnctTrace trc("dia_MultiplexNetworkDiagRead::vAssemblePositiveResponse");

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(3+RSID_LENGTH);

   for (tU16 i = 0; i < RSID_LENGTH; ++i)
   {
      (void) oDiagMsgBuffer().vSetDataU8(i + 3, responseData[i]);
   }
   vResReadyAndQuit();
}

