/*
 * \file        dia_NissanEcuResetKeyOnOffReset.h
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi, stc2hi
 * \date        May 13, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */


#ifndef DIA_NISSAN_ECU_RESET_KEY_ON_OFF_RESET_H_
#define DIA_NISSAN_ECU_RESET_KEY_ON_OFF_RESET_H_

#ifndef __INCLUDED_DIA_ECURESET_PLUGIN__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#ifndef DIA_ECU_RESET_KEY_ON_OFF_RESET_H_
#include "common/services/uds/production/dia_EcuResetKeyOnOffReset.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS_LISTENER__
#include <common/interfaces/dia_ISystemSettingsListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RUNLEVEL_LISTENER__
#include <common/interfaces/dia_IRunLevelListener.h>
#endif

class dia_NissanEcuResetKeyOnOffReset
      : public dia_EcuResetKeyOnOffReset,
        public dia_ISystemSettingsListener,
        public dia_IRunLevelListener
{
public:
   //! class constructor
   dia_NissanEcuResetKeyOnOffReset ( tCString name, dia_ResetType resetType );
   //! class destructor
   virtual ~dia_NissanEcuResetKeyOnOffReset ( void );

   //
   // overload methods from class dia_EcuResetKeyOnOffReset
   //

   //
   // This function makes following actions:
   // 1. Trigger calculation of configuration hash
   // 2. Perform KDS flush.
   // 3. Execute SystemSettings(Alignment/Calibration)
   // 4. Perform standard KeyOffOn reset.
   //
   virtual tDiaResetResponse handleRequest ( void );

   //
   // overload methods from class dia_ISystemSettingsListener
   //
   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, void* cookie );

   //! overloaded method from dia_IRunLevelListener
   virtual void vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel );

   /*
    *  Overloaded dia_ISpmListenerImpl methods
    */
   virtual void vOnSystemRestart ( tDiaResult success );

   //
   // overload methods from class dia_EcuResetKeyOnOffReset (dia_EcuResetPlugin)
   //
   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 60000; }

protected:
   //! deprecated class constructor
   dia_NissanEcuResetKeyOnOffReset ( tCString name );

   //! deprecated class constructor
   dia_NissanEcuResetKeyOnOffReset ( void );
};

#endif /* DIA_NISSAN_ECU_RESET_KEY_ON_OFF_RESET_H_ */
