/*
 * dia_IOCtrlSpeakerTest.h
 *
 *  Created on: 09.09.2015
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRL_SPEAKER_TEST_H_
#define DIA_IOCTRL_SPEAKER_TEST_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOTEST_LISTENER__
#include "common/interfaces/dia_IAudioTestListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

class dia_IOCtrlSpeakerTest
   : public dia_IOCtrlSignal,
     public dia_IAudioTestListenerImpl,
     public dia_ITimerListener
{
public:
   //! class constructor
   dia_IOCtrlSpeakerTest ( void );
   //! class destructor
   virtual ~dia_IOCtrlSpeakerTest ( void );
   //! handles service request coming from tester / system
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! handles IOCtrl timeout
   virtual void handleTimeout ( void );
   //! read if IOCtrl signal is frozen
   virtual bool isFrozen ( void ) const {return true;}

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );
   //! response to startLoudspeakerTest
   virtual void vOnLoudspeakerTest ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //! timer used for sending of reply (6 seconds -- DTC shall be set by audio component)
   dia_Timer mTimer;

   //! last requested mode
   dia_eAudioTestMode mLastAudioMode;

   //! Increased timeout because project A-IVI standard timeout is too small
   virtual tU32 getMaxProcessingTime ( void ) const { return sMaxProcessingTimeMs; }

   static const tU32 sProcessingTimeoutMs = 10*1000;      //10 seconds
   static const tU32 sMaxProcessingTimeMs = 20*1000;     //20 seconds
};

#endif /* DIA_IOCTRL_SPEAKER_TEST_H_ */
