/*
 * dia_IOCtrlLoudspeakerTestTone.h
 *
 *  Created on: 28.07.2015
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRL_LOUDSPEAKER_TEST_TONE_H_
#define DIA_IOCTRL_LOUDSPEAKER_TEST_TONE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#include "common/interfaces/dia_IAudioListener.h"
#endif

class dia_IOCtrlLoudspeakerTestTone
   : public dia_IOCtrlSignal,
	  public dia_IAudioListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlLoudspeakerTestTone ( void );
   //! class destructor
   virtual ~dia_IOCtrlLoudspeakerTestTone ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //!
   virtual bool isFrozen ( void ) const {return true;}


   //-------------------------------------------------------------------------
   //
   // overloaded methods from dia_IRVCListenerImpl base class
   //
   //-------------------------------------------------------------------------

   //! response to dia_setAudioTestTone for customer loudspeaker test
   virtual void vOnLoudspeakerTestTone ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

};


#endif /* DIA_IOCTRL_LOUDSPEAKER_TEST_TONE_H_ */
