/*
 * dia_IOCtrlLoudspeakerTestTone.cpp
 *
 *  Created on: 28.07.2015
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 07 2F 90 02 03 01 10 05

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "project/services/customer/dia_IOCtrlLoudspeakerTestTone.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
#define DATA_LENGTH 3
#define VOLUME_LEVEL_RANGE_MINIMUM_VALUE  ((tS16)-128)
#define VOLUME_LEVEL_RANGE_MINIMUM_STEP   ((tS16)8)
//------------------------------------------------------------------------------

dia_IOCtrlLoudspeakerTestTone::dia_IOCtrlLoudspeakerTestTone ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlLoudspeakerTestTone",
		 DIA_C_U16_DID_AIVI_LOUDSPEAKER_TEST_TONE,
         DATA_LENGTH, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlLoudspeakerTestTone::~dia_IOCtrlLoudspeakerTestTone ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlLoudspeakerTestTone::~dia_IOCtrlLoudspeakerTestTone !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlLoudspeakerTestTone::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlLoudspeakerTestTone::handleRequest()");
   tBool errorDetected = TRUE;
   tBool errorParameter = FALSE;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(timerValue); /* will not report Lint error */
//   DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest ctrlValue->size() = %d .", ctrlValue->size());

   /* LOUDSPEAKER */
   tU8 speaker = DIA_AUDIO_CHANNEL_MASK_NONE;
   switch(ctrlValue->at(0)){
      case 0x01:
         speaker = DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT;
         DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest Choose LOUDSPEAKER_FRONT_LEFT .");
         break;
      case 0x02:
         speaker = DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT;
         DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest Choose LOUDSPEAKER_FRONT_RIGHT .");
         break;
      case 0x03:
         speaker = DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT;
         DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest Choose LOUDSPEAKER_REAR_RIGHT .");
         break;
      case 0x04:
         speaker = DIA_AUDIO_CHANNEL_MASK_REAR_LEFT;
         DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest Choose LOUDSPEAKER_REAR_LEFT .");
         break;
      case 0x05:
         speaker = DIA_AUDIO_CHANNEL_MASK_SUBWOOFER;
         DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest Choose LOUDSPEAKER_SUBWOOFER .");
         break;
      default:
         DIA_TR_ERR("dia_IOCtrlLoudspeakerTestTone::handleRequest UNKNOWN SPEAKER 0x%02x !", ctrlValue->at(0));
         errorParameter = TRUE;
         break;
   }

   /* FREQUENCY */
   tU32 frequency = 0;
   if(ctrlValue->at(1)>0 && ctrlValue->at(1)<=0x64){
      frequency = ctrlValue->at(1)*100; // according CDD factor is "100"
      DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest frequency = %d / 0x%04x .", frequency, frequency);
   } else {
      DIA_TR_ERR("dia_IOCtrlLoudspeakerTestTone::handleRequest frequency = %d / 0x%04x ERROR!", frequency, frequency);
      errorParameter = TRUE;
   }

   /* Volume */
   tU8 volume = 0;
   if(ctrlValue->at(2)<=VOLUME_INCREMENT_LEVEL_MAX){
      volume = ctrlValue->at(2);
      DIA_TR_INF("dia_IOCtrlLoudspeakerTestTone::handleRequest volume = %d / 0x%04x in range.", volume, volume);
   } else {
      DIA_TR_ERR("dia_IOCtrlLoudspeakerTestTone::handleRequest volume = %d / 0x%04x ERROR (MAX=%d)!", volume, volume, VOLUME_INCREMENT_LEVEL_MAX);
      errorParameter = TRUE;
   }

   // check if any error occurs till now
   if (errorParameter == FALSE) {
      dia_IAudio* pInterface = 0;
      if (querySysAdapterInterface < dia_IAudio > (&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (void) setSysAdapterListener < dia_IAudioListener > (this);
            if (pInterface->setAudioTestToneIncrement(frequency, volume, speaker) == DIA_SUCCESS) {
               errorDetected = FALSE;
            }
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener < dia_IAudioListener > (this);
      DIA_TR_ERR("dia_IOCtrlLoudspeakerTestTone --- SEND TO AUDIO SERVER FAILED !!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(timerValue); //IVI specific

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlLoudspeakerTestTone::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlLoudspeakerTestTone::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }

      dia_IAudio* pInterface = 0;
      if ( querySysAdapterInterface<dia_IAudio>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (void) setSysAdapterListener<dia_IAudioListener>(this);
            if ( pInterface->setAudioTestToneMute(DIA_EN_AUDIO_VOLUME_TYPE_INCREMENT) != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SUBSTATE !!!");
            }
         }
      }
   }

   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlLoudspeakerTestTone::vOnLoudspeakerTestTone ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlLoudspeakerTestTone::vOnLoudspeakerTestTone");
   if(success==DIA_SUCCESS){
      (void) unsetSysAdapterListener<dia_IAudioListener>(this);
      mIsResultReady = TRUE;
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   } else {
      DIA_TR_ERR("dia_IOCtrlLoudspeakerTestTone::vOnLoudspeakerTestTone NEGATIVE RESULT FROM SA !!!");
   }
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlLoudspeakerTestTone::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlLoudspeakerTestTone::handleTimeout");
   (void) unsetSysAdapterListener<dia_IAudioListener>(this);
}
