/*
 * dia_IOCtrlDisplayTest.h
 *
 *  Created on: 12.01.2014
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL_DISPLAY_TEST_H__
#define __INCLUDED_DIA_IOCTRL_DISPLAY_TEST_H__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlDisplayTest
	: public dia_IOCtrlSignal,
  public dia_IDisplayPatternAIVIListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlDisplayTest ( void );
   //! class destructor
   virtual ~dia_IOCtrlDisplayTest ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );

   //!
   virtual bool isFrozen ( void ) const {return true;}

   virtual void vOnSetDisplayTestPatternDone ( tDiaResult u32Res );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //!
   virtual dia_eDisplayPatternAIVIID getDisplayPatternID ( tU8 u8CtrlValue );

   tDiaResult setScreen(dia_eDisplayPatternAIVIID eScreen);
};

#endif // __INCLUDED_DIA_IOCTRL_DISPLAY_TEST_H__
