/*
 * dia_IOCtrlCDEject.cpp
 *
 *  Created on: 13.01.2016
 *      Author: gpu2kor
 //TTFis:> DIA_REQ UDS 07 2F 90 00 03 FF
 *                                  (00..FF) -> eject CD
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "project/services/customer/dia_IOCtrlCDEject.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

//------------------------------------------------------------------------------

dia_IOCtrlCDEject::dia_IOCtrlCDEject ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlCDEject",
		 DIA_C_U16_DID_AIVI_CD_EJECT,
		 CTRL_VALUE_SIZE, // Length in Byte
         DIA_EN_IOCTRL_CTRLMODE_TESTER, // No freeze is necessary ; Tester is responsible for preconditions
         DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT
        )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlCDEject::~dia_IOCtrlCDEject ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlCDEject::~dia_IOCtrlCDEject !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDEject::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCDEject::handleRequest()");
   tBool errorDetected = TRUE;

  // dia_eRVCControl_ControlLine rvcInputMode = DIA_EN_RVCCONTROL_CONTROLLINE_UNKNOWN;
   DIA_TR_INF("dia_IOCtrlCDEject::handleRequest ctrlValue = %d .", ctrlValue->at(0));

   dia_IVDMMGR* pInterface = NULL;
   if (querySysAdapterInterface < dia_IVDMMGR > (&pInterface) == DIA_SUCCESS) {
	   DIA_TR_INF("dia_IOCtrlCDEject::handleRequest -- 1.");
      if (pInterface) {
		  DIA_TR_INF("dia_IOCtrlCDEject::handleRequest -- 2.");
         (void) setSysAdapterListener < dia_IVDMMGRListener > (this);
         //switch(ctrlValue->at(0)){
         //   case 0x00:
         //   	rvcInputMode = DIA_EN_RVCCONTROL_CONTROLLINE_OFF;
         //      DIA_TR_INF("dia_IOCtrlCDEject::handleRequest DEACTIVATE RVC 0x%02x.", ctrlValue->at(0));
         //      break;
         //   default:
         //      DIA_TR_ERR("dia_IOCtrlCDEject::handleRequest ACTIVATE RVC 0x%02x !", ctrlValue->at(0));
         //      rvcInputMode = DIA_EN_RVCCONTROL_CONTROLLINE_ON;
         //      break;
         //}
         if (pInterface->ejectCD() == DIA_SUCCESS) {
			 DIA_TR_INF("dia_IOCtrlCDEject::handleRequest -- 3.");
            errorDetected = FALSE;
         }
      }
   }
   if (errorDetected) {
      (void) unsetSysAdapterListener < dia_IVDMMGRListener > (this);
      DIA_TR_ERR("dia_IOCtrlCDEject::handleRequest --- SEND TO MEDIA MANAGER SERVER FAILED !!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(timerValue); //IVI specific

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDEject::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCDEject::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   // if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   // {
      // if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      // {
         // // we have to wait for the response
		 // DIA_TR_INF("dia_IOCtrlCDEject::vOnTerminate -- wait for response.");
         // mIsResultReady = FALSE;
	  // }
		 
   // }

   // this ioctrl is controlled by the external tester
   //eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);
   
   // we must not wait for a response
   mIsResultReady = TRUE;

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlCDEject::vOnControlEject ( tDiaResult result )
{
   dia_tclFnctTrace trc("dia_IOCtrlCDEject::vOnControlEject");
  
   (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
   mIsResultReady = TRUE;

   if(result==DIA_SUCCESS){
     DIA_TR_INF("dia_IOCtrlCDEject::vOnControlEject -- success.");
   } else {
	  setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlCDEject::vOnControlEject NEGATIVE RESULT FROM SA !!!");
   }
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlCDEject::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlCDEject::handleTimeout");
   (void) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
}
