/*
 * dia_GenericConfigItemVarLengthWrite.cpp
 *
 *  Created on: 14.09.2015
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_CRC_CALCULATOR__
#include "common/framework/utils/dia_CRCCalculator.h"
#endif

#include "dia_GenericConfigItemVarLengthWrite.h"

#define DATA_START      4
#define CHUNK_SIZE      230

//------------------------------------------------------------------------------

dia_GenericConfigItemVarLengthWrite::dia_GenericConfigItemVarLengthWrite ( tCString name, tU8 sid, tU16 did, tBool bCheckCrc )
   : dia_TestService(name, sid, did),
     mpPropInfo(NULL),
     mbCheckCrc(bCheckCrc)
{
    dia_tclFnctTrace oTrace("dia_GenericConfigItemVarLengthWrite::dia_GenericConfigItemVarLengthWrite(name, sid, did)");
}

//------------------------------------------------------------------------------

dia_GenericConfigItemVarLengthWrite::~dia_GenericConfigItemVarLengthWrite ( void )
{
   mpPropInfo = NULL;

   _BP_TRY_BEGIN
   {
      mChunkBuffer.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_GenericConfigItemVarLengthWrite::~dia_GenericConfigItemVarLengthWrite !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
dia_GenericConfigItemVarLengthWrite::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_GenericConfigItemVarLengthWrite::vProcessRequest");

   if (vecArgs.size() == 1)
   {
      // Initial State of the ServiceHandler: Request comes from the tester to write a chunk of data,
      // the corresponding Config Item is assigned by the Service Factory and transmitted in vecArgs[0]

      tU32 u32PropId = (tU32) vecArgs[0];

      dia_PropertyInfo* pPropInfo = NULL;
      dia_ConfigManager* pConfigManager = getInstanceOfConfigManager();
      if (pConfigManager &&
            (NULL != (pPropInfo = pConfigManager->getPropertyInfo(u32PropId))) &&
            (u32PropId == pPropInfo->mPropKey))
      {
         if (!mpPropInfo)
         {
            // First transmitted chunk
            mpPropInfo = pPropInfo;

            DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => First chunk for ConfigItem=0x%x", mpPropInfo->mPropKey);
            DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => ConfigItem maxSize=%d", mpPropInfo->mPropSize);
         }
      }
      else
      {
         DIA_TR_ERR("dia_GenericConfigItemVarLengthWrite::vProcessRequest invalid ConfigItem (0x%x)", u32PropId);
         vSendNegativeResponse(DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED);
         return;
      }

      // extract the data from the received message
      tU16 chunk = oDiagMsgBuffer().u16GetSubServiceId();
      tU32 dataLength = oDiagMsgBuffer().u16GetDataLength() - DATA_START;
      tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
      tU32 chunkOffset = 0;
	  DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest mDID=%d", mDID);
      chunk -= mDID;

      if (chunk == 0)
      {
         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest Complete Len=%d", dataLength);

         // Resize if needed
         if (mChunkBuffer.size() < dataLength)
         {
            mChunkBuffer.resize(dataLength, 0);
         }
      }
      else
      {
         chunk--;

         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest ChunkNo=%d, Len=%d", chunk, dataLength);

         if (dataLength > CHUNK_SIZE)
         {
            DIA_TR_ERR("dia_GenericConfigItemVarLengthWrite::vProcessRequest invalid length (%d > %d)", dataLength, CHUNK_SIZE);
            vSendNegativeResponse(DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED);
            return;
         }

         chunkOffset = chunk * CHUNK_SIZE;
         tU32 newSize = chunkOffset + dataLength;

         // Resize if needed
         if (mChunkBuffer.size() < newSize)
         {
            mChunkBuffer.resize(newSize, 0);
         }
      }

      // Put the chunk into the buffer
      for (tU32 i = 0; i < dataLength; i++)
      {
         mChunkBuffer[chunkOffset + i] = pU8[DATA_START + i];
      }

      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START-1);
      vResReadyAndQuit();
   } //if (vecArgs.size() == 1)

   if (vecArgs.size() == 0)
   {
      // Final State of the ServiceHandler: Request comes from the Test Framework to check all chunks,
      // calculate the CRC and write the data to the Config Item

      DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => Flush chunks for DID = 0x%x...", mDID);

      tU32 u32BufSize = mChunkBuffer.size();

      if ((mpPropInfo == NULL) && (u32BufSize == 0))
      {
         //No chunk has ever been written
         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => Nothing to do!!!");
         return;
      }

      tBool bWrite = TRUE;

      if (mbCheckCrc == TRUE)
      {
         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => Check chunks (Total size=%d)", u32BufSize);

         // Get the CRC from the chunk buffer (last two bytes) and calculate the CRC
         tU16 dataCRC = 0, calcCRC = 0;
         if (u32BufSize >= 2)
         {
            //little endian: LSB is first in the bitstream
            dataCRC |= (mChunkBuffer[u32BufSize - 2]);
            dataCRC |= (mChunkBuffer[u32BufSize - 1] << 8);
         }

         dia_CRCCalculator* pCrcCalc = getInstanceOfCRCCalculator();
         if (pCrcCalc)
         {
            calcCRC = pCrcCalc->calcCrCCITT(mChunkBuffer.data(), (tU16)(u32BufSize-2));
         }
         else
         {
            DIA_TR_ERR("dia_GenericConfigItemVarLengthWrite::vProcessRequest => pCrcCalc NULL PTR!");
         }

         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest dataCRC=0x%04x, calcCRC=0x%04x", dataCRC, calcCRC);

         if (dataCRC != calcCRC)
         {
            // CRC Error
            DIA_TR_ERR("dia_GenericConfigItemVarLengthWrite::vProcessRequest => CRCs do NOT match!");
            bWrite = FALSE;
         }
      }

      if ((bWrite == TRUE) && mpPropInfo)
      {
         // Write the buffer into the Config Item
         DIA_TR_INF("dia_GenericConfigItemVarLengthWrite::vProcessRequest => Write to ConfigItem=0x%x (max=%d)",
               mpPropInfo->mPropKey, mpPropInfo->mPropSize);

         dia_ConfigManager* pConfigManager = getInstanceOfConfigManager();

         if (pConfigManager && (pConfigManager->setProperty(mpPropInfo->mPropKey, mChunkBuffer) == DIA_SUCCESS))
         {
            //OK
         }
         else
         {
            DIA_TR_ERR("dia_GenericConfigItemVarLengthWrite: FAILED to write to ConfigManager!!");
         }
      }

      // Clean the buffer and the Config Item info
      mChunkBuffer.clear();
      mpPropInfo = NULL;

   } //if (vecArgs.size() == 0)
}

//-----------------------------------------------------------------------------

void
dia_GenericConfigItemVarLengthWrite::vOnTimeout ( void )
{
   dia_tclFnctTrace trc("dia_GenericConfigItemVarLengthWrite::vOnTimeout");

   vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
}

//------------------------------------------------------------------------------
const std::map<const tU16, const tU16> dia_GenericConfigItemVarLengthWrite::_Conflict_DID_to_PrjSpecific_DID_Map = 
{
//  { Conflicting DID, Project Specific Map DID }
	{ DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D010, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D010},
	{ DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D002, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D002}
};
//------------------------------------------------------------------------------

tDiaResult
dia_GenericConfigItemVarLengthWrite::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
   dia_tclFnctTrace trc("dia_GenericConfigItemVarLengthWrite::makeLookupKeys");

#if 0 //Full 20K
   for (tU8 u8SubDID = 0; u8SubDID < 93; u8SubDID++)
#else //Only 4K
   for (tU8 u8SubDID = 0; u8SubDID < 19; u8SubDID++)
#endif
   {
	  auto it = _Conflict_DID_to_PrjSpecific_DID_Map.find((mDID | u8SubDID));
	
	  if(it != _Conflict_DID_to_PrjSpecific_DID_Map.end())
	  {
	  	keys.push_back( OSAL_NEW dia_LookupKey( mSID, (tU16)it->second, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
	  }
	  else
	  {
		keys.push_back( OSAL_NEW dia_LookupKey( mSID, (tU16)(mDID | u8SubDID), DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
	  }
   }

   return DIA_SUCCESS;
}

