/*
 * \file        dia_EcuResetConfigToDeliveryState.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      wgl2hi
 * \date        May 12, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_TEST_CONTROLLER__
#include "common/framework/test/dia_TestController.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFAULT_CONFIGURATION__
#include "project/framework/config/dia_DefaultConfiguration.cpp"
#endif

#include "project/services/customer/dia_EcuResetConfigToDeliveryState.h"

#define DIA_ANTITHEFT_INACTIVE (0)  //according to CDD

//------------------------------------------------------------------------------

dia_EcuResetConfigToDeliveryState::dia_EcuResetConfigToDeliveryState ( tCString name, dia_ResetType resetType )
   : dia_EcuResetPlugin ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_EcuResetConfigToDeliveryState::dia_EcuResetConfigToDeliveryState()");
}

//------------------------------------------------------------------------------

dia_EcuResetConfigToDeliveryState::~dia_EcuResetConfigToDeliveryState ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_EcuResetConfigToDeliveryState::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_EcuResetConfigToDeliveryState::handleRequest()");
   tDiaResult retCode = DIA_FAILED;

   const dia_ConfigToDeliveryInfo *pConfigToDeliveryRep = dia_DefaultConfiguration::getConfigToDeliveryRep();
   tU32 u32ConfigSize = dia_DefaultConfiguration::getConfigToDeliveryRepSize();

   tU32 i;
   for ( i = 0; i < u32ConfigSize; i++)
   {
      tU32 currProp = pConfigToDeliveryRep[i].mCurrentProp;

      if (DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION!=currProp)
      {
         retCode = setDefaultConfigItem(currProp, pConfigToDeliveryRep[i].mDefaultProp);
      }
      else
      {
         DIA_TR_INF( "skip DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION only if antitheft is active");

         retCode = DIA_FAILED;

         tU32 propSize = dia_getPropertySize(DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION);
         if (DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH==propSize)
         {
            tU8 aiviTheftParam[DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH] = { 0 };
            tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION, aiviTheftParam, DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH);
            if (DIA_SUCCESS==getPropRes)
            {
               if (DIA_ANTITHEFT_INACTIVE!=aiviTheftParam[0])
               {
                  /* antitheft is active */
                  /* Do not overwrite DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION */
                  retCode = DIA_SUCCESS;
               }
               else
               {
                  /* antitheft is inactive, antitheft shall be overwritten */
                  retCode = setDefaultConfigItem(currProp, pConfigToDeliveryRep[i].mDefaultProp);
               }
            }
         }
      }

      if (retCode == DIA_FAILED)
      {
         DIA_TR_ERR( "dia_EcuResetConfigToDeliveryState::handleRequest: item %d (decimal) FAILED", i);
         break;
      }
   }

   // configuration has been changed, so calculate fingerprint again.
   dia_TestController* pTestCtrl = getInstanceOfTestController();
   if ( pTestCtrl )
   {
      (void) pTestCtrl->runTests(DIA_EN_TESTCONDITION_CODINGVALUE_CHANGE);
   }

   if (retCode != DIA_FAILED)
   {
      return DIA_RESET_FORCE_POS_RESPONSE;
   }
   else
   {
      return DIA_RESET_NEG_RESPONSE;
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_EcuResetConfigToDeliveryState::setDefaultConfigItem(tU32 currentItemID, tU32 defaultItemID) const
{
   std::vector<tU8> data(4096, 0);

   if (DIA_SUCCESS!=readConfigItem(data, defaultItemID))
   {
      DIA_TR_ERR("dia_EcuResetConfigToDeliveryState::setDefaultConfigItem: readConfigItem FAILED!!");
      return DIA_FAILED;
   }

   if (DIA_SUCCESS!=writeConfigItem(data, currentItemID))
   {
      DIA_TR_ERR("dia_EcuResetConfigToDeliveryState::setDefaultConfigItem: writeConfigItem FAILED!!");
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_EcuResetConfigToDeliveryState::readConfigItem(std::vector<tU8>& data, tU32 id) const
{
   tDiaResult retCode =  dia_getProperty(id, data);

   if(DIA_SUCCESS != retCode)
   {
      DIA_TR_ERR("dia_EcuResetConfigToDeliveryState::readConfigItem: item 0x%08X FAILED !!", id);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_EcuResetConfigToDeliveryState::writeConfigItem(const std::vector<tU8>& data, tU32 id) const
{
   dia_ConfigManager* pConfMgr = getInstanceOfConfigManager();

   if(0 == pConfMgr)
   {
      DIA_TR_ERR("dia_EcuResetConfigToDeliveryState::writeConfigItem pConfMgr NULL ptr");
      return DIA_FAILED;
   }

   if(DIA_SUCCESS != pConfMgr->setProperty(id, data))
   {
      DIA_TR_ERR("dia_EcuResetConfigToDeliveryState::writeConfigItem: item 0x%08X FAILED !!", id);
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}
