/*
 * dia_AntitheftMapSelectionWrite.h
 *
 *  Created on: 06.04.2016
 *      Author: kaa1hi
 *
 *  The service handler shall generate positive response in following cases of parameter writing:
 *  1/  current value of byte#0 parameter is 0 and new value is 1.
 *  2/  current value of byte#0 parameter is 1 and new value is 2.
 *  3/  current value of byte#0 parameter is 2 and new value is 1.
 *  4/  current value of byte#0 parameter is 0 and new value is 0.
 *  5/  current value of byte#0 parameter is 1 and new value is 1.
 *  6/  current value of byte#0 parameter is 2 and new value is 2.
 *  7/  current value of byte#0 parameter is 0 and new value is 2.
 *
 *  The service handler shall generate negative response (NRC=0x22) in following cases of parameter writing:
 *  1/  current value of byte#0 parameter is 1 and new value is 0.
 *  2/  current value of byte#0 parameter is 2 and new value is 0.
 *  3/  other cases
 *
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#include "dia_AntitheftMapSelectionWrite.h"

#define HEADER_DATA_LEN         4
#define DIA_U16_REPLY_LENGTH   ((tU16) (1 /* SID */ + 2 /* DID */))

//------------------------------------------------------------------------------

dia_AntitheftMapSelectionWrite::dia_AntitheftMapSelectionWrite ( void )
   : dia_ServiceHandlerUDS("dia_AntitheftMapSelectionWrite",DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_AIVI_ANTITHEF_MAP_SELECTION)
{
   dia_tclFnctTrace trc("dia_AntitheftMapSelectionWrite::dia_AntitheftMapSelectionWrite(tCString,tU8,tU16)");
}

//------------------------------------------------------------------------------

dia_AntitheftMapSelectionWrite::~dia_AntitheftMapSelectionWrite ( void )
{}

void
dia_AntitheftMapSelectionWrite::vProcessRequest ( const std::vector<void*>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_AntitheftMapSelectionWrite::vOnProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU16 dataLen = oDiagMsgBuffer().u16GetDataLength();

   if ((DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH + HEADER_DATA_LEN)!=dataLen)
   {
      DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: FAILED dataLen=%d.", dataLen);
      DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: FAILED size of input=%d.", (dataLen-HEADER_DATA_LEN));

      if (dataLen>0)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#0 0x%02X.", pU8[0]);
      if (dataLen>1)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#1 0x%02X.", pU8[1]);
      if (dataLen>2)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#2 0x%02X.", pU8[2]);
      if (dataLen>3)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#3 0x%02X.", pU8[3]);
      if (dataLen>4)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#4 0x%02X.", pU8[4]);
      if (dataLen>5)    DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: byte#5 0x%02X.", pU8[5]);

      vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE);
      return;
   }

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("dia_AntitheftMapSelectionWrite::writeConfigData: 0x%02X 0x%02X 0x%02X", pU8[0], pU8[1], pU8[2]);

   tU32 propSize = dia_getPropertySize(DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION);
   if (DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH==propSize)
   {
      tU8 aiviTheftParam[DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH] = { 0 };
      tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION, aiviTheftParam, DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH);
      if (getPropRes == DIA_SUCCESS)
      {
         tU8 currValAntitheft = aiviTheftParam[0];
         tU8 newValAntitheft = pU8[HEADER_DATA_LEN + 0];
         DIA_TR_INF("dia_AntitheftMapSelectionWrite::writeConfigData: currVal=0x%02X newVal=0x%02X", currValAntitheft, newValAntitheft);

         if (
            ((0==currValAntitheft) && (1==newValAntitheft)) ||    /* 1 */
            ((1==currValAntitheft) && (2==newValAntitheft)) ||    /* 2 */
            ((2==currValAntitheft) && (1==newValAntitheft)) ||    /* 3 */
            ((0==currValAntitheft) && (0==newValAntitheft)) ||    /* 4 */
            ((1==currValAntitheft) && (1==newValAntitheft)) ||    /* 5 */
            ((2==currValAntitheft) && (2==newValAntitheft)) ||    /* 6 */
            ((0==currValAntitheft) && (2==newValAntitheft))       /* 7 */
         )
         {
            for (tU32 i=0; i<DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH; i++)
            {
               aiviTheftParam[i] = pU8[HEADER_DATA_LEN + i];
               DIA_TR_INF("dia_AntitheftMapSelectionWrite::writeConfigData: aiviTheftParam[%d] set to 0x%02X", i, aiviTheftParam[i]);
            }

            retCode = dia_setProperty(DIA_PROP_AIVI_ANTITHEF_MAP_SELECTION, &aiviTheftParam[0], DIA_AIVI_ANTITHEFT_MAP_SELECTION_LENGTH);
            DIA_TR_INF("dia_AntitheftMapSelectionWrite::writeConfigData: write-one is inactive. retCode=0x%02X", retCode);
         }
         else
         {
            DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: write-one is active, send NRC=0x22.");
         }
      }
      else
      {
         DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: FAILED antitheft not available");
      }
   }
   else
   {
      DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: FAILED wrong prop size %d.", propSize);
   }

   if (DIA_FAILED==retCode)
   {
      DIA_TR_ERR("dia_AntitheftMapSelectionWrite::writeConfigData: FAILED send NRC=0x22");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DIA_U16_REPLY_LENGTH);
      vResReadyAndQuit();
   }
}
