/**
 * \file      dia_WifiPowerChange.h
 *
 * \brief     Utility class for manipulating the WiFi RF power
 *
 *
 *  Created on: Nov 28, 2016
 *      Author: jas1hi
 *
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status

 *--------------------------------------------------------------------------------------------------------------------
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_WIFIPOWERCHANGE_H_
#define DIA_WIFIPOWERCHANGE_H_

#ifndef __INCLUDED_DIA_INTERFACE_WIFIMOST_LISTENER__
#include "project/interfaces/dia_IWifiMostListener.h"
#endif


class dia_WifiPowerChange: public dia_IWifiMostListenerImpl
{
public:
	dia_WifiPowerChange();
	virtual ~dia_WifiPowerChange();

	tDiaResult changeWifiTransmitPower(tU8 wifiPowerAttenuation); // TX power attenuation value in dB
	virtual void vOnChangeWifiTransmitPower (tDiaResult eDiaResult);
	virtual void vOnChangeWifiTransmitPowerError (const tU8 errCode);
	tU8 getWifiPowerstatus();
	tU8 m_WifiPowerStatus;
private:
	dia_IWifiMost* m_pWifiMost;

};

#endif /* DIA_WIFIPOWERCHANGE_H_ */
