/*!
 * \file       dia_VersionInfo.h
 *
 * \author     jas1hi
 *
 * \created on Feb 28, 2017
 *
 * \brief      Utility class for getting version information of neighboring devices
 *
 * \details	   TCU SW- and HW-Version, USB-Hub, etc...
 *
 * \component  Diagnosis
 *
 * \ingroup    dia_VersionInfo
 *
 * \copyright  (c) 2011-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef DIA_VERSIONINFO_H_
#define DIA_VERSIONINFO_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TCU_LISTENER__
#include "project/interfaces/dia_ITCUListener.h"
#endif

typedef struct TCUVersionInfo_ {
	// SW-Version
	dia_TCUVersionInfo tcuSoftwareVersion;
	// HW-Version
	dia_TCUVersionInfo tcuHardwareVersion;

	TCUVersionInfo_()
	{
		tcuSoftwareVersion.m_Upper = 0x00;
		tcuSoftwareVersion.m_Mid   = 0x00;
		tcuSoftwareVersion.m_Lower = 0x00;

		tcuHardwareVersion.m_Upper = 0x00;
		tcuHardwareVersion.m_Mid   = 0x00;
		tcuHardwareVersion.m_Lower = 0x00;
	}

}TCUVersionInfo;

// Structure for holding USB information read from debugfs (/sys/kernel/debug/usb/devices)
// For more information refer to https://www.kernel.org/doc/Documentation/usb/proc_usb_info.txt
typedef struct USBVersionInfoElement_ {
	// Line T (T = Topology (etc.))
	std::string lineT;
	// Line D (D = Device descriptor info.)
	std::string lineD;
	// Line P (P = Product ID info. (from Device descriptor, but they won't fit together on one line))
	std::string lineP;
	// Type
	tBool isHostcontroller;
	USBVersionInfoElement_()
	{
		isHostcontroller = FALSE;
	}
}USBVersionInfoElement;

class dia_VersionInfo: public dia_TCUListenerImpl
{
public:
	dia_VersionInfo();
	virtual ~dia_VersionInfo();

	// TCU related version information
	virtual void vOnSoftwareVersion(const dia_TCUVersionInfo& tcuSwVersionInfo);
	virtual void vOnHardwareVersion(const dia_TCUVersionInfo& tcuHwVersionInfo);

	virtual tBool isTCUVersionInfoSubscriptionDone() {return mTCUVersionInfoSubscriptionDone;}
	virtual tBool isTCUVersionInfoAvailable() {return mTCUVersionInfoAvailable;}

	tDiaResult subscribeForTCUVersionInfo();
	TCUVersionInfo getTCUVersionInfo();

	// USB-Hub related version information
	virtual tBool isUSBHubInfoAvailable() {return mUSBHubInfoAvailable;}

	tDiaResult readUSBInfo();
	std::vector<USBVersionInfoElement> getUSBHubInfo();

private:
	tBool mTCUVersionInfoSubscriptionDone;
	tBool mTCUVersionInfoAvailable;
	TCUVersionInfo mTCUVersionInfo;

	tBool mUSBHubInfoAvailable;
	std::vector<USBVersionInfoElement> mUSBVersionInfoList;
};

#endif /* DIA_VERSIONINFO_H_ */
