/*
 * dia_VehicleSignalsInfo.cpp
 *
 *  Created on: Jan 6, 2016
 *      Author: jas1hi
 */

#include "dia_VehicleSignalsInfo.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define PARKING_BRAKE_STATUS_ON  		(tU8) 1
#define REVERSE_GEAR_STATUS_ON  		(tU8) 2

dia_VehicleSignalsInfo::dia_VehicleSignalsInfo()
	: m_ParkingBrakeSate(DIA_EN_PARKING_BRAKE_UNKNOWN),
	  m_ReverseGearState(DIA_EN_REVERSE_GEAR_UNKNOWN),
	  m_vehicleDataAvailable(FALSE),
	  m_vehicleDataSubscriptionDone(FALSE)
{
	 dia_tclFnctTrace trc("dia_VehicleSignalsInfo::dia_VehicleSignalsInfo()");
}

dia_VehicleSignalsInfo::~dia_VehicleSignalsInfo()
{
	_BP_TRY_BEGIN
	{
	  (tVoid) unsetSysAdapterListener<dia_IParkingBrakeListener>(this);
	  (tVoid) unsetSysAdapterListener<dia_IReverseGearListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_VehicleSignalsInfo::~dia_VehicleSignalsInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

tDiaResult dia_VehicleSignalsInfo::subscribeForVehicleData()
{
	if (m_vehicleDataSubscriptionDone == FALSE && m_vehicleDataAvailable == FALSE) {
		DIA_TR_INF("dia_VehicleSignalsInfo::subscribeForVehicleData()");

		dia_IParkingBrake* pPKB = 0;
		if (querySysAdapterInterface<dia_IParkingBrake>(&pPKB) == DIA_SUCCESS) {
		  if (pPKB) {
			 (tVoid) setSysAdapterListener<dia_IParkingBrakeListener>(this);
			 if (pPKB->getParkingBrakeStatus() == DIA_SUCCESS) { // One time request to get the actual value
			 } else {
				DIA_TR_ERR("dia_VehicleSignalsInfo::subscribeForVehicleData getParkingBrakeStatus with ERRORS!");
				(tVoid) unsetSysAdapterListener<dia_IParkingBrakeListener>(this);
				return DIA_FAILED;
			 }
		  }
		}

		dia_IReverseGear* pRVG = 0;
		if (querySysAdapterInterface<dia_IReverseGear>(&pRVG) == DIA_SUCCESS) {
		  if (pRVG) {
			 (tVoid) setSysAdapterListener<dia_IReverseGearListener>(this);
			 if (pRVG->getReverseGearStatus() == DIA_SUCCESS) {
			 } else {
				DIA_TR_ERR("dia_VehicleSignalsInfo::subscribeForVehicleData getReverseGearStatus with ERRORS!");
				(tVoid) unsetSysAdapterListener<dia_IReverseGearListener>(this);
				return DIA_FAILED;
			 }
		  }
		}

		m_vehicleDataSubscriptionDone = TRUE;
	}

	return DIA_SUCCESS;
}

void dia_VehicleSignalsInfo::vOnParkingBrakeStatus ( dia_eParkingBrakeState status ) // Data from vd_VehicleData
{
	dia_tclFnctTrace trc("dia_VehicleSignalsInfo::vOnParkingBrakeStatus");

	DIA_TR_INF("dia_VehicleSignalsInfo::vOnParkingBrakeStatus Parking Brake state 0x%02x", status);

	if(status != DIA_EN_PARKING_BRAKE_UNKNOWN && status < DIA_EN_PARKING_BRAKE_COUNT){
	  m_ParkingBrakeSate = status;
	  m_vehicleDataAvailable = TRUE;
	} else {
	  DIA_TR_ERR("dia_VehicleSignalsInfo::vOnParkingBrakeStatus Parking Brake state 0x%02x UNKNOWN or >COUNT !", status);
	}
}


void dia_VehicleSignalsInfo::vOnReverseGearStatus ( dia_eReverseGearStatus status )   // Data from vd_VehicleData
{
   dia_tclFnctTrace trc("dia_VehicleSignalsInfo::vOnReverseGearStatus");

   if(status != DIA_EN_REVERSE_GEAR_UNKNOWN && status < DIA_EN_REVERSE_GEAR_COUNT){
      m_ReverseGearState = status;
	  m_vehicleDataAvailable = TRUE;
   } else {
      DIA_TR_ERR("dia_VehicleSignalsInfo::vOnReverseGearStatus Reverse Gear state 0x%02x UNKNOWN or >COUNT !", status);
   }
}

tU8 dia_VehicleSignalsInfo::getVehicleData()
{
	tU8 vehicleDataStatusByte = 0x00;

	if (m_ParkingBrakeSate != DIA_EN_PARKING_BRAKE_UNKNOWN && m_ParkingBrakeSate < DIA_EN_PARKING_BRAKE_COUNT)
	{
		switch (m_ParkingBrakeSate)
		{
			case DIA_EN_PARKING_BRAKE_ON:
				vehicleDataStatusByte = vehicleDataStatusByte | PARKING_BRAKE_STATUS_ON;
				break;

			default: // DIA_EN_PARKING_BRAKE_OFF
				break;
		}
	}

	if(m_ReverseGearState != DIA_EN_REVERSE_GEAR_UNKNOWN && m_ReverseGearState < DIA_EN_REVERSE_GEAR_COUNT)
	{
		switch (m_ReverseGearState)
		{
			case DIA_EN_REVERSE_GEAR_ON:
				vehicleDataStatusByte = vehicleDataStatusByte | REVERSE_GEAR_STATUS_ON;
				break;

			default: // DIA_EN_REVERSE_GEAR_OFF
				break;
		}
	}

	return vehicleDataStatusByte;
}
