/*
 * dia_StartupStatusInfo.cpp
 *
 *  Created on: Jan 26, 2016
 *      Author: jas1hi
 */

#include "dia_StartupStatusInfo.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

//#include <algorithm>

#define WAKEUP_HISTORY_ELEMENT_SIZE 11 // [0:0] year, [2:0] month, [3:0] day, [4:0] hour, [5:0] minute, [6:0] second, [7:11] reset reason

dia_StartupStatusInfo::dia_StartupStatusInfo()
:	m_startupStatusAvailable(FALSE),
 	m_startupStatusSubscriptionDone(FALSE),
 	m_startupStatusUpdateFinished(FALSE),
 	m_wakeupStatusAvailable(FALSE),
 	m_wakeupStatusSubscriptionDone(FALSE)
{
	m_processList.push_back("rbcm-apphmi_homescreen.service");
	m_processList.push_back("rbcm-apphmi_master.service");
	m_processList.push_back("rbcm-apphmi_media.service");
	m_processList.push_back("rbcm-apphmi_navigation.service");
	m_processList.push_back("rbcm-apphmi_phone.service");
	m_processList.push_back("rbcm-apphmi_sds.service");
	m_processList.push_back("rbcm-apphmi_sxm.service");
	m_processList.push_back("rbcm-apphmi_system.service");
	m_processList.push_back("rbcm-apphmi_telematics.service");
	m_processList.push_back("rbcm-apphmi_testmode.service");

	m_processList.push_back("rbcm-apphmi_tuner.service");
	m_processList.push_back("rbcm-apphmi_vehicle.service");
	m_processList.push_back("rbcm-ccamediaplayer.service");
	m_processList.push_back("fcbluetooth.service");
	m_processList.push_back("messaging.service");
	m_processList.push_back("phone.service");
	m_processList.push_back("phonebook.service");
	m_processList.push_back("obigo-af.service");
	m_processList.push_back("rbcm-procmap.service");
	m_processList.push_back("rbcm-procnav.service");
	m_processList.push_back("rbcm-procdatacollector.service");

	m_processList.push_back("diaglog.service");
	m_processList.push_back("rbcm-procdiagnosis.service");
	m_processList.push_back("rbcm-procfc_aux.service");
	m_processList.push_back("rbcm-procfc_dtv.service");
	m_processList.push_back("rbcm-procfc_dumm.service");
	m_processList.push_back("rbcm-procfc_usb_tcu.service");
	m_processList.push_back("rbcm-gateway.service");
	m_processList.push_back("rbcm-procgenericgateway.service");
	m_processList.push_back("rbcm-prochc.service");
	m_processList.push_back("/opt/bosch/base/bin/procinput_out.out");
	m_processList.push_back("rbcm-procmeter.service");
	m_processList.push_back("rbcm-procparkas.service");
	m_processList.push_back("/opt/bosch/base/bin/procvds2.out");

	m_processList.push_back("rbcm-procspeaud.service");
	m_processList.push_back("rbcm-procswitchctrl.service");
	m_processList.push_back("rbcm-procsxm.service");
	m_processList.push_back("/opt/bosch/base/bin/proctcu_out.out");
	m_processList.push_back("rbcm-reception.service");
	m_processList.push_back("/opt/bosch/base/bin/procvdpv_out.out");
	m_processList.push_back("rbcm-procvd_clock.service");
	m_processList.push_back("rbcm-procveda.service");
	m_processList.push_back("rbcm-procvehfunc.service");
	m_processList.push_back("rbcm-procvoice.service");
	m_processList.push_back("rbcm-profile.service");
	m_processList.push_back("rbcm-sds-aivi.service");
	m_processList.push_back("rbcm-sdsts-aivi.service");

	m_processList.push_back("rbcm-sds_adapter.service");
	m_processList.push_back("spi.service");
	m_processList.push_back("swu.target");
	m_processList.push_back("rbcm-tcunode.service");
	m_processList.push_back("rbcm-mediamanager.service");
	m_processList.push_back("rbcm-devicemanager.service");
	m_processList.push_back("ipodauth.service");
	m_processList.push_back("rbcm-audiomanager.service");
}

dia_StartupStatusInfo::~dia_StartupStatusInfo()
{
	_BP_TRY_BEGIN
	{
		(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_StartupStatusInfo::~dia_StartupStatusInfo !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

tU8 dia_StartupStatusInfo::getProcessID(const std::string& processName)
{
	tU8 position = 0;
	m_processNameListIteratorType = std::find(m_processList.begin(), m_processList.end(), processName.c_str());
	if (m_processNameListIteratorType != m_processList.end()) {
		position = (tU8) std::distance(m_processList.begin(), m_processNameListIteratorType) + 1; // +1 is to differentiate between the known processes and unknown (=0)
	}
	else {
		DIA_TR_ERR("dia_StartupStatusInfo::getProcessID: process name: '%s' is not known!", processName.c_str());
	}

	DIA_TR_INF("dia_StartupStatusInfo::getProcessID (%d): for the process name: '%s'", position, processName.c_str());

	return position;
}

tDiaResult dia_StartupStatusInfo::subscribeToSPMForStartupStatus()
{
	DIA_TR_INF("dia_StartupStatusInfo::subscribeToSPMForStartupStatus()");

	dia_ISpm* pSpm = 0;
	if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
	  if (pSpm) {
		 (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
		 if (pSpm->getStartupStatus() == DIA_SUCCESS) { // One time request to get the actual value
			m_startupStatusSubscriptionDone = TRUE;
		 } else {
			DIA_TR_ERR("dia_StartupStatusInfo::subscribeToSPMForStartupStatus getStartupStatus with ERRORS!");
			(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
			return DIA_FAILED;
		}
	  }
	}

	return DIA_SUCCESS;
}

tDiaResult dia_StartupStatusInfo::subscribeToSPMForWakeupHistory()
{
	DIA_TR_INF("dia_StartupStatusInfo::subscribeToSPMForWakeupHistory()");

	dia_ISpm* pSpm = 0;
	if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
	  if (pSpm) {
		 (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
		 if (pSpm->getWakeUpHistory() == DIA_SUCCESS) { // One time request to get the actual value
			 m_wakeupStatusSubscriptionDone = TRUE;
		 } else {
			DIA_TR_ERR("dia_StartupStatusInfo::subscribeToSPMForWakeupHistory getWakeUpHistory with ERRORS!");
			(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
			return DIA_FAILED;
		}
	  }
	}

	return DIA_SUCCESS;
}

tVoid dia_StartupStatusInfo::vOnStartupStatus(const std::vector<dia_tSpmStartupStatus>* startupStatus)
{
	if (startupStatus->size() > 0) {

		mProcessElements.clear();
		mProcessElements.resize(m_processList.size());

		m_startupStatusUpdateFinished = TRUE;
		for (tU16 i = 0; i < startupStatus->size(); i++) {
			ProcessElement processElement;

			tU8 processID = getProcessID(startupStatus->at(i).mProcessName);
			if (processID == 0){ // processID=0 means that the provided process name is not known
				continue;
			}

			processElement.processID = processID-1;
			processElement.state = startupStatus->at(i).mProcessState;
			processElement.startTimeSinceStart = startupStatus->at(i).mStartTimeSinceStart;

			// Ignore time stamp
//			tS16 year = startupStatus->at(i).mSwitchOnDateYear;
//			tU8 month = startupStatus->at(i).mSwitchOnDateMonth;
//			tU8 day = startupStatus->at(i).mSwitchOnDateDay;
//			tU8 hour = startupStatus->at(i).mSwitchOnDateHour;
//			tU8 minute = startupStatus->at(i).mSwitchOnDateMinute;
//			tU8 second = startupStatus->at(i).mSwitchOnDateSecond;
//			snprintf(processElement.switchOnDateStr, MAX_DATE_STR_LENGTH, "%.4d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, day, hour, minute, second);


			mProcessElements.at(processElement.processID) = processElement;

			if (processElement.state == PROCESS_STATE_TOSTART){
				m_startupStatusUpdateFinished = FALSE;
			}

			DIA_TR_INF("dia_StartupStatusInfo::vOnStartupStatus: id: %d, state: %d startTime[ms]: %d", processElement.processID, processElement.state, processElement.startTimeSinceStart);
		}

		m_startupStatusAvailable = TRUE;
	}
	else {
		 DIA_TR_ERR("dia_StartupStatusInfo::vOnStartupStatus: startupStatus->size = 0");
	}

	// Check if some other part of code needs an update
	if (m_wakeupStatusAvailable && m_startupStatusAvailable) {
		(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
	}
}

tVoid dia_StartupStatusInfo::vOnGetWakeUpHistory(const std::vector<tU8>* wakeupElements)
{
	DIA_TR_INF("dia_StartupStatusInfo::vOnGetWakeUpHistory: Received wakeupElements.size = %d", wakeupElements->size());

	if (wakeupElements->size() > 0) {

		if (((wakeupElements->size()) % WAKEUP_HISTORY_ELEMENT_SIZE) == 0) {
			mWakeupHistoryElements.clear();

			tU16 numberOfReceivedWakeupHistoryElements = (tU16)((wakeupElements->size()) / WAKEUP_HISTORY_ELEMENT_SIZE);
			DIA_TR_INF("dia_StartupStatusInfo::vOnGetWakeUpHistory: numberOfReceivedWakeupHistoryElements = %d", numberOfReceivedWakeupHistoryElements);

			for (tU16 i = 0; i < numberOfReceivedWakeupHistoryElements; i++) {
				WakeupHistoryElement wakeupHistoryElement;

				tS16 year = (tS16)((wakeupElements->at(i*WAKEUP_HISTORY_ELEMENT_SIZE) << 8) | wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+1));
				tU8 month = wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+2);
				tU8 day = wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+3);
				tU8 hour = wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+4);
				tU8 minute = wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+5);
				tU8 second = wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+6);
				tU32 reason = (tU32) ((wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+7) << 24) | (wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+8) << 16) | (wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+9) << 8) | (wakeupElements->at((i*WAKEUP_HISTORY_ELEMENT_SIZE)+10)));

				snprintf(wakeupHistoryElement.dateStr, MAX_DATE_STR_LENGTH, "%.4d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, day, hour, minute, second);
				wakeupHistoryElement.reason = (tU8)reason;
				mWakeupHistoryElements.push_back(wakeupHistoryElement);

//				DIA_TR_INF("dia_StartupStatusInfo::vOnGetWakeUpHistory: y: %d m: %d d: %d H: %d M: %d S: %d R: %d", year, month, day, hour, minute, second, reason);
				DIA_TR_INF("dia_StartupStatusInfo::vOnGetWakeUpHistory: dateStr: %s, reason: %d", wakeupHistoryElement.dateStr, wakeupHistoryElement.reason);

				m_wakeupStatusAvailable = TRUE;
			}
		}
		else {
			 DIA_TR_ERR("dia_StartupStatusInfo::vOnGetWakeUpHistory: wakeupElements->size(%d) MOD WAKEUP_HISTORY_ELEMENT_SIZE(%d) != 0", wakeupElements->size(), WAKEUP_HISTORY_ELEMENT_SIZE);
		}

		// Check if some other part of code needs an update
		if (m_wakeupStatusAvailable && m_startupStatusAvailable) {
			(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
		}
	}
}

std::vector<ProcessElement> dia_StartupStatusInfo::getStartupStatus(tU16 numberOfRequestedElements)
{
	std::vector<ProcessElement> processElements;

	if (m_startupStatusUpdateFinished == FALSE) {
		dia_ISpm* pSpm = 0;
		if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
		  if (pSpm) {
			 if (pSpm->getStartupStatus() == DIA_SUCCESS) { // One time request to get the actual value
			 } else {
				DIA_TR_ERR("dia_StartupStatusInfo::getStartupStatus with ERRORS!");
			 }
		  }
		}
	}

	if (m_startupStatusAvailable) {
		if (numberOfRequestedElements <= mProcessElements.size()) {
			for (tU16 i=0; i<numberOfRequestedElements; i++) {
				processElements.push_back(mProcessElements.at(i));
			}
		}
		else {
			DIA_TR_ERR("dia_StartupStatusInfo::getStartupStatus numberOfRequestedElements: %d > mProcessElements.size: %d", numberOfRequestedElements, mProcessElements.size());
		}

		if (m_startupStatusUpdateFinished) { // Avoid to get the latest full state again and again
			m_startupStatusAvailable = FALSE;
		}
	}

	return processElements;
}

std::vector<WakeupHistoryElement> dia_StartupStatusInfo::getWakeupStatus(tU16 numberOfRequestedElements)
{
	std::vector<WakeupHistoryElement> wakeupHistoryElements;
	tU16 numberOfWakeupElemetsToDeliver = (tU16) mWakeupHistoryElements.size();

	if (numberOfRequestedElements <= mWakeupHistoryElements.size()) {
		numberOfWakeupElemetsToDeliver = numberOfRequestedElements;
	}

	for (tU16 i=0; i<numberOfWakeupElemetsToDeliver; i++) {
		wakeupHistoryElements.push_back(mWakeupHistoryElements.at(i));
	}

	DIA_TR_INF("dia_StartupStatusInfo::getWakeupStatus. Delivering size %d", wakeupHistoryElements.size());

	return wakeupHistoryElements;
}
