/**
 * \file      dia_SensorInfo.h
 *
 * \brief     Utility class for getting the 3D-Gyro and 3D-Acc data (adc-value of the gyro/acc coordinates + status for each value)
 *
 *
 *  Created on:  Mar 23, 2016
 *  Modified on: Aug 23, 2016 (Added ACC support)
 *
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_SENSORINFO_H_
#define DIA_SENSORINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include "common/interfaces/dia_ISensorListener.h"
#endif


typedef struct SensorInfoElement_ {
	tU32 rAxisVal; //adc-value of the gyro/acc r-coordinate
	tU32 sAxisVal; //adc-value of the gyro/acc s-coordinate
	tU32 tAxisVal; //adc-value of the gyro/acc t-coordinate

	tU8 rAxisStatus; //status codes associated with a gyro/acc r-coordinate
	tU8 sAxisStatus; //status codes associated with a gyro/acc s-coordinate
	tU8 tAxisStatus; //status codes associated with a gyro/acc t-coordinate

	SensorInfoElement_()
	{
		rAxisVal = 0;
		sAxisVal = 0;
		tAxisVal = 0;

		rAxisStatus = 0;
		sAxisStatus = 0;
		tAxisStatus = 0;
	}

} SensorInfoElement;


class dia_SensorInfo: public dia_ISensorListenerImpl
{
public:
	dia_SensorInfo();
	virtual ~dia_SensorInfo();

	/**
	 * \brief    	subscribe for Sensor Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the Gyro and ACC Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForSensorInfo();

	virtual tVoid vOnGyro3DStatus(dia_eGyroStatus rStatus, dia_eGyroStatus sStatus, dia_eGyroStatus tStatus);
	virtual tVoid vOnGyro3DGetResult(const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis);

	virtual tVoid vOnAccelerometer3DStatus (dia_eAccStatus rStatus, dia_eAccStatus sStatus, dia_eAccStatus tStatus);
    virtual tVoid vOnAccelerometer3DGetResult(const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis);

	virtual tBool isSensorInfoSubscriptionDone() {return m_sensorInfoSubscriptionDone;}
	virtual tBool isGyroInfoAvailable();
	virtual tBool isAccInfoAvailable();


	virtual SensorInfoElement getGyroInfoElement();
	virtual SensorInfoElement getAccInfoElement();

private:
    dia_ISensor* m_pSensor;

    tBool m_sensorInfoSubscriptionDone;

    tBool m_gyroStatusAvailable;
    tBool m_gyroValuesAvailable;

    tBool m_accStatusAvailable;
    tBool m_accValuesAvailable;

    SensorInfoElement m_gyroInfoElement;
    SensorInfoElement m_accInfoElement;
};

#endif /* DIA_SENSORINFO_H_ */
