/*
 * dia_SensorInfo.cpp
 *
 *  Created on: Mar 23, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SensorInfo.h"


dia_SensorInfo::dia_SensorInfo()
:	m_pSensor(OSAL_NULL),
 	m_sensorInfoSubscriptionDone(FALSE),
 	m_gyroStatusAvailable(FALSE),
 	m_gyroValuesAvailable(FALSE),
 	m_accStatusAvailable(FALSE),
 	m_accValuesAvailable(FALSE)
{
	 dia_tclFnctTrace trc("dia_SensorInfo::dia_SensorInfo()");
}

dia_SensorInfo::~dia_SensorInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_ISensorListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_SensorInfo::~dia_SensorInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pSensor)
		m_pSensor = OSAL_NULL;
}

tDiaResult dia_SensorInfo::subscribeForSensorInfo()
{
	dia_tclFnctTrace trc("dia_SensorInfo::subscribeForSensorInfo");

	if (m_sensorInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_SensorInfo::subscribeForSensorInfo()");

		if (querySysAdapterInterface<dia_ISensor>(&m_pSensor) == DIA_SUCCESS) {
			 if (m_pSensor) {
				 (tVoid) setSysAdapterListener<dia_ISensorListener>(this);
				 // GYRO
				 if (m_pSensor->bGetSensor3dGyroValue() == DIA_SUCCESS) { // One time request to get the actual value
					 m_sensorInfoSubscriptionDone = TRUE; //coverity fix:52771
					 DIA_TR_INF("dia_SensorInfo::subscribeForSensorInfo bGetSensor3dGyroValue OK!");

				 } else {
					DIA_TR_ERR("dia_SensorInfo::subscribeForSensorInfo bGetSensor3dGyroValue with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
					return DIA_FAILED;
				 }

				 // ACC
				 if (m_pSensor->bGetSensor3dAccValue() == DIA_SUCCESS) { // One time request to get the actual value
					 m_sensorInfoSubscriptionDone = TRUE;
					 DIA_TR_INF("dia_SensorInfo::subscribeForSensorInfo bGetSensor3dAccValue OK!");
				 } else {
					DIA_TR_ERR("dia_SensorInfo::subscribeForSensorInfo bGetSensor3dAccValue with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
					return DIA_FAILED;
				 }
			}
		}
		else {
			DIA_TR_ERR("dia_SensorInfo::subscribeForSensorInfo querySysAdapterInterface<dia_ISensorListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_SensorInfo::vOnGyro3DStatus(dia_eGyroStatus rStatus, dia_eGyroStatus sStatus, dia_eGyroStatus tStatus)
{
	m_gyroInfoElement.rAxisStatus = rStatus - 1; // Enum status starts from 1
	m_gyroInfoElement.sAxisStatus = sStatus - 1; // Enum status starts from 1
	m_gyroInfoElement.tAxisStatus = tStatus - 1; // Enum status starts from 1

//	DIA_TR_CUS("dia_SensorInfo::vOnGyro3DStatus. rAxisStatus: %d, sAxisStatus: %d, tAxisStatus: %d", m_gyroInfoElement.rAxisStatus, m_gyroInfoElement.sAxisStatus, m_gyroInfoElement.tAxisStatus);

	m_gyroStatusAvailable = TRUE;
}

tVoid dia_SensorInfo::vOnGyro3DGetResult(const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis)
{
	m_gyroInfoElement.rAxisVal = u32rAxis;
	m_gyroInfoElement.sAxisVal = u32sAxis;
	m_gyroInfoElement.tAxisVal = u32tAxis;

//	DIA_TR_CUS("dia_SensorInfo::vOnGyro3DGetResult. rAxisVal: %d, sAxisVal: %d, tAxisVal: %d", u32rAxis, u32sAxis, u32tAxis);

	m_gyroValuesAvailable = TRUE;
}

tBool dia_SensorInfo::isGyroInfoAvailable()
{
	tBool gyroInfoAvailable = FALSE;

	if (m_gyroValuesAvailable && m_gyroStatusAvailable) {
		gyroInfoAvailable = TRUE;
	}

	return gyroInfoAvailable;
}

SensorInfoElement dia_SensorInfo::getGyroInfoElement()
{
	if (m_pSensor) {
		if (m_pSensor->bGetSensor3dGyroValue() == DIA_SUCCESS) { // This will deliver the status for the next query
			m_gyroValuesAvailable = FALSE;
			m_gyroStatusAvailable = FALSE;
		}
	}

	return m_gyroInfoElement;
}

tVoid dia_SensorInfo::vOnAccelerometer3DStatus (dia_eAccStatus rStatus, dia_eAccStatus sStatus, dia_eAccStatus tStatus)
{
	m_accInfoElement.rAxisStatus = rStatus - 1; // Enum status starts from 1
	m_accInfoElement.sAxisStatus = sStatus - 1; // Enum status starts from 1
	m_accInfoElement.tAxisStatus = tStatus - 1; // Enum status starts from 1

//	DIA_TR_CUS("dia_SensorInfo::vOnAccelerometer3DStatus. rAxisStatus: %d, sAxisStatus: %d, tAxisStatus: %d", m_accInfoElement.rAxisStatus, m_accInfoElement.sAxisStatus, m_accInfoElement.tAxisStatus);

	m_accStatusAvailable = TRUE;
}

tVoid dia_SensorInfo::vOnAccelerometer3DGetResult(const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis)
{
	m_accInfoElement.rAxisVal = u32rAxis;
	m_accInfoElement.sAxisVal = u32sAxis;
	m_accInfoElement.tAxisVal = u32tAxis;

//	DIA_TR_CUS("dia_SensorInfo::vOnAccelerometer3DGetResult. rAxisVal: %d, sAxisVal: %d, tAxisVal: %d", u32rAxis, u32sAxis, u32tAxis);

	m_accValuesAvailable = TRUE;
}

tBool dia_SensorInfo::isAccInfoAvailable()
{
	tBool accInfoAvailable = FALSE;

	if (m_accValuesAvailable && m_accStatusAvailable) {
		accInfoAvailable = TRUE;
	}

	return accInfoAvailable;
}

SensorInfoElement dia_SensorInfo::getAccInfoElement()
{
	if (m_pSensor) {
		if (m_pSensor->bGetSensor3dAccValue() == DIA_SUCCESS) { // This will deliver the status for the next query
			m_accValuesAvailable = FALSE;
			m_accStatusAvailable = FALSE;
		}
	}

	return m_accInfoElement;
}
