/**
 * \file      dia_SdsGuiPopupInfo.h
 *
 * \brief     Utility class for getting the sds gui popup contents (e.g. actual screenID, speech input status, etc..)
 *
 *
 *  Created on: Apr 19, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_SDSGUIPOPUPINFO_H_
#define DIA_SDSGUIPOPUPINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP_LISTENER__
#include "project/interfaces/dia_ISdsGuiPopupListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE_LISTENER__
#include "project/interfaces/dia_ISdsDiagnosisServiceListener.h"
#endif
#define MAX_SCREEN_ID_STR_LENGTH (tU16) 15

typedef struct SdsGuiPopupInfoElement_ {
	tChar screenID[MAX_SCREEN_ID_STR_LENGTH]; // e.g. SR_INF_MAIN, SR_GLO_Main
//#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	tU8 sdsSpeechInputStatus;
//#endif

	SdsGuiPopupInfoElement_()
	{
		memset(screenID, '\0', sizeof(tChar)*MAX_SCREEN_ID_STR_LENGTH);
//#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
		sdsSpeechInputStatus = 0;
//#endif
	}

} SdsGuiPopupInfoElement;


typedef struct SdsDiagServiceInfoElement_ {
	
	tU8 sdsEventStatus;
	tU16 sdsEventTimeStamp;

	SdsDiagServiceInfoElement_()
	{
		sdsEventStatus = 0;
		sdsEventTimeStamp = 0;
	}

}SdsDiagServiceInfoElement;


class dia_SdsGuiPopupInfo: public dia_ISdsGuiPopupListener,public dia_ISdsDiagnosisServiceListener
{
public:
	dia_SdsGuiPopupInfo();
	virtual ~dia_SdsGuiPopupInfo();

	/**
	 * \brief    	subscribe for Sds Gui Popup Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the Sds Gui Popup info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForSdsGuiPopupInfo();
	tDiaResult subscribeForSdsDiagnosisServiceInfo();

	virtual tVoid vOnSdsSpeechStatus ( dia_eSpeechInputStatus sdsSpeechInputStatus );
	virtual tVoid vOnSdsScreenIDStatus ( std::string sdsScreenID );
	virtual tVoid vOnSdsDiagnosisServiceUpdate(dia_eExtendedSDSLoggingData /*extendedSDSLoggingData*/, tU16 /*sdsTimestamp*/);

	virtual tBool isSdsGuiPopupInfoAvailable();

	virtual tBool isSdsGuiPopupInfoSubscriptionDone() {return m_sdsGuiPopupInfoSubscriptionDone;}

	virtual SdsGuiPopupInfoElement getSdsGuiPopupInfoElement();
	
	virtual tBool isSdsDiagnosisServiceInfoAvailable() {return m_sdsDiagnosisServiceInfoAvailable;}

	virtual tBool isDiagnosisServiceInfoSubscriptionDone() {return m_sdsDiagnosisServiceInfoSubscriptionDone;}


	virtual SdsDiagServiceInfoElement getSdsDiagServiceInfoElement();



private:
	 dia_ISdsGuiPopup* m_pSdsGuiPopup;
	 dia_ISdsDiagnosisService* m_pSdsDiagnosisService;

	 tBool m_sdsGuiPopupInfoSubscriptionDone;

	 tBool m_sdsSpeechStatusAvailable;
	 tBool m_sdsScreenIDStatusAvailable;

	 SdsGuiPopupInfoElement m_sdsGuiPopupInfoElement;

	 SdsDiagServiceInfoElement m_sdsDiagServiceInfoElement;
	 
	 tBool m_sdsDiagnosisServiceInfoSubscriptionDone;

	 tBool m_sdsDiagnosisServiceInfoAvailable;
};

#endif /* DIA_SDSGUIPOPUPINFO_H_ */
