/**
 * \file      dia_ResetHistoryInfo.h
 *
 * \brief     Utility class for getting reset information (Reset History, Reset Counters, etc...) from LCM
 *
 *
 *  Created on: Dec 17, 2015
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */


#ifndef DIA_RESETHISTORYINFO_H_
#define DIA_RESETHISTORYINFO_H_


#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif


#define MAX_DATE_STR_LENGTH (tU16) 20

typedef struct ResetHistoryElement_ {
	 // Reason
	 tU8 reason;

	 //	 2015-12-31 00:00:01
	 tChar dateStr[MAX_DATE_STR_LENGTH];

	ResetHistoryElement_()
	{
		reason = 0;
		memset(dateStr, '\0', sizeof(tChar)*MAX_DATE_STR_LENGTH);
	}

} ResetHistoryElement;

typedef struct ResetCounterElement_ {
	 // Reset counters
	 tU16 ApApplicationError;
	 tU16 ApECUReset;
	 tU16 ApUser;
	 tU16 ApDownload;
	 tU16 ApDownloadError;
	 tU16 ApSoftware;
	 tU16 ApUnknown;
	 tU16 ApOverTemperature;
	 tU16 ApLCMIntern;
	 tU16 ApPowerOnReset;
	 tU16 ApPowerLoss;
	 tU16 ApPowerOff;
	 tU16 ApScc;
	 tU16 ApWarmStart;
	 tU16 SccHWWdt;
	 tU16 SccPowerOn;
	 tU16 SccColdStart;
	 tU16 SccAppModeChange;
	 tU16 SccDuringLpw;
	 tU16 SccDuringPllOsz;
	 tU16 SccDuringSW;
	 tU16 SccWarmStart;


	 ResetCounterElement_()
	{
		ApApplicationError = 0;
		ApECUReset = 0;
		ApUser = 0;
		ApDownload = 0;
		ApDownloadError = 0;
		ApSoftware = 0;
		ApUnknown = 0;
		ApOverTemperature = 0;
		ApLCMIntern = 0;
		ApPowerOnReset = 0;
		ApPowerLoss = 0;
		ApPowerOff = 0;
		ApScc = 0;
		ApWarmStart = 0;
		SccHWWdt = 0;
		SccPowerOn = 0;
		SccColdStart = 0;
		SccAppModeChange = 0;
		SccDuringLpw = 0;
		SccDuringPllOsz = 0;
		SccDuringSW = 0;
		SccWarmStart = 0;
	}

} ResetCounterElement;

class dia_ResetHistoryInfo: public dia_ISpmListenerImpl
{
public:
	dia_ResetHistoryInfo();
	virtual ~dia_ResetHistoryInfo();


   /**
	 * \brief    	subscribe to LCM_ResetHistory
	 *
	 *				Function subscribes to the SystemAdapter of LCM.
	 *				The SystemAdapter returns the reset history
	 */
   virtual tDiaResult subscribeToLCMForResetInfo();

   /**
	 * \brief    	status for the requested reset history
	 *
	 *				Function receives the message via its parameter
	 *				It verifies the SA answer and sets the flag that indicates the readiness of result
	 *
	 * \param[in]	const std::vector<tU8>* resetElements
	 */

   virtual tBool isResetInfoSubscriptionDone() {return (mResetHistorySubscriptionDone & mResetCounterSubscriptionDone);}

   virtual tVoid vOnGetResetHistory (const std::vector<tU8>* resetElements);
   virtual tVoid vOnSystemResetInformation (const dia_tSpmResetDate* date, const dia_tSpmResetCounterStatus* status);

   virtual tBool isResetHistoryAvailable();
   virtual tBool isResetCounterAvailable();

   virtual std::vector<ResetHistoryElement> getResetHistory(tU16 maxNumberOfRequestedResetHistoryElements);
   virtual ResetCounterElement getResetCounter();

private:
   std::vector<ResetHistoryElement> mResetHistoryElements;
   tBool mResetHistoryAvailable;
   tBool mResetHistorySubscriptionDone;

   ResetCounterElement mResetCounterElement;
   tBool mResetCounterAvailable;
   tBool mResetCounterSubscriptionDone;
};

#endif /* DIA_RESETHISTORYINFO_H_ */
