/*
 * dia_ResetHistoryInfo.cpp
 *
 *  Created on: Dec 17, 2015
 *      Author: jas1hi
 */

#include "dia_ResetHistoryInfo.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define RESET_HISTORY_ELEMENT_SIZE 8 // [0:0] year, [2:0] month, [3:0] day, [4:0] hour, [5:0] minute, [6:0] second, [7:0] reset reason
//#define RESET_HISTORY_ELEMENTS_LENGTH 3 //20
//#define RESET_HISTORY_ELEMENTS_LIMIT ((RESET_HISTORY_ELEMENT_SIZE)*(RESET_HISTORY_ELEMENTS_LENGTH))


dia_ResetHistoryInfo::dia_ResetHistoryInfo()
	:	mResetHistoryAvailable(FALSE),
	 	mResetHistorySubscriptionDone(FALSE),
	 	mResetCounterAvailable(FALSE),
	 	mResetCounterSubscriptionDone(FALSE)
{

}

dia_ResetHistoryInfo::~dia_ResetHistoryInfo()
{
	_BP_TRY_BEGIN
	{
	  (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_ResetHistoryInfo::~dia_ResetHistoryInfo !!!");
	  NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

tDiaResult dia_ResetHistoryInfo::subscribeToLCMForResetInfo()
{
	if (mResetHistorySubscriptionDone == FALSE || mResetCounterSubscriptionDone == FALSE)
	{
		dia_ISpm* pSpm = 0;
		if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
			if (pSpm) {
				 (tVoid) setSysAdapterListener<dia_ISpmListener>(this);

				 if (mResetHistorySubscriptionDone == FALSE) {
					 DIA_TR_INF("dia_ResetHistoryInfo::subscribeToLCMForResetHistory. ...");

					 if (pSpm->getResetHistory() != DIA_SUCCESS) {
						  (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
						  DIA_TR_ERR("dia_ResetHistoryInfo::subscribeToLCMForResetHistory() ---  SEND TO SPM SA FEATURE FAILED!!!!");
						  return DIA_FAILED;
					 }

					 DIA_TR_INF("dia_ResetHistoryInfo::subscribeToLCMForResetHistory() --- OK");
					 mResetHistorySubscriptionDone = TRUE;
				 }

				 if (mResetCounterSubscriptionDone == FALSE) {
					 DIA_TR_INF("dia_ResetHistoryInfo::subscribeToLCMForResetCounter. ...");

					 if (pSpm->getSystemResetInformation() != DIA_SUCCESS) {
						  (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
						  DIA_TR_ERR("dia_ResetHistoryInfo::subscribeToLCMForResetCounter() ---  SEND TO SPM SA FEATURE FAILED!!!!");
						  return DIA_FAILED;
					 }

					 DIA_TR_INF("dia_ResetHistoryInfo::subscribeToLCMForResetCounter() --- OK");
					 mResetCounterSubscriptionDone = TRUE;
				 }
			}
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_ResetHistoryInfo::vOnGetResetHistory(const std::vector<tU8>* resetElements)
{
	DIA_TR_INF("dia_ResetHistoryInfo::vOnGetResetHistory: Received resetElements.size = %d", resetElements->size());

	if (resetElements->size() > 0) {

		if (((resetElements->size() - 1) % RESET_HISTORY_ELEMENT_SIZE) == 0) { // -1: very first entry is the size of history elements
			mResetHistoryElements.clear();

			tU16 numberOfReceivedResetHistoryElements = (tU16)((resetElements->size() - 1) / RESET_HISTORY_ELEMENT_SIZE);
			DIA_TR_INF("dia_ResetHistoryInfo::vOnGetResetHistory: numberOfReceivedResetHistoryElements = %d", numberOfReceivedResetHistoryElements);

			if (resetElements->at(0) != (tU8)numberOfReceivedResetHistoryElements) {
				 DIA_TR_ERR("dia_ResetHistoryInfo::vOnGetResetHistory: resetElements.size %d != numberOfReceivedResetHistoryElements: %d", resetElements->at(0), numberOfReceivedResetHistoryElements);
				 return;
			}

			for (tU16 i = 0; i < numberOfReceivedResetHistoryElements; i++) {
				ResetHistoryElement resetHistoryElement;

				tS16 year = (tS16)((resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)) << 8) | resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+1));
				tU8 month = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+2);
				tU8 day = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+3);
				tU8 hour = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+4);
				tU8 minute = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+5);
				tU8 second = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+6);
				tU8 reason = resetElements->at(1+(i*RESET_HISTORY_ELEMENT_SIZE)+7);

				snprintf(resetHistoryElement.dateStr, MAX_DATE_STR_LENGTH, "%.4d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, day, hour, minute, second);
				resetHistoryElement.reason = reason + 1; // Increment the reset reason by one step to be able to use the reason=0 for the special case "No Reset"
				mResetHistoryElements.push_back(resetHistoryElement);

//				DIA_TR_INF("dia_ResetHistoryInfo::vOnGetResetHistory: y: %d m: %d d: %d H: %d M: %d S: %d R: %d", year, month, day, hour, minute, second, reason);
//				DIA_TR_INF("dia_ResetHistoryInfo::vOnGetResetHistory: dateStr: %s, reason: %d", resetHistoryElement.dateStr, resetHistoryElement.reason);

				mResetHistoryAvailable = TRUE;
			}
		}
		else {
			 DIA_TR_ERR("dia_ResetHistoryInfo::vOnGetResetHistory: resetElements->size MOD RESET_HISTORY_ELEMENT_SIZE != 0");
		}

		// Check if some other part of code (e.g. ResetCounter) needs an update
		if (mResetCounterAvailable) {
			(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
		}
	}
}

tBool dia_ResetHistoryInfo::isResetHistoryAvailable()
{
	DIA_TR_INF("dia_ResetHistoryInfo::isResetHistoryAvailable.  %s", (TRUE==mResetHistoryAvailable? "YES": "NO"));

	return mResetHistoryAvailable;
}

std::vector<ResetHistoryElement> dia_ResetHistoryInfo::getResetHistory(tU16 maxNumberOfRequestedResetHistoryElements)
{
	std::vector<ResetHistoryElement> resetHistoryElements;
	tU16 numberOfResetElemetsToDeliver = (tU16) mResetHistoryElements.size();

	if (maxNumberOfRequestedResetHistoryElements <= mResetHistoryElements.size()) {
		numberOfResetElemetsToDeliver = maxNumberOfRequestedResetHistoryElements;
	}

	for (tU16 i=0; i<numberOfResetElemetsToDeliver; i++) {
		resetHistoryElements.push_back(mResetHistoryElements.at(i));
	}

	DIA_TR_INF("dia_ResetHistoryInfo::getResetHistory. Delivering size %d", resetHistoryElements.size());

	return resetHistoryElements;
}

tVoid dia_ResetHistoryInfo::vOnSystemResetInformation(const dia_tSpmResetDate* date, const dia_tSpmResetCounterStatus* status)
{
	DIA_TR_INF("dia_ResetHistoryInfo::vOnSystemResetInformation");

	if (date == NULL) {
		DIA_TR_ERR("dia_ResetHistoryInfo::vOnSystemResetInformation: Delivered last reset date = NULL!!!");
		return;
	}

	if (status == NULL) {
		DIA_TR_ERR("dia_ResetHistoryInfo::vOnSystemResetInformation: Delivered reset status = NULL!!!");
		return;
	}

	mResetCounterElement.ApApplicationError =  (tU16)status->mApApplicationError;
	mResetCounterElement.ApECUReset = 		   (tU16)status->mApEcuReset;
	mResetCounterElement.ApUser = 			   (tU16)status->mApUser;
	mResetCounterElement.ApDownload =          (tU16)status->mApDownload;
	mResetCounterElement.ApDownloadError =     (tU16)status->mApDownloadError;
	mResetCounterElement.ApSoftware =          (tU16)status->mApSoftware;
	mResetCounterElement.ApUnknown =           (tU16)status->mApUnknownCount;
	mResetCounterElement.ApOverTemperature =   (tU16)status->mApOvertemperature;
	mResetCounterElement.ApLCMIntern =         (tU16)status->mApLcmIntern;
	mResetCounterElement.ApPowerOnReset =      (tU16)status->mApPowerOnCount;
	mResetCounterElement.ApPowerLoss =         (tU16)status->mApPowerLossCount;
	mResetCounterElement.ApPowerOff =          (tU16)status->mApPowerOffCount;
	mResetCounterElement.ApScc =               (tU16)status->mApSccCount;
	mResetCounterElement.ApWarmStart =         (tU16)status->mApWarmstartCount;
	mResetCounterElement.SccHWWdt =            (tU16)status->mSccHwWdtCount;
	mResetCounterElement.SccPowerOn =          (tU16)status->mSccPowerOnCount;
	mResetCounterElement.SccColdStart =        (tU16)status->mSccColdstartCount;
	mResetCounterElement.SccAppModeChange =    (tU16)status->mSccAppmodeChangeCount;
	mResetCounterElement.SccDuringLpw =        (tU16)status->mSccDuringLpwCount;
	mResetCounterElement.SccDuringPllOsz =     (tU16)status->mSccDuringPllOszCount;
	mResetCounterElement.SccDuringSW =         (tU16)status->mSccDuringSWCount;
	mResetCounterElement.SccWarmStart =        (tU16)status->mSccWarmstartCount;

	mResetCounterAvailable = TRUE;

	// Check if some other part of code (e.g. ResetHistory) needs an update
	if (mResetHistoryAvailable) {
		(tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
	}
}

tBool dia_ResetHistoryInfo::isResetCounterAvailable()
{
	DIA_TR_INF("dia_ResetHistoryInfo::isResetCounterAvailable.  %s", (TRUE==mResetCounterAvailable? "YES": "NO"));

	return mResetCounterAvailable;
}

ResetCounterElement dia_ResetHistoryInfo::getResetCounter()
{
	DIA_TR_INF("dia_ResetHistoryInfo::getResetCounter...");

	return mResetCounterElement;
}
