/*
 * dia_PowerStatusInfo.cpp
 *
 *  Created on: Dec 21, 2015
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 24.02.2017		| 1.6	| NLK1KOR (RBEI  )	| implemented feature AIVI-28127 XCP_Provider : P-IVI: Worker class for the power status
 *--------------------------------------------------------------------------------------------------------------------
 * NCG3D-44304      | 1.7	| NLK1KOR (RBEI  )	|  Fix for A2L Parameter value of Power status is always 0
 *--------------------------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------											
 * 26.06.2017       | 1.8	| NLK1KOR (RBEI  )	| Implemented Encoder Push key simulation.

 *--------------------------------------------------------------------------------------------------------------------
 */

#include "dia_PowerStatusInfo.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define POWER_STATUS_IGN_ON  		(tU8) 1
#define POWER_STATUS_ACC_ON  		(tU8) 2
//#define POWER_STATUS_AUTOACC_ON  	(tU8) 4



dia_PowerStatusInfo::dia_PowerStatusInfo()
	:	m_PowerState(DIA_EN_SYS_PWR_STATE_UNKNOWN),
	 	m_PowerStateAvailable(FALSE),
	 	m_LCMSubscriptionDone(FALSE),
	    m_SystemStateSubscriptionDone(FALSE),
	    m_SystemStateAvailable(FALSE),
	    m_SystemState(DIA_EN_SPM_SYSTEM_STATE_UNKNOWN)//coverity fix:87125:Non-static class member m_SystemState is initialized in constructor.
{
	 dia_tclFnctTrace trc("dia_PowerStatusInfo::dia_PowerStatusInfo()");
}

dia_PowerStatusInfo::~dia_PowerStatusInfo()
{
   _BP_TRY_BEGIN
   {
	  (void) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_PowerStatusInfo::~dia_PowerStatusInfo !!!");
	  DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

tDiaResult dia_PowerStatusInfo::subscribeToLCMForPowerState()
{
	if (m_LCMSubscriptionDone == FALSE && m_PowerStateAvailable == FALSE) {
		DIA_TR_INF("dia_PowerStatusInfo::subscribeToLCMForPowerState()");

		tBool errorDetected = TRUE;

		dia_ISpm* pSpm = 0;
		if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
		  if (pSpm) {
			 (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
			 if (pSpm->getSystemPowerMode() == DIA_SUCCESS) { // One time request to get the actual value
				errorDetected = FALSE;
			 }
		  }
		}

		if (errorDetected) {
		  (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
		  DIA_TR_ERR("dia_PowerStatusInfo::subscribeToLCMForPowerState() ---  SEND TO SPM SA FEATURE FAILED!!!!");
		  return DIA_FAILED;
		}

		m_LCMSubscriptionDone = TRUE;
	}

	return DIA_SUCCESS;
}

tVoid dia_PowerStatusInfo::vOnPowerState ( dia_eSpmSystemPowerState pwrState )
{
   dia_tclFnctTrace trc("dia_PowerStatusInfo::vOnPowerState");

   DIA_TR_INF("dia_PowerStatusInfo::vOnPowerState Power state 0x%02x", pwrState);

   if(pwrState != DIA_EN_SYS_PWR_STATE_UNKNOWN && pwrState < DIA_EN_SYS_PWR_STATE_COUNT){
       m_PowerState = pwrState;
       m_PowerStateAvailable = TRUE;
   } else {
       DIA_TR_ERR("dia_PowerStatusInfo::vOnPowerState Power state 0x%02x UNKNOWN or >COUNT !", pwrState);
   }

//   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}

tU8 dia_PowerStatusInfo::getPowerState()
{
	tU8 powerStatusByte = 0x00;

	if (m_PowerState != DIA_EN_SYS_PWR_STATE_UNKNOWN  &&  m_PowerState < DIA_EN_SYS_PWR_STATE_COUNT)
	{
//		m_PowerStateAvailable = FALSE;

		switch (m_PowerState)
		{
			case DIA_EN_SYS_PWR_STATE_RUN: // RUN == Ignition + ACC_ON
				powerStatusByte = powerStatusByte | POWER_STATUS_IGN_ON | POWER_STATUS_ACC_ON;
				break;

			case DIA_EN_SYS_PWR_STATE_ACCESSORY: // ACC = ACC_ON
				powerStatusByte = powerStatusByte | POWER_STATUS_ACC_ON;
				break;

			default: // DIA_EN_SYS_PWR_STATE_OFF
				break;
		}
	}

	return powerStatusByte;
}
tDiaResult dia_PowerStatusInfo::subscribeToLCMForSystemState()
{
	if (m_SystemStateSubscriptionDone == FALSE && m_SystemStateAvailable == FALSE) {
		DIA_TR_INF("dia_PowerStatusInfo::subscribeToLCMForSystemState()");

		tBool errorDetected = TRUE;

		dia_ISpm* pSpm = 0;
		if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
			if (pSpm) {
				(tVoid)setSysAdapterListener<dia_ISpmListener>(this);
				dia_eSpmSystemState state;
				if (pSpm->getRadioState() == DIA_SUCCESS)
				{
					DIA_TR_INF("dia_PowerStatusInfo::subscribeToLCMForSystemState() SUCCESS!!!");

					errorDetected = FALSE;
				}
			}
		}

		if (errorDetected) {
			(tVoid)unsetSysAdapterListener<dia_ISpmListener>(this);
			DIA_TR_ERR("dia_PowerStatusInfo::subscribeToLCMForSystemState() ---  SEND TO SPM SA FEATURE FAILED!!!!");
			return DIA_FAILED;
		}

		m_SystemStateSubscriptionDone = TRUE;
	}

	return DIA_SUCCESS;
}

tVoid dia_PowerStatusInfo::vOnSystemState(dia_eSpmSystemState state, dia_eSpmSystemState prevState)
{
	dia_tclFnctTrace trc("dia_PowerStatusInfo::vOnSystemState");
	DIA_TR_INF("dia_PowerStatusInfo::vOnSystemState system state %d", state);
	if (state != DIA_EN_SPM_SYSTEM_STATE_UNKNOWN && state < DIA_EN_SPM_SYSTEM_STATE_COUNT) {
		m_SystemState = state;
		m_SystemStateAvailable = TRUE;
	}
	else {
		DIA_TR_ERR("dia_PowerStatusInfo::vOnSystemState system state 0x%02x UNKNOWN or >COUNT !", state);
	}

}

tU8 dia_PowerStatusInfo::getSystemState()
{
	tU8 systemStatusByte = 0x00;
	DIA_TR_INF("dia_PowerStatusInfo::getSystemState");
	if (m_SystemState != DIA_EN_SPM_SYSTEM_STATE_UNKNOWN  &&  m_SystemState < DIA_EN_SPM_SYSTEM_STATE_COUNT)
	{
		DIA_TR_INF("dia_PowerStatusInfo::inside SWITCH!!!");
		switch (m_SystemState)
		{
		case DIA_EN_SPM_SYSTEM_STATE_ON: 
			DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_ON");
			systemStatusByte = m_SystemState;
			break;

		case DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN: 
			DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN");
			systemStatusByte = m_SystemState;
			break;
		case DIA_EN_SPM_SYSTEM_STATE_BACKGROUND: 
			DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_BACKGROUND");
			systemStatusByte = m_SystemState;
			break;
		case DIA_EN_SPM_SYSTEM_STATE_STANDBY: 
			DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_STANDBY");
			systemStatusByte = m_SystemState;
			break;
		case DIA_EN_SPM_SYSTEM_STATE_SUSPEND: 
			DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_SUSPEND");
			systemStatusByte = m_SystemState;
			break;
		default: DIA_TR_INF("dia_PowerStatusInfo::DIA_EN_SPM_SYSTEM_STATE_UNKNOWN");
			break;
		}
	}

	return systemStatusByte;
}


tDiaResult dia_PowerStatusInfo::simulateOnOffTrigger(tBool mode)
{
	dia_eSpmSubState substate = DIA_EN_SPM_SUBSTATE_ON_TIPPER;
	dia_ISpm* pSpm = 0;
	tBool errorDetected = TRUE;
		if (querySysAdapterInterface<dia_ISpm>(&pSpm) == DIA_SUCCESS) {
			if (pSpm) {
				(tVoid)setSysAdapterListener<dia_ISpmListener>(this);
				
				if (pSpm->sendOnOffTrigger(substate,mode) == DIA_SUCCESS)
				{
					DIA_TR_INF("dia_PowerStatusInfo::sendOnOffTrigger() SUCCESS!!!");

				errorDetected = FALSE;
			}
		}
	}
	if (errorDetected) {
		(tVoid)unsetSysAdapterListener<dia_ISpmListener>(this);
		DIA_TR_ERR("dia_PowerStatusInfo::simulateOnOffTrigger() FEATURE FAILED!!!!");
		return DIA_FAILED;
	}
    return DIA_SUCCESS;
}
