/**
 * \file      dia_PhoneConnectionInfo.h
 *
 * \brief     Utility class for getting the Phone connection info (e.g. last connection establishment duration to Bluetooth HFP)
 *
 *
 *  Created on: Jun 2, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_PHONECONNECTIONINFO_H_
#define DIA_PHONECONNECTIONINFO_H_


#ifndef __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING_LISTENER__
#include "project/interfaces/dia_IPhoneConnectionSettingListener.h"
#endif

class dia_PhoneConnectionInfo : public dia_IPhoneConnectionSettingListener
{
public:
	dia_PhoneConnectionInfo();
	virtual ~dia_PhoneConnectionInfo();

	/**
	 * \brief    	subscribe for Phone connection info
	 *
	 *				Function subscribes to the SystemAdapter for getting the phone connection Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForPhoneConnectionInfo();

	virtual tVoid vOnPhoneConnectionEstablishmentDurationStatus(tU32 duration);

	virtual tBool isPhoneConnectionInfoAvailable() {return m_phoneConnectionInfoAvailable;}
	virtual tBool isPhoneConnectionInfoSubscriptionDone() {return m_phoneConnectionInfoSubscriptionDone;}

	virtual tU32 getPhoneConnectionEstablishmentDuration();

private:
	dia_IPhoneConnectionSetting* m_pPhoneConnectionSetting;

	tBool m_phoneConnectionInfoSubscriptionDone;
	tBool m_phoneConnectionInfoAvailable;

	tU32 m_connectionEstablishmentDuration;
};

#endif /* DIA_PHONECONNECTIONINFO_H_ */
