/*
 * dia_LightingDimming.cpp
 *
 *  Created on: January 17, 2017
 *      Author: nlk1kor
 */
 /******************************************************************************************************************************************************/

#include "dia_LightingDimming.h"
//#define TO_HEX(i) (i <= 9 ? '0' + i : 'A' - 10 + i)
#define DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE 149
#define DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE 150

dia_LightingDimming::dia_LightingDimming()

{
	 dia_tclFnctTrace trc("dia_LightingDimming::dia_LightingDimming()");

}

dia_LightingDimming::~dia_LightingDimming()
{
	 _BP_TRY_BEGIN
	{

	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_InputSimulation::~dia_InputSimulation !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

}


/******************************************************************************************************************************************************/

tDiaResult dia_LightingDimming::setLightingDimmingParameter(tU16 propvalue)
{
	
	tU8 propvaluefirstbyte = propvalue & 0xFF;
	tU8 xhigh = (propvalue >> 8);
	tU8 propvaluesecondbyte = xhigh & 0xFF;

	DIA_TR_INF("dia_LightingDimming::dia_setProperty propvaluefirstbyte  = %x", propvaluefirstbyte);
	DIA_TR_INF("dia_LightingDimming::dia_setProperty propvaluesecondbyte  = %x", propvaluesecondbyte);
	DIA_TR_INF("dia_LightingDimming::dia_setProperty propvalue  = %x", propvalue);
	DIA_TR_INF("dia_LightingDimming::dia_setProperty propvalue  = %ld", propvalue);


	if (DIA_SUCCESS == dia_getProperty(DIA_PROP_CM_DIMMING_PARAMETER_SET, mGetpropvalue))
	{

		DIA_TR_INF("dia_LightingDimming::dia_setProperty SUCCESS mGetpropvalue.at(149) = %x", mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE));
		DIA_TR_INF("dia_LightingDimming::dia_setProperty SUCCESS mGetpropvalue.at(150) = %x", mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE));
		mSetpropvalue = mGetpropvalue;
		mSetpropvalue[DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE] = propvaluesecondbyte;
		mSetpropvalue[DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE] = propvaluefirstbyte;

	}

	// write System Amp On Output , size
	if (DIA_SUCCESS != dia_setProperty(DIA_PROP_CM_DIMMING_PARAMETER_SET, mSetpropvalue))
	{

		DIA_TR_INF("dia_LightingDimming::dia_setProperty FAILED");
		return DIA_FAILED;
	}
	else
	{
		DIA_TR_INF("dia_LightingDimming::dia_setProperty SUCCESS");

	}

	if (getLightingDimmingParameter() == DIA_SUCCESS)
	{

		if (checkLightingDimmingParameterCorrect() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_LightingDimming::checkLightingDimmingParameterCorrect FAILED");

			return DIA_FAILED;
		}

	}
	else
	{
		DIA_TR_INF("dia_LightingDimming::getLightingDimmingParameter FAILED");
	}


	return DIA_SUCCESS;
}
/******************************************************************************************************************************************************/
tDiaResult dia_LightingDimming::getLightingDimmingParameter()
{
	dia_tclFnctTrace trc("dia_LightingDimming::getLightingDimmingParameter()");

	if (dia_getProperty(DIA_PROP_CM_DIMMING_PARAMETER_SET,mGetpropvalue) == DIA_SUCCESS)
	{
		DIA_TR_INF("dia_LightingDimming::getLightingDimmingParameter mGetpropvalue.at(149) = %x", mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE));
		DIA_TR_INF("dia_LightingDimming::getLightingDimmingParameter mGetpropvalue.at(150) = %x", mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE));
		return DIA_SUCCESS;
	}
	else
	{
		DIA_TR_ERR("dia_LightingDimming::getLightingDimmingParameter  NOK !");
		return DIA_FAILED;
	}
	
	
}
/******************************************************************************************************************************************************/
tDiaResult dia_LightingDimming::checkLightingDimmingParameterCorrect()
{
	dia_tclFnctTrace trc("dia_LightingDimming::setLightingDimmingParameter()");
	if ((mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE) == mSetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_FIRST_BYTE)) && (mGetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE) == mSetpropvalue.at(DIA_PROP_CM_DIMMING_PARAMETER_SEC_BYTE)))
	{	
			DIA_TR_INF("dia_LightingDimming::checkLightingDimmingParameterCorrect - propvalue set  SUCCESSFUL");
			return DIA_SUCCESS;
	}
	else
	{
		DIA_TR_ERR("dia_LightingDimming::checkLightingDimmingParameterCorrect - propvalue set  FAILED!");
		return DIA_FAILED;
	}
	

}


