/*
 * dia_InputSimulation.cpp
 *
 *  Created on: Feb 16, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.02.2017		| 1.1	| NLK1KOR (RBEI)	| fixed NCG3D-36761
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status
*--------------------------------------------------------------------------------------------------------------------
* 06.06.2017       | 2.1	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
													PIVI-4235 Operation history of touch panel (secondary display)
* 13.06.2017       |2.2    | NLK1KOR  (RBEI)    |   Fix for NCG3D-53539 
                                                    [MC][Nissan 2.0] HK Long Press is not happening via Calibration parameter
													 even when release time value is > 3000ms
*--------------------------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------
 *-------------------------------------------------------------------------------------------------------------------
 */

#include "dia_InputSimulation.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#include "project/services/customer/MonitoringCalibration/config/dia_defsDebugTraceConfig.h"
#endif

const tU16  INPUT_HK_PHONE 			= 768;
const tU16  INPUT_HK_CD 			= 769;
const tU16  INPUT_HK_CAMERA 		= 770;
const tU16  INPUT_HK_AUX 			= 771;
const tU16  INPUT_HK_PREV 			= 772;
const tU16  INPUT_HK_NEXT 			= 773;
const tU16  INPUT_HK_RADIO 			= 774;
const tU16  INPUT_HK_INFO 			= 775;
const tU16  INPUT_HK_SETUP 			= 776;
const tU16  INPUT_HK_MAP 			= 777;
const tU16  INPUT_HK_BACK 			= 778;
const tU16  INPUT_HK_DAY_NIGHT 		= 779;
const tU16  INPUT_HK_NAV 			= 780;
const tU16  INPUT_HK_ENTER 			= 781;
const tU16  INPUT_HK_XM 			= 782;
const tU16  INPUT_SYS_KEY_POWER 	= 783; // Not possible to simulate
const tU16  INPUT_SYS_KEY_EJECT 	= 784; // Not possible to simulate
const tU16  INPUT_HK_FM_AM 			= 785;
const tU16  INPUT_HK_MENU 			= 786;
const tU16  INPUT_HK_APP 			= 787;
const tU16  INPUT_HK_AUDIO 			= 788;
const tU16  INPUT_HK_DISP 			= 789;
const tU16  INPUT_HK_FOLDER_NEXT 	= 796;
const tU16  INPUT_HK_FOLDER_PREV 	= 797;
const tU16  INPUT_HK_PIVI_CLIMATE 	= 799;
const tU16  INPUT_HK_VIRT_SRV_TEST  = 928;

const tU16  INPUT_JOYSTICK_UP		   = 960;
const tU16  INPUT_JOYSTICK_DOWN		   = 961;
const tU16  INPUT_JOYSTICK_LEFT		   = 962;
const tU16  INPUT_JOYSTICK_RIGHT	   = 963;
const tU16  INPUT_JOYSTICK_UPPER_LEFT  = 964;
const tU16  INPUT_JOYSTICK_UPPER_RIGHT = 965;
const tU16  INPUT_JOYSTICK_LOWER_LEFT  = 966;
const tU16  INPUT_JOYSTICK_LOWER_RIGHT = 967;
const tU16  INPUT_JOYSTICK_ENTER	   = 968;
const tU16  INPUT_JOYSTICK_MAP		   = 969;
//const tU16  INPUT_JOYSTICK_OPTION    = 970; // Renault specific
const tU16  INPUT_JOYSTICK_HOME        = 971;
const tU16  INPUT_JOYSTICK_BACK        = 972;
const tU16  INPUT_JOYSTICK_DAY_NIGHT   = 973;
const tU16  INPUT_JOYSTICK_DISP        = 974;
const tU16  INPUT_JOYSTICK_OPTION_LONGPRESS = 944;
const tU16  INPUT_JOYSTICK_HOME_LONGPRESS   = 945;
const tU16  INPUT_JOYSTICK_BACK_LONGPRESS   = 946;
const tU16  INPUT_JOYSTICK_ENTER_LONGPRESS  = 947; 

const tU16  INPUT_SWC_MODE 			= 100;
const tU16  INPUT_SWC_OK 			= 101;
const tU16  INPUT_SWC_SEEK_UP 		= 102;
const tU16  INPUT_SWC_SEEK_DOWN 	= 103;
const tU16  INPUT_SWC_TEL_VR 		= 104;
const tU16  INPUT_SWC_VOL_DOWN 		= 106;
const tU16  INPUT_SWC_VOL_UP 		= 107;
const tU16  INPUT_SWC_TEL_HANG_UP 	= 108;
const tU16  INPUT_SWC_BACK 			= 109;
const tU16  INPUT_SWC_UP 			= 111;
const tU16  INPUT_SWC_DOWN 			= 112;
//const tU16  INPUT_SWC_MUTE 		   = 113; // Renault specific
//const tU16  INPUT_SWC_AUDIO_SRC_UP   = 114; // Renault specific
//const tU16  INPUT_SWC_AUDIO_SRC_DOWN = 115; // Renault specific
const tU16  INPUT_SWC_ENTER 		= 117; 

const tU8  INPUT_ENC_JOYSTICK 		= 3;
const tU8  INPUT_ENC_LEFT 			= 6;
const tU8  INPUT_ENC_MSMENCODER     = 7;
const tU8  INPUT_ENC_RIGHT 			= 8;
const tU8  INPUT_ENC_SWRC 			= 9;

const tU32 INVALID_TIMER_ID			= 0xFFFFFFFF;


dia_InputSimulation::dia_InputSimulation()
: m_inputEventsEnabled(FALSE),
  m_keyPressed(FALSE),
  m_encoderRotated(FALSE),
  m_touchPressed(FALSE),
  m_touchSlideDone(FALSE),
  m_gestureRecordingRunning(FALSE),
  m_gestureRecordStartRequested(FALSE),
  m_gestureReplayingRunning(FALSE),
  m_gestureReplayStartRequested(FALSE),
  mTimerIDTouch(INVALID_TIMER_ID),
  mTimerIDKeyPress(INVALID_TIMER_ID),
  m_keyInjectionStatus(0),
  m_EncRotationStatus(0),
  m_TouchSimulationStatus(0),
  m_GestureRecordStatus(0),
  m_GestureReplayStatus(0),
  m_TouchPIVISimulationStatus(0),
  m_touchPIVIPressed(FALSE)//coverity fix:97125:Non-static class member m_touchPIVIPressed is initialized in constructor.
{
	 dia_tclFnctTrace trc("dia_InputSimulation::dia_InputSimulation()");

	mReleaseTimerTouch.s32Create();
	mTimerIDTouch = mReleaseTimerTouch.getID();
	mReleaseTimerTouch.addTimerListener(this);

	mReleaseTimerKeyPress.s32Create();
	mTimerIDKeyPress = mReleaseTimerKeyPress.getID();
	mReleaseTimerKeyPress.addTimerListener(this);
}

dia_InputSimulation::~dia_InputSimulation()
{
	 _BP_TRY_BEGIN
	{
	   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
       (void) unsetSysAdapterListener<dia_IPIVIInputHandlingListener>(this);
		mReleaseTimerTouch.removeTimerListener(this);
		mReleaseTimerTouch.s32Delete();

		mReleaseTimerKeyPress.removeTimerListener(this);
		mReleaseTimerKeyPress.s32Delete();
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_InputSimulation::~dia_InputSimulation !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

//	if (m_pInputHandling) {
//		m_pInputHandling = OSAL_NULL;
//	}
}



tVoid dia_InputSimulation::vOnTimerElapsed (dia_TimerID id)
{
	DIA_TR_INF("dia_InputSimulation::vOnTimerElapsed. timerID: %d", id);

	dia_IInputHandlingPrj* pInterface = 0;
    dia_IPIVIInputHandling* pvInterface = 0;
	if (((querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface)) == DIA_SUCCESS) && pInterface)
	{
		if (id == mTimerIDTouch) {
		    if (m_touchPressed)
			{
				if (DIA_SUCCESS == (pInterface->setTouchIntern (m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord, DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED)))
				{
					DIA_TR_INF("dia_InputSimulation::vOnTimerElapsed - X:Y(%d:%d) RELEASED", m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord);
                    m_touchPressed = FALSE;
					(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
				}
				else
				{
					DIA_TR_ERR("dia_InputSimulation::vOnTimerElapsed - RELEASE FAILED for X:Y (%d:%d)", m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord);
				}
			}
            if (m_touchPIVIPressed)
			{
			    if (((querySysAdapterInterface<dia_IPIVIInputHandling>(&pvInterface)) == DIA_SUCCESS) && pvInterface )
				{
				   if(DIA_SUCCESS == (pvInterface->setPIVITouchIntern(m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord,2, DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED )))
				   {
				       
					   
					   DIA_TR_INF("dia_InputSimulation::vOnTimerElapsed - X:Y(%d:%d) RELEASED", m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord);
						m_touchPIVIPressed = FALSE;
						(void) unsetSysAdapterListener<dia_IPIVIInputHandlingListener>(this); // No need for an update after successful execution
					}
					else
					{
						 DIA_TR_ERR("dia_InputSimulation::vOnTimerElapsed - RELEASE FAILED for X:Y (%d:%d)", m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord);
					}
				}
			}
		}
		else if (id == mTimerIDKeyPress) {
			if (DIA_SUCCESS == pInterface->setKeyInternalCode(m_lastPressedKey.internalKeyID, DIA_EN_PRJ_KEY_INFO_RELEASED))
			{
			  DIA_TR_INF("dia_InputSimulation::vOnTimerElapsed - '%s' with internalKeyID (%d) RELEASED", m_lastPressedKey.keyName.c_str(), m_lastPressedKey.internalKeyID);
			  (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
			}
			else
			{
			  DIA_TR_ERR("dia_InputSimulation::vOnTimerElapsed - RELEASE FAILED for m_internalKeyID (%d)", m_lastPressedKey.internalKeyID);
			}
		}
		else {
			 DIA_TR_ERR("dia_InputSimulation::vOnTimerElapsed - Wrong timer id: %d", id);
		}
	}
}

tDiaResult dia_InputSimulation::simulateKeyInjection(tU16 keyCode, tU16 releaseTime)
{
	m_keyPressed = FALSE;
    m_keyInjectionStatus = 0;
	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		m_lastPressedKey.internalKeyID = getInternalKeyID(keyCode);
	   if ( m_lastPressedKey.internalKeyID != DIA_PRJ_KEY_CODE_UNKNOWN )
	   {
		   (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
			if (DIA_SUCCESS != (pInterface->setKeyInternalCode(m_lastPressedKey.internalKeyID, DIA_EN_PRJ_KEY_INFO_PRESSED)))
			{
				DIA_TR_ERR("dia_InputSimulation::simulateKeyInjection - SEND TO IPSIM FAILED!!!!");
				m_keyInjectionStatus = DIA_ERR_REQUEST_SEND;
				return DIA_FAILED;
			}
			else
			{
				DIA_TR_INF("dia_InputSimulation::simulateKeyInjection - '%s' with internalKeyID (%d) PRESSED", m_lastPressedKey.keyName.c_str(), m_lastPressedKey.internalKeyID);
				m_lastPressedKey.releaseTime = releaseTime;
				m_keyPressed = TRUE;
			}
			
			if(!m_lastPressedKey.releaseTime)
			{
				OSAL_s32ThreadWait(100);

				if (DIA_SUCCESS == pInterface->setKeyInternalCode(m_lastPressedKey.internalKeyID, DIA_EN_PRJ_KEY_INFO_RELEASED))
				{
					DIA_TR_INF("dia_InputSimulation::vOnSetKey - '%s' with internalKeyID (%d) RELEASED", m_lastPressedKey.keyName.c_str(), m_lastPressedKey.internalKeyID);
					(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
				}
				else
				{
					DIA_TR_ERR("dia_InputSimulation::vOnSetKey - RELEASE FAILED for m_internalKeyID (%d)", m_lastPressedKey.internalKeyID);
				}
			}
	   }
	}

	return DIA_SUCCESS;
}

tVoid dia_InputSimulation::vOnSetKey(const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnSetKey. eDiaResult: %d", eDiaResult);
	if (eDiaResult == DIA_SUCCESS)
	{
		if (m_keyPressed && (m_lastPressedKey.internalKeyID != DIA_PRJ_KEY_CODE_UNKNOWN ))
		{
		  if (m_lastPressedKey.releaseTime > 0) {  // Long key press operation
			  mReleaseTimerKeyPress.s32SetTime(m_lastPressedKey.releaseTime, 0);
			  DIA_TR_INF("dia_InputSimulation::vOnSetKey. Starting LONG PRESS TIMER (%d ms) for '%s'", m_lastPressedKey.releaseTime, m_lastPressedKey.keyName.c_str());
		  }
		  else { // Normal key press operation
			/*dia_IInputHandlingPrj* pInterface = 0;
			if ((eDiaResult == DIA_SUCCESS) && ((querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface)) == DIA_SUCCESS) && pInterface)
			{
				OSAL_s32ThreadWait(50);

				if (DIA_SUCCESS == pInterface->setKeyInternalCode(m_lastPressedKey.internalKeyID, DIA_EN_PRJ_KEY_INFO_RELEASED))
				{
				 DIA_TR_INF("dia_InputSimulation::vOnSetKey - '%s' with internalKeyID (%d) RELEASED", m_lastPressedKey.keyName.c_str(), m_lastPressedKey.internalKeyID);
				 (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
				}
				else
				{
				 DIA_TR_ERR("dia_InputSimulation::vOnSetKey - RELEASE FAILED for m_internalKeyID (%d)", m_lastPressedKey.internalKeyID);
				}
			}*/
		  }
		}
	}
	else
	{
		m_keyInjectionStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}

dia_eVdInuptHandlingKeyCodePrj dia_InputSimulation::getInternalKeyID(tU16 keyCode)
{
	dia_eVdInuptHandlingKeyCodePrj keyID = DIA_PRJ_KEY_CODE_UNKNOWN;
	m_lastPressedKey.keyName.clear();
	switch(keyCode)
	{
		case INPUT_HK_PHONE:
			 keyID = DIA_PRJ_KEY_CODE_PHONE;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_PHONE");
			 break;
		case INPUT_HK_CD:
			 keyID = DIA_PRJ_KEY_CODE_CD;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_CD");
			 break;
		case INPUT_HK_CAMERA:
			 keyID = DIA_PRJ_KEY_CODE_CAMERA;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_CAMERA");
			 break;
		case INPUT_HK_AUX:
			 keyID = DIA_PRJ_KEY_CODE_AUX;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_AUX");
			 break;
		case INPUT_HK_PREV:
			 keyID = DIA_PRJ_KEY_CODE_PREV;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_PREV");
			 break;
		case INPUT_HK_NEXT:
			 keyID = DIA_PRJ_KEY_CODE_NEXT;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_NEXT");
			 break;
		case INPUT_HK_RADIO:
			 keyID = DIA_PRJ_KEY_CODE_RADIO;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_RADIO");
			 break;
		case INPUT_HK_INFO:
			 keyID = DIA_PRJ_KEY_CODE_INFO;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_INFO");
			 break;
		case INPUT_HK_SETUP:
			 keyID = DIA_PRJ_KEY_CODE_SETUP;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_SETUP");
			 break;
		case INPUT_HK_MAP:
			 keyID = DIA_PRJ_KEY_CODE_MAP;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_MAP");
			 break;
		case INPUT_HK_BACK:
			 keyID = DIA_PRJ_KEY_CODE_BACK;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_BACK");
			 break;
		case INPUT_HK_DAY_NIGHT:
			 keyID = DIA_PRJ_KEY_CODE_DAY_NIGHT;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_DAY_NIGHT");
			 break;
		case INPUT_HK_NAV:
			 keyID = DIA_PRJ_KEY_CODE_NAV;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_NAV");
			 break;
		case INPUT_HK_ENTER:
			 keyID = DIA_PRJ_KEY_CODE_ENTER;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_ENTER");
			 break;
		case INPUT_HK_XM:
			 keyID = DIA_PRJ_KEY_CODE_XM;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_XM");
			 break;
		case INPUT_HK_FM_AM:
			 keyID = DIA_PRJ_KEY_CODE_AM_FM;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_FM_AM");
			 break;
		case INPUT_HK_MENU:
			 keyID = DIA_PRJ_KEY_CODE_MENU;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_MENU");
			 break;
		case INPUT_HK_APP:
			 keyID = DIA_PRJ_KEY_CODE_APP;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_APP");
			 break;
		case INPUT_HK_AUDIO:
			 keyID = DIA_PRJ_KEY_CODE_AUDIO;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_AUDIO");
			 break;
		case INPUT_HK_DISP:
			 keyID = DIA_PRJ_KEY_CODE_DISP;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_DISP");
			 break;
		case INPUT_HK_VIRT_SRV_TEST:
			 keyID = DIA_PRJ_KEY_VIRTUAL_STM;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_VIRT_SRV_TEST");
			 break;
		case INPUT_SYS_KEY_POWER:
			 keyID=DIA_PRJ_KEY_CODE_POWER;
			 m_lastPressedKey.keyName = std::string("INPUT_SYS_KEY_POWER");
			 break;
		case INPUT_SYS_KEY_EJECT:
			 keyID = DIA_PRJ_KEY_CODE_EJECT;
			 m_lastPressedKey.keyName = std::string("INPUT_SYS_KEY_EJECT");
			 break;
		case INPUT_HK_FOLDER_NEXT:
			 keyID = DIA_PRJ_KEY_CODE_FOLDER_NEXT;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_FOLDER_NEXT");
			 break;
		case INPUT_HK_FOLDER_PREV:
			 keyID = DIA_PRJ_KEY_CODE_FOLDER_PREV;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_FOLDER_PREV");
			 break;
		case INPUT_HK_PIVI_CLIMATE:
			 keyID = DIA_PRJ_KEY_CODE_PIVI_CLIMATE;
			 m_lastPressedKey.keyName = std::string("INPUT_HK_PIVI_CLIMATE");
			 break;
		case INPUT_SWC_OK:
			 keyID = DIA_PRJ_SWC_KEY_CODE_OK;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_OK");
			 break;
		case INPUT_SWC_SEEK_UP:
			 keyID = DIA_PRJ_SWC_KEY_CODE_SEEK_UP;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_SEEK_UP");
			 break;
		case INPUT_SWC_SEEK_DOWN:
			 keyID = DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_SEEK_DOWN");
			 break;
		case INPUT_SWC_TEL_VR:
			 keyID = DIA_PRJ_SWC_KEY_CODE_TEL_VR;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_TEL_VR");
			 break;
		case INPUT_SWC_VOL_DOWN:
			 keyID = DIA_PRJ_SWC_KEY_CODE_VOL_DOWN;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_VOL_DOWN");
			 break;
		case INPUT_SWC_VOL_UP:
			 keyID = DIA_PRJ_SWC_KEY_CODE_VOL_UP;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_VOL_UP");
			 break;
		case INPUT_SWC_TEL_HANG_UP:
			 keyID = DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP;
			 m_lastPressedKey.keyName = std::string("INPUT_SWC_TEL_HANG_UP");
			 break;
		case INPUT_SWC_BACK:
			keyID = DIA_PRJ_SWC_KEY_CODE_BACK;
			m_lastPressedKey.keyName = std::string("INPUT_SWC_BACK");
			break;
		case INPUT_SWC_UP:
			keyID = DIA_PRJ_SWC_KEY_CODE_UP;
			m_lastPressedKey.keyName = std::string("INPUT_SWC_UP");
			break;
		case INPUT_SWC_DOWN:
			keyID = DIA_PRJ_SWC_KEY_CODE_DOWN;
			m_lastPressedKey.keyName = std::string("INPUT_SWC_DOWN");
			break;
		case INPUT_SWC_ENTER:
			keyID = DIA_PRJ_SWC_KEY_CODE_ENTER;
			m_lastPressedKey.keyName = std::string("INPUT_SWC_ENTER");
			break;

		case INPUT_JOYSTICK_UP:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_UP;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_UP");
			break;

		case INPUT_JOYSTICK_DOWN:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_DOWN;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_DOWN");
			break;

		case INPUT_JOYSTICK_LEFT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_LEFT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_LEFT");
			break;

		case INPUT_JOYSTICK_RIGHT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_RIGHT");
			break;

		case INPUT_JOYSTICK_UPPER_LEFT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_UPPER_LEFT");
			break;

		case INPUT_JOYSTICK_UPPER_RIGHT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_UPPER_RIGHT");
			break;

		case INPUT_JOYSTICK_LOWER_LEFT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_LOWER_LEFT");
			break;

		case INPUT_JOYSTICK_LOWER_RIGHT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_LOWER_RIGHT");
			break;

		case INPUT_JOYSTICK_ENTER:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_ENTER;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_ENTER");
			break;

		case INPUT_JOYSTICK_MAP:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_MAP;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_MAP");
			break;

		case INPUT_JOYSTICK_HOME:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_HOME;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_HOME");
			break;

		case INPUT_JOYSTICK_BACK:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_BACK;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_BACK");
			break;
		case INPUT_JOYSTICK_DAY_NIGHT:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_DAY_NIGHT");
			break;
		case INPUT_JOYSTICK_DISP:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_DISP;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_DISP");
			break;
		case  INPUT_JOYSTICK_OPTION_LONGPRESS:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_OPTION_LONGPRESS");
			break;
		case  INPUT_JOYSTICK_HOME_LONGPRESS:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_HOME_LONGPRESS");
			break;
		case  INPUT_JOYSTICK_BACK_LONGPRESS:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_BACK_LONGPRESS");
			break;
		case  INPUT_JOYSTICK_ENTER_LONGPRESS:
			keyID = DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS;
			m_lastPressedKey.keyName = std::string("INPUT_JOYSTICK_ENTER_LONGPRESS");
			break;

		default:
			DIA_TR_ERR("dia_InputSimulation::getInternalKeyID. No valid keyID for keyCode: %d", keyCode);
			m_keyInjectionStatus = DIA_ERR_INVALID_REQUEST;
			break;
	}

	DIA_TR_INF("dia_InputSimulation::getInternalKeyID - keyCode=%d, keyID=%d keyName: %s", keyCode, keyID, m_lastPressedKey.keyName.c_str());

	return keyID;
 }

tDiaResult dia_InputSimulation::simulateEncRotation(tU8 encType, tS8 steps)
{
	m_encoderRotated = FALSE;
    m_EncRotationStatus = 0;
	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		dia_eInputHandlingEncoderPrj internalEncoderType = getInternalEncoderType(encType);
		if ( internalEncoderType != DIA_EN_PRJ_ENCODER_UNKNOWN )
		{
		   (void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
			if (DIA_SUCCESS != (pInterface->setEncoder(internalEncoderType, steps)))
			{
				DIA_TR_ERR("dia_InputSimulation::simulateEncRotation - SEND TO IPSIM FAILED!!!!");
				m_EncRotationStatus =DIA_ERR_REQUEST_SEND;
				return DIA_FAILED;
			}
			else
			{
				DIA_TR_INF("dia_InputSimulation::simulateEncRotation - '%s' with steps (%d) ROTATED", m_lastProcessedEncoder.c_str(), steps);
				m_encoderRotated = TRUE;
			}
		}
	}

	return DIA_SUCCESS;
}

dia_eInputHandlingEncoderPrj dia_InputSimulation::getInternalEncoderType(tU8 encType)
{
	dia_eInputHandlingEncoderPrj encoderType = DIA_EN_PRJ_ENCODER_UNKNOWN;
	m_lastProcessedEncoder.clear();

	switch(encType)
	{
		case INPUT_ENC_LEFT:
			 encoderType = DIA_EN_PRJ_ENCODER_1;
			 m_lastProcessedEncoder = std::string("INPUT_ENC_LEFT");
			 break;
		case INPUT_ENC_RIGHT:
			 encoderType = DIA_EN_PRJ_ENCODER_2;
			 m_lastProcessedEncoder = std::string("INPUT_ENC_RIGHT");
			 break;
        case INPUT_ENC_JOYSTICK:
			 encoderType = DIA_EN_PRJ_ENCODER_3;
			 m_lastProcessedEncoder = std::string("INPUT_ENC_JOYSTICK");
			 break;
		case INPUT_ENC_MSMENCODER:
			 encoderType = DIA_EN_PRJ_ENCODER_4;
			 m_lastProcessedEncoder = std::string("INPUT_ENC_MSMENCODER");
			 break;
		case INPUT_ENC_SWRC:
			 encoderType = DIA_EN_PRJ_ENCODER_5;
			 m_lastProcessedEncoder = std::string("INPUT_ENC_SWRC");
			 break;
		default:
			DIA_TR_ERR("dia_InputSimulation::getInternalEncoderType. No valid encoder type for: %d", encType);
			m_EncRotationStatus =DIA_ERR_INVALID_REQUEST;
			break;
	}

	DIA_TR_INF("dia_InputSimulation::getInternalEncoderType - '%s'", m_lastProcessedEncoder.c_str());

	return encoderType;
 }

tDiaResult dia_InputSimulation::simulateSingleTouch(tU16 xCoord, tU16 yCoord, tU16 releaseTime)
{
	m_touchPressed = FALSE;
    m_TouchSimulationStatus = 0;
	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->setTouchIntern (xCoord, yCoord, DIA_EN_PRJ_TOUCH_INFO_TOUCHED)))
		{
			DIA_TR_ERR("dia_InputSimulation::simulateSingleTouch - SEND TO IPSIM FAILED!!!!");
			m_TouchSimulationStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
//			DIA_TR_INF("dia_InputSimulation::simulateSingleTouch - X:Y(%d:%d) PRESSED", xCoord, yCoord);
			m_lastPressedTouchArea.xCoord = xCoord;
			m_lastPressedTouchArea.yCoord = yCoord;
			m_lastPressedTouchArea.releaseTime = releaseTime;

			m_touchPressed = TRUE;
		}
	}

	return DIA_SUCCESS;
}

tDiaResult dia_InputSimulation::simulatePIVITouch(tU16 xCoord, tU16 yCoord,tU16 screenNumber,tU16 releaseTime)
{
	m_touchPIVIPressed = FALSE;
    m_TouchPIVISimulationStatus = 0;
	dia_IPIVIInputHandling* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IPIVIInputHandling>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IPIVIInputHandlingListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->setPIVITouchIntern(xCoord, yCoord,screenNumber,DIA_EN_PRJ_TOUCH_INFO_TOUCHED)))
		{
			DIA_TR_ERR("dia_InputSimulation::simulatePIVITouch - SEND TO IPSIM FAILED!!!!");
			m_TouchPIVISimulationStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
		    DIA_TR_INF("dia_InputSimulation::simulatePIVITouch - X:Y(%d:%d) PRESSED", xCoord, yCoord);
			m_lastPressedPIVITouchArea.xCoord = xCoord;
			m_lastPressedPIVITouchArea.yCoord = yCoord;
			m_lastPressedPIVITouchArea.releaseTime = releaseTime;

			m_touchPIVIPressed = TRUE;
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_InputSimulation::vOnSetTouch (const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnSetTouch - eDiaResult: %d", eDiaResult);
	if (eDiaResult == DIA_SUCCESS)
	{
		if (m_touchPressed)
		{
		  if (m_lastPressedTouchArea.releaseTime) {  // Long touch operation
			  mReleaseTimerTouch.s32SetTime(m_lastPressedTouchArea.releaseTime, 0);
			  DIA_TR_INF("dia_InputSimulation::vOnSetTouch. Starting LONG PRESS TIMER (%d ms) for X:Y (%d:%d)", m_lastPressedTouchArea.releaseTime, m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord);
		  }
		  else { // Normal short touch operation
			dia_IInputHandlingPrj* pInterface = 0;
			if (((querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface)) == DIA_SUCCESS) && pInterface)
			{
				OSAL_s32ThreadWait(50);

				if (DIA_SUCCESS == (pInterface->setTouchIntern (m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord, DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED)))
				{
				//			 DIA_TR_INF("dia_InputSimulation::vOnSetTouch - X:Y(%d:%d) RELEASED", m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord);
				 (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
				}
				else
				{
				 m_TouchSimulationStatus = DIA_ERR_REQUEST_SEND;
				 DIA_TR_ERR("dia_InputSimulation::vOnSetTouch - RELEASE FAILED for X:Y (%d:%d)", m_lastPressedTouchArea.xCoord, m_lastPressedTouchArea.yCoord);
				}
			}
		  }
		}
	}
	else
	{
		m_TouchSimulationStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}

tDiaResult dia_InputSimulation::simulateTouchSlide(tU16 xCoordStart, tU16 yCoordStart, tU16 xCoordEnd, tU16 yCoordEnd, tU16 duration)
{
	m_touchSlideDone = FALSE;
    m_TouchSimulationStatus = 0;
	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->setTouchSlideIntern (xCoordStart, yCoordStart, xCoordEnd, yCoordEnd, duration)))
		{
			DIA_TR_ERR("dia_InputSimulation::simulateTouchSlide - SEND TO IPSIM FAILED!!!!");
			m_TouchSimulationStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
//			DIA_TR_INF("dia_InputSimulation::simulateTouchSlide - Start X:Y(%d:%d) - End X:Y(%d:%d) duration: %d ms", xCoordStart, yCoordStart, xCoordEnd, yCoordEnd, duration);
			m_lastTouchSlideArea.xCoordStart = xCoordStart;
			m_lastTouchSlideArea.yCoordStart = yCoordStart;
			m_lastTouchSlideArea.xCoordEnd = xCoordEnd;
			m_lastTouchSlideArea.yCoordEnd = yCoordEnd;

			m_touchSlideDone = TRUE;
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_InputSimulation::vOnSetTouchSlide (const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnSetTouchSlide - eDiaResult: %d", eDiaResult);
	if (eDiaResult == DIA_SUCCESS)
	{
		dia_IInputHandlingPrj* pInterface = 0;
		if (((querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface)) == DIA_SUCCESS) && pInterface)
		{
		  if (m_touchSlideDone)
		  {

			 (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this); // No need for an update after successful execution
		   }
		}
	}
	else
	{
		m_TouchSimulationStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}

tDiaResult dia_InputSimulation::startGestureRecording(const std::string& filePathStr)
{
	m_GestureRecordStatus = 0;
	if (m_gestureRecordStartRequested) {
		DIA_TR_ERR("dia_InputSimulation::startGestureRecording - gesture recording is already requested!!!");
		m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_gestureRecordingRunning) {
		DIA_TR_ERR("dia_InputSimulation::startGestureRecording - gesture recording is already running!!!");
		m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_gestureReplayStartRequested) {
		DIA_TR_ERR("dia_InputSimulation::startGestureRecording - gesture replay is already requested!!!");
		m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

//	m_gestureRecordingRunning = FALSE;

	if (filePathStr.size() == 0)
	{
		DIA_TR_ERR("dia_InputSimulation::startGestureRecording - filePathStr.size = 0");
		m_GestureRecordStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}
	else if (filePathStr.size() > MAX_FILE_PATH_LENGTH)
	{
		DIA_TR_ERR("dia_InputSimulation::startGestureRecording - filePathStr.size (%d) > MAX_FILE_PATH_LENGTH (%d)", filePathStr.size(), MAX_FILE_PATH_LENGTH);
		m_GestureRecordStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}

	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->recordGesture(DIA_EN_PRJ_GESTURE_RECORD_START, filePathStr)))
		{
			(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
			DIA_TR_ERR("dia_InputSimulation::startGestureRecording - SEND TO IPSIM FAILED!!!!");
			m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST ;
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::startGestureRecording - SENT REQUEST...");
//			memcpy(m_lastGestureRecordParameters.filePath, filePathStr.c_str(), strlen(filePathStr.c_str()));
//			m_gestureRecordingRunning = TRUE;
			m_gestureRecordStartRequested = TRUE;
		}
	}

	return DIA_SUCCESS;
}

tDiaResult dia_InputSimulation::stopGestureRecording(const std::string& filePathStr)
{
	m_GestureRecordStatus = 0;
	if (m_gestureRecordingRunning == FALSE) {
		DIA_TR_ERR("dia_InputSimulation::stopGestureRecording - Gesture recording is not active!");
		m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (filePathStr.size() == 0)
	{
		DIA_TR_ERR("dia_InputSimulation::stopGestureRecording - filePathStr.size = 0");
		m_GestureRecordStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}
	else if (filePathStr.size() > MAX_FILE_PATH_LENGTH)
	{
		DIA_TR_ERR("dia_InputSimulation::stopGestureRecording - filePathStr.size (%d) > MAX_FILE_PATH_LENGTH (%d)", filePathStr.size(), MAX_FILE_PATH_LENGTH);
		m_GestureRecordStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}


	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->recordGesture(DIA_EN_PRJ_GESTURE_RECORD_STOP, filePathStr)))
		{
			(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
			DIA_TR_ERR("dia_InputSimulation::stopGestureRecording - SEND TO IPSIM FAILED!!!!");
			m_GestureRecordStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::stopGestureRecording - SENT REQUEST...");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_InputSimulation::vOnRecordGesture(const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnRecordGesture - eDiaResult: %d", eDiaResult);

	if (eDiaResult == DIA_SUCCESS)
	{
		if (m_gestureRecordStartRequested == TRUE && m_gestureRecordingRunning == FALSE)
		{
			DIA_TR_INF("dia_InputSimulation::vOnRecordGesture - STARTED");
			m_gestureRecordingRunning = TRUE; // Gesture recording started successfully
			m_gestureRecordStartRequested = FALSE;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::vOnRecordGesture - STOPPED");
			m_gestureRecordingRunning = FALSE; // Gesture recording stopped successfully
			(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		}
	}
	else
	{
		m_GestureRecordStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
	(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
}

tDiaResult dia_InputSimulation::startGestureReplay(const std::string& filePathStr)
{
	m_GestureReplayStatus = 0;
	if (m_gestureReplayStartRequested) {
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - gesture replay is already requested!!!");
		m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_gestureReplayingRunning) {
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - gesture replay is already running!!!");
		m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_gestureRecordingRunning) {
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - gesture record is already running!!!");
		m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_gestureRecordStartRequested) {
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - gesture record is already requested!!!");
		m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

//	m_gestureReplayingRunning = FALSE;

	if (filePathStr.size() == 0)
	{
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - filePathStr.size = 0");
		m_GestureReplayStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}
	else if (filePathStr.size() > MAX_FILE_PATH_LENGTH)
	{
		DIA_TR_ERR("dia_InputSimulation::startGestureReplay - filePathStr.size (%d) > MAX_FILE_PATH_LENGTH (%d)", filePathStr.size(), MAX_FILE_PATH_LENGTH);
		m_GestureReplayStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}


	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->replayGesture(DIA_EN_PRJ_GESTURE_REPLAY_START, filePathStr)))
		{
			DIA_TR_ERR("dia_InputSimulation::startGestureReplay - SEND TO IPSIM FAILED!!!!");
			m_GestureReplayStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::startGestureReplay - SENT REQUEST...");
//			m_gestureReplayingRunning = TRUE;
			m_gestureReplayStartRequested = TRUE;
		}
	}

	return DIA_SUCCESS;
}

tDiaResult dia_InputSimulation::stopGestureReplay(const std::string& filePathStr)
{
	m_GestureReplayStatus = 0;
	if (m_gestureReplayStartRequested == FALSE && m_gestureReplayingRunning == FALSE) {
		DIA_TR_ERR("dia_InputSimulation::stopGestureReplay - Gesture replaying is not active!");
		m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (filePathStr.size() == 0)
	{
		DIA_TR_ERR("dia_InputSimulation::stopGestureReplay - filePathStr.size = 0");
		m_GestureReplayStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}
	else if (filePathStr.size() > MAX_FILE_PATH_LENGTH)
	{
		DIA_TR_ERR("dia_InputSimulation::stopGestureReplay - filePathStr.size (%d) > MAX_FILE_PATH_LENGTH (%d)", filePathStr.size(), MAX_FILE_PATH_LENGTH);
		m_GestureReplayStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}

	dia_IInputHandlingPrj* pInterface = 0;
	if ( (querySysAdapterInterface<dia_IInputHandlingPrj>(&pInterface) == DIA_SUCCESS) && pInterface )
	{
		(void) setSysAdapterListener<dia_IInputHandlingPrjListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (pInterface->replayGesture(DIA_EN_PRJ_GESTURE_REPLAY_STOP, filePathStr)))
		{
			DIA_TR_ERR("dia_InputSimulation::stopGestureReplay - SEND TO IPSIM FAILED!!!!");
			m_GestureReplayStatus = DIA_ERR_REQUEST_SEND;
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::stopGestureReplay - SENT REQUEST...");
//			m_gestureReplayingRunning = FALSE;
			m_gestureReplayStartRequested = FALSE;
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_InputSimulation::vOnReplayGesture (const tDiaResult eDiaResult) // TODO: This functions is called only when REPLAY ends. No information about replay started. Why?
{
	DIA_TR_INF("dia_InputSimulation::vOnReplayGesture - eDiaResult: %d", eDiaResult);

	if (eDiaResult == DIA_SUCCESS)
	{
		if (m_gestureReplayStartRequested == TRUE /*&& m_gestureReplayingRunning == FALSE*/)
		{
			DIA_TR_INF("dia_InputSimulation::vOnReplayGesture - STARTED");
			m_gestureReplayingRunning = TRUE; // Gesture replaying started successfully
//			m_gestureReplayStartRequested = FALSE;
		}
		else
		{
			DIA_TR_INF("dia_InputSimulation::vOnReplayGesture - STOPPED");
			m_gestureReplayingRunning = FALSE; // Gesture replaying stopped successfully
			(void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		}
	}
	else
	{
		m_GestureReplayStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}
/**********************************************************************************************************/
tU8 dia_InputSimulation::getKeyInjectionstatus()
{
	DIA_TR_INF("dia_InputSimulation::getKeyInjectionstatus");
	DIA_TR_INF("dia_InputSimulation::m_keyInjectionStatus = %d",m_keyInjectionStatus );
	return m_keyInjectionStatus;
}
/**********************************************************************************************************/
tU8 dia_InputSimulation::getEncRotationstatus()
{
	DIA_TR_INF("dia_InputSimulation::getEncRotationstatus");
	DIA_TR_INF("dia_InputSimulation::m_EncRotationStatus = %d",m_EncRotationStatus );
	return m_EncRotationStatus;
}
/**********************************************************************************************************/
tU8 dia_InputSimulation::getTouchSimulationstatus()
{
	DIA_TR_INF("dia_InputSimulation::getTouchSimulationstatus");
	DIA_TR_INF("dia_InputSimulation::m_TouchSimulationStatus = %d",m_TouchSimulationStatus );
	return m_TouchSimulationStatus;
}
/**********************************************************************************************************/
tU8 dia_InputSimulation::getGestureRecordstatus()
{
	DIA_TR_INF("dia_InputSimulation::getGestureRecordstatus");
	DIA_TR_INF("dia_InputSimulation::m_GestureRecordStatus = %d",m_GestureRecordStatus );
	return m_GestureRecordStatus;
}
/**********************************************************************************************************/
tU8 dia_InputSimulation::getGestureReplaystatus()
{
	DIA_TR_INF("dia_InputSimulation::getGestureReplaystatus");
	DIA_TR_INF("dia_InputSimulation::m_GestureReplayStatus = %d",m_GestureReplayStatus );
	return m_GestureReplayStatus;
}
/**********************************************************************************************************/
tVoid dia_InputSimulation::vOnSetEncoder(const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnSetEncoder. eDiaResult: %d", eDiaResult);
	if (eDiaResult == DIA_SUCCESS)
	{

	DIA_TR_INF("dia_InputSimulation::vOnSetEncoder - SetEncoder SUCCESSFUL ");

	}
	else
	{
		m_EncRotationStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}
/**************************************************************************************************************/
tVoid dia_InputSimulation::vOnSetPIVITouch (const tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_InputSimulation::vOnSetPIVITouch - eDiaResult: %d", eDiaResult);
	if (eDiaResult == DIA_SUCCESS)
	{
		if (m_touchPIVIPressed)
		{
		  if (m_lastPressedPIVITouchArea.releaseTime) {  // Long touch operation
			  mReleaseTimerTouch.s32SetTime(m_lastPressedPIVITouchArea.releaseTime, 0);
			  DIA_TR_INF("dia_InputSimulation::vOnSetPIVITouch. Starting LONG PRESS TIMER (%d ms) for X:Y (%d:%d)", m_lastPressedPIVITouchArea.releaseTime, m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord);
		  }
		  else { // Normal short touch operation
			dia_IPIVIInputHandling* pInterface = 0;
			if (((querySysAdapterInterface<dia_IPIVIInputHandling>(&pInterface)) == DIA_SUCCESS) && pInterface)
			{
				OSAL_s32ThreadWait(50);

				if (DIA_SUCCESS == (pInterface->setPIVITouchIntern(m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord,2, DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED )))
				{
				//			 DIA_TR_INF("dia_InputSimulation::vOnSetPIVITouch - X:Y(%d:%d) RELEASED", m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord);
				 (void) unsetSysAdapterListener<dia_IPIVIInputHandlingListener>(this); // No need for an update after successful execution
				}
				else
				{
				 m_TouchPIVISimulationStatus = DIA_ERR_REQUEST_SEND;
				 DIA_TR_ERR("dia_InputSimulation::vOnSetPIVITouch - RELEASE FAILED for X:Y (%d:%d)", m_lastPressedPIVITouchArea.xCoord, m_lastPressedPIVITouchArea.yCoord);
				}
			}
		  }
		}
	}
	else
	{
		m_TouchPIVISimulationStatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}
