/*
 * dia_InputHistory.cpp
 *
 *  Created on: Feb 8, 2017
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.02.2017		| 1.1	| NLK1KOR (RBEI)	| fixed NCG3D-36761
 *--------------------------------------------------------------------------------------------------------------------
* 06.06.2017       | 2.1	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
													PIVI-4235 Operation history of touch panel (secondary display)
*--------------------------------------------------------------------------------------------------------------------

 *-------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_InputHistory.h"


const tU16  INPUT_HK_PHONE 			= 768;
const tU16  INPUT_HK_CD 			= 769;
const tU16  INPUT_HK_CAMERA 		= 770;
const tU16  INPUT_HK_AUX 			= 771;
const tU16  INPUT_HK_PREV 			= 772;
const tU16  INPUT_HK_NEXT 			= 773;
const tU16  INPUT_HK_RADIO 			= 774;
const tU16  INPUT_HK_INFO 			= 775;
const tU16  INPUT_HK_SETUP 			= 776;
const tU16  INPUT_HK_MAP 			= 777;
const tU16  INPUT_HK_BACK 			= 778;
const tU16  INPUT_HK_DAY_NIGHT 		= 779;
const tU16  INPUT_HK_NAV 			= 780;
const tU16  INPUT_HK_ENTER 			= 781;
const tU16  INPUT_HK_XM 			= 782;
const tU16  INPUT_SYS_KEY_POWER 	= 783; // Not possible to simulate
const tU16  INPUT_SYS_KEY_EJECT 	= 784; // Not possible to simulate
const tU16  INPUT_HK_FM_AM 			= 785;
const tU16  INPUT_HK_MENU 			= 786;
const tU16  INPUT_HK_APP 			= 787;
const tU16  INPUT_HK_AUDIO 			= 788;
const tU16  INPUT_HK_DISP 			= 789;
const tU16  INPUT_HK_FOLDER_NEXT 	= 796;
const tU16  INPUT_HK_FOLDER_PREV 	= 797;
const tU16  INPUT_HK_PIVI_CLIMATE 	= 799;
const tU16  INPUT_HK_VIRT_SRV_TEST  = 928;

const tU16  INPUT_JOYSTICK_UP		   = 960;
const tU16  INPUT_JOYSTICK_DOWN		   = 961;
const tU16  INPUT_JOYSTICK_LEFT		   = 962;
const tU16  INPUT_JOYSTICK_RIGHT	   = 963;
const tU16  INPUT_JOYSTICK_UPPER_LEFT  = 964;
const tU16  INPUT_JOYSTICK_UPPER_RIGHT = 965;
const tU16  INPUT_JOYSTICK_LOWER_LEFT  = 966;
const tU16  INPUT_JOYSTICK_LOWER_RIGHT = 967;
const tU16  INPUT_JOYSTICK_ENTER	   = 968;
const tU16  INPUT_JOYSTICK_MAP		   = 969;
//const tU16  INPUT_JOYSTICK_OPTION    = 970; // Renault specific
const tU16  INPUT_JOYSTICK_HOME        = 971;
const tU16  INPUT_JOYSTICK_BACK        = 972;
const tU16  INPUT_JOYSTICK_DAY_NIGHT   = 973;
const tU16  INPUT_JOYSTICK_DISP        = 974;
const tU16  INPUT_JOYSTICK_OPTION_LONGPRESS = 944;
const tU16  INPUT_JOYSTICK_HOME_LONGPRESS   = 945;
const tU16  INPUT_JOYSTICK_BACK_LONGPRESS   = 946;
const tU16  INPUT_JOYSTICK_ENTER_LONGPRESS  = 947; 


const tU16  INPUT_SWC_MODE 			= 100;
const tU16  INPUT_SWC_OK 			= 101;
const tU16  INPUT_SWC_SEEK_UP 		= 102;
const tU16  INPUT_SWC_SEEK_DOWN 	= 103;
const tU16  INPUT_SWC_TEL_VR 		= 104;
const tU16  INPUT_SWC_VOL_DOWN 		= 106;
const tU16  INPUT_SWC_VOL_UP 		= 107;
const tU16  INPUT_SWC_TEL_HANG_UP 	= 108;
const tU16  INPUT_SWC_BACK 			= 109;
const tU16  INPUT_SWC_UP 			= 111;
const tU16  INPUT_SWC_DOWN 			= 112;
//const tU16  INPUT_SWC_MUTE 		   = 113; // Renault specific
//const tU16  INPUT_SWC_AUDIO_SRC_UP   = 114; // Renault specific
//const tU16  INPUT_SWC_AUDIO_SRC_DOWN = 115; // Renault specific
const tU16  INPUT_SWC_ENTER 		= 117; 

const tU8  INPUT_ENC_JOYSTICK 		= 3;
const tU8  INPUT_ENC_LEFT 			= 6;
const tU8  INPUT_ENC_RIGHT 			= 8;
const tU8  INPUT_ENC_MSMENCODER     = 7;
const tU8  INPUT_ENC_SWRC 			= 9;

dia_InputHistory::dia_InputHistory()
: m_pInputHandling(OSAL_NULL),
  m_OperationHistorySubscriptionDone(FALSE),
  m_subscribeForGetTouchInfoDone(FALSE),
  m_TouchInfoAvailable(FALSE),
  m_subscribeForEncoderDirStatusDone(FALSE),
  m_EncoderDirStatusAvailable(FALSE),
  m_subscribeForEncoderStatusDone(FALSE),
  m_EncoderStatusAvailable(FALSE),
  m_subscribeForPressedKeysInfoDone(FALSE),
  m_PressedKeysInfoAvailable(FALSE),
  m_subscribeForPIVITouchInfoDone(FALSE),
  m_PIVITouchInfoAvailable(FALSE),
  m_pPIVIInputHandling(OSAL_NULL)
{

}

dia_InputHistory::~dia_InputHistory()
{
	 _BP_TRY_BEGIN
	{
	   (void) unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_InputHistory::~dia_InputHistory !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pInputHandling) {
		m_pInputHandling = OSAL_NULL;
	}
	
	
		if (m_pPIVIInputHandling) {
		m_pPIVIInputHandling = OSAL_NULL;
	}
}

tDiaResult dia_InputHistory::subscribeForOperationhistoryInfo()
{
	dia_tclFnctTrace trc("dia_InputHistory::subscribeForOperationhistoryInfo");

	if (m_OperationHistorySubscriptionDone == FALSE)
	{
		if (querySysAdapterInterface<dia_IInputHandlingPrj>(&m_pInputHandling) == DIA_SUCCESS)
		{
			if (m_pInputHandling)
			{
				(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
				(tVoid)setSysAdapterListener<dia_IInputHandlingPrjListener>(this);

				if (m_subscribeForPressedKeysInfoDone == FALSE)
				{
					// Request keys
					if (m_pInputHandling->getPressedKeys() != DIA_SUCCESS)
					{
//						(tVoid)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
						DIA_TR_ERR("dia_InputHistory::subscribeForOperationhistoryInfo. getPressedKeys() with ERRORS!");
						return DIA_FAILED;
					}
					m_subscribeForPressedKeysInfoDone = TRUE;
				}
				if (m_subscribeForEncoderDirStatusDone == FALSE)
				{
					// Request encoder direction status
					if (m_pInputHandling->getEncoderDirStatus() != DIA_SUCCESS)
					{
//						(tVoid)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
						DIA_TR_ERR("dia_InputHistory::subscribeForOperationhistoryInfo. getEncoderDirStatus() with ERRORS!");
						return DIA_FAILED;
					}
					m_subscribeForEncoderDirStatusDone = TRUE;
				}
				if (m_subscribeForGetTouchInfoDone == FALSE)
				{
					// Request encoder direction status
					if (m_pInputHandling->getTouchInfo() != DIA_SUCCESS)
					{
//						(tVoid)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
						DIA_TR_ERR("dia_InputHistory::subscribeForOperationhistoryInfo. getTouchInfo() with ERRORS!");
						return DIA_FAILED;
					}
					m_subscribeForGetTouchInfoDone = TRUE;
				}

			}
		}
		
		if (querySysAdapterInterface<dia_IPIVIInputHandling>(&m_pPIVIInputHandling) == DIA_SUCCESS)
		{
			
			if (m_pPIVIInputHandling)
			{
				
				if (m_subscribeForPIVITouchInfoDone == FALSE)
				{
					// Request Touch info
					if (m_pPIVIInputHandling->getTouchPIVISecondaryInfo() != DIA_SUCCESS)
					{
//						(tVoid)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
						DIA_TR_ERR("dia_InputHistory::subscribeForOperationhistoryInfo. getTouchPIVISecondaryInfo() with ERRORS!");
						return DIA_FAILED;
					}
					m_subscribeForPIVITouchInfoDone = TRUE;
				}
			}
		}
		else{
			DIA_TR_ERR("dia_InputHistory::not finding SA for PIVI with ERRORS!");
		}

		DIA_TR_INF("dia_InputHistory::subscribeForOperationhistoryInfo DONE!!!");
		m_OperationHistorySubscriptionDone = TRUE;
	}

	return DIA_SUCCESS;
}

tVoid dia_InputHistory::requestPressedKeys()
{
	if (m_pInputHandling) {
		(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		(tVoid)setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		if (m_pInputHandling->getPressedKeys()== DIA_SUCCESS) {
			m_PressedKeysInfoAvailable = FALSE;
		}
	}
}

tVoid dia_InputHistory::requestEncoderDirStatus()
{
	if (m_pInputHandling)
	{
		(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		(tVoid)setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		if (m_pInputHandling->getEncoderDirStatus() == DIA_SUCCESS) {
			m_EncoderDirStatusAvailable = FALSE;
		}
	}
}

tVoid dia_InputHistory::requestTouchInfo()
{

	if (m_pInputHandling) {
		(void)unsetSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		(tVoid)setSysAdapterListener<dia_IInputHandlingPrjListener>(this);
		if (m_pInputHandling->getTouchInfo() == DIA_SUCCESS) {
			m_TouchInfoAvailable = FALSE;
		}
	}
}

tVoid dia_InputHistory::requestPIVITouchInfo()
{

	if (m_pPIVIInputHandling) {
		(void)unsetSysAdapterListener<dia_IPIVIInputHandlingListener>(this);
		(tVoid)setSysAdapterListener<dia_IPIVIInputHandlingListener>(this);
		if (m_pPIVIInputHandling->getTouchPIVISecondaryInfo() == DIA_SUCCESS) {
			m_PIVITouchInfoAvailable = FALSE;
		}
	}
}
void dia_InputHistory::vOnGetPressedKey(const std::vector<dia_tPressedKeyPrj> pressedKeys)
{
	DIA_TR_INF("dia_InputHistory::vOnGetPressedKey(). Size: %d", pressedKeys.size());

	mKeyPressedHistoryInfo.clear();
	if (!pressedKeys.empty())
	{
		if (pressedKeys.size() > MAX_OPERATION_HISTORY_ELEMS)
		{
			DIA_TR_INF("dia_InputHistory::vOnGetPressedKey :  KEY PRESS HISTORY HAS MORE THAN 2 ENTRIES");
		}
		else
		{
			DIA_TR_INF("dia_InputHistory::vOnGetPressedKey :  KEY PRESS HISTORY ENTRIES FITS INTO THE ALLOCATED MONITORING SIZE");
		}

		//convert this internal before filling and send the info
		for (tU16 i = 0; i < pressedKeys.size();i++)
		{

			dia_KeyPressedInfoElement keyPressedInfoElement;
			keyPressedInfoElement.mKeyCode = getExternalKeyID(pressedKeys[i].mCode);
			std::string internalKeyIDStr = getInternalKeyName(pressedKeys[i].mCode);
			keyPressedInfoElement.mKeyStatus = (tU8) pressedKeys[i].mStatus;
			switch (keyPressedInfoElement.mKeyStatus)
			{
			case DIA_EN_PRJ_KEY_INFO_UNKNOWN:
				DIA_TR_INF("dia_InputHistory::vOnGetPressedKey. KEY CODE: %d (%s), KEY STATUS: %d (UNKNOWN)", keyPressedInfoElement.mKeyCode, internalKeyIDStr.c_str(), keyPressedInfoElement.mKeyStatus);
				break;
			case DIA_EN_PRJ_KEY_INFO_PRESSED:
				DIA_TR_INF("dia_InputHistory::vOnGetPressedKey. KEY CODE: %d (%s), KEY STATUS: %d (PRESSED)", keyPressedInfoElement.mKeyCode, internalKeyIDStr.c_str(), keyPressedInfoElement.mKeyStatus);
				break;
			case DIA_EN_PRJ_KEY_INFO_RELEASED:
				DIA_TR_INF("dia_InputHistory::vOnGetPressedKey. KEY CODE: %d (%s), KEY STATUS: %d (RELEASED)", keyPressedInfoElement.mKeyCode, internalKeyIDStr.c_str(), keyPressedInfoElement.mKeyStatus);
				break;
			default:
				break;
			}

			mKeyPressedHistoryInfo.push_back(keyPressedInfoElement);
		}
		m_PressedKeysInfoAvailable = TRUE;
	}
}
//************************************************************************************************************************************************
void dia_InputHistory::vOnEncoderDirHistory(const std::vector<dia_tEncoderDirHistoryInfoPrj> vecEncoderDirStatus)
{
	DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory(). Size: %d", vecEncoderDirStatus.size());

	mEncoderDirStatusHistoryInfo.clear();
	if (!vecEncoderDirStatus.empty())
	{
	    if (vecEncoderDirStatus.size() > MAX_OPERATION_HISTORY_ELEMS)
		{
			DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory :  ENCODER DIR STATUS HAS MORE THAN 2 ENTRIES");
		}
		else
		{
			DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory :   ENCODER DIR STATUS FITS INTO THE ALLOCATED MONITORING SIZE");
		}

		for (tU8 i=0; i<vecEncoderDirStatus.size(); i++)
		{
		  dia_EncoderDirInfoElement encoderDirInfoElement;
		  encoderDirInfoElement.mEncoderDirSteps = vecEncoderDirStatus[i].mSteps;
		  encoderDirInfoElement.mEncoderType = vecEncoderDirStatus[i].mType;
		  switch (encoderDirInfoElement.mEncoderType)
		  {
		  case INPUT_ENC_LEFT:
			  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE: INPUT_ENC_LEFT, ENCODER STEPS: %d", encoderDirInfoElement.mEncoderDirSteps);
			  break;
		  case INPUT_ENC_RIGHT:
			  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE: INPUT_ENC_RIGHT, ENCODER STEPS: %d", encoderDirInfoElement.mEncoderDirSteps);
			  break;
		  case INPUT_ENC_JOYSTICK:
			  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE: INPUT_ENC_JOYSTICK, ENCODER STEPS: %d", encoderDirInfoElement.mEncoderDirSteps);
			  break;
		  case INPUT_ENC_MSMENCODER:
			  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE: INPUT_ENC_MSMENCODER, ENCODER STEPS: %d", encoderDirInfoElement.mEncoderDirSteps);
			  break;
		  case INPUT_ENC_SWRC:
			  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE: INPUT_ENC_SWRC, ENCODER STEPS: %d", encoderDirInfoElement.mEncoderDirSteps);
			  break;
		  default:
			  DIA_TR_ERR("dia_InputHistory::getInternalEncoderType. No valid encoder type: %d", encoderDirInfoElement.mEncoderType);
			  break;
		  }

//		  DIA_TR_INF("dia_InputHistory::vOnEncoderDirHistory. ENCODER TYPE :%s ENCODER STEPS: %d", m_EncoderDirInfoElements.DirTypeStr.c_str(), m_EncoderDirInfoElements.mEncoderDirSteps);
		  mEncoderDirStatusHistoryInfo.push_back(encoderDirInfoElement);
		}

		m_EncoderDirStatusAvailable = TRUE;
	}
}
//************************************************************************************************************************************************

void dia_InputHistory::vOnTouchInfohistory(const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo)
{
	DIA_TR_INF("dia_InputHistory::vOnTouchInfo(). Size: %d", vecTouchPressInfo.size());

	mTouchStatusHistoryInfo.clear();
	if (!vecTouchPressInfo.empty())
	{
		for (tU8 i = 0;i < vecTouchPressInfo.size();i++)
		{
			dia_TouchCoordinatesHistory touchStatusHistoryElement;
			switch (vecTouchPressInfo[i].mType)
			{
			case DIA_EN_PRJ_TOUCH_INFO_TOUCHED:
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_TOUCHED;
				touchStatusHistoryElement.xCoord = (tU16) vecTouchPressInfo[i].mXCoord;
				touchStatusHistoryElement.yCoord = (tU16) vecTouchPressInfo[i].mYCoord;
				DIA_TR_INF("dia_InputHistory::vOnTouchInfohistory PRESSED xCoord: %d yCoord: %d", vecTouchPressInfo[i].mXCoord, vecTouchPressInfo[i].mYCoord);
				break;
			case DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED:
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED;
				touchStatusHistoryElement.xCoord = (tU16) vecTouchPressInfo[i].mXCoord;
				touchStatusHistoryElement.yCoord = (tU16) vecTouchPressInfo[i].mYCoord;
				DIA_TR_INF("dia_InputHistory::vOnTouchInfohistory RELEASED xCoord: %d yCoord: %d", vecTouchPressInfo[i].mXCoord, vecTouchPressInfo[i].mYCoord);
				break;
			default :
				DIA_TR_ERR("dia_InputHistory::vOnTouchInfohistory. No valid touch type for: %d", vecTouchPressInfo[i].mType);
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_UNKNOWN;
				break;
			}

			mTouchStatusHistoryInfo.push_back(touchStatusHistoryElement);
		}

		m_TouchInfoAvailable = TRUE;
	}
}
//************************************************************************************************************************************************

std::vector<dia_KeyPressedInfoElement> dia_InputHistory::getPressedKeyHistory(tU16 maxNumberOfOperationHistoryElements)
{
	DIA_TR_INF("dia_InputHistory::getPressedKeyHistory");

	std::vector<dia_KeyPressedInfoElement> KeyPressedInfoElements;

	tU16 numberOfOperationHistoryElementsToDeliver = (tU16)mKeyPressedHistoryInfo.size();

	if (maxNumberOfOperationHistoryElements <= mKeyPressedHistoryInfo.size())
	{
		numberOfOperationHistoryElementsToDeliver = maxNumberOfOperationHistoryElements;
	}

	for (tU16 i = 0; i<numberOfOperationHistoryElementsToDeliver; i++)
	{
		KeyPressedInfoElements.push_back(mKeyPressedHistoryInfo.at(i));
	}

	DIA_TR_INF("dia_InputHistory::getPressedKeyHistory. Delivering size %d", KeyPressedInfoElements.size());

	return KeyPressedInfoElements;
}
////*****************************************************************************************************************************************************
std::vector<dia_EncoderDirInfoElement> dia_InputHistory::getEncoderDirStatus(tU16 maxNumberOfOperationHistoryElements)
{
	DIA_TR_INF("dia_InputHistory::getEncoderDirStatus");

	std::vector<dia_EncoderDirInfoElement> encoderDirStatusHistoryElements;
	tU16 numberOfOperationHistoryElementsToDeliver = (tU16)mEncoderDirStatusHistoryInfo.size();

	if (maxNumberOfOperationHistoryElements <= mEncoderDirStatusHistoryInfo.size()) {
		numberOfOperationHistoryElementsToDeliver = maxNumberOfOperationHistoryElements;
	}

	for (tU16 i = 0; i<numberOfOperationHistoryElementsToDeliver; i++) {
		encoderDirStatusHistoryElements.push_back(mEncoderDirStatusHistoryInfo.at(i));
	}

	DIA_TR_INF("dia_InputHistory::getEncoderDirStatus. Delivering size %d", encoderDirStatusHistoryElements.size());

	return encoderDirStatusHistoryElements;
}

std::vector<dia_TouchCoordinatesHistory> dia_InputHistory::getTouchStatus(tU16 maxNumberOfOperationHistoryElements)
{
	DIA_TR_INF("dia_InputHistory::getTouchStatus");

	std::vector<dia_TouchCoordinatesHistory> TouchStatusHistoryElements;
	tU16 numberOfOperationHistoryElementsToDeliver = (tU16)mTouchStatusHistoryInfo.size();

	if (maxNumberOfOperationHistoryElements <= mTouchStatusHistoryInfo.size()) {
		numberOfOperationHistoryElementsToDeliver = maxNumberOfOperationHistoryElements;
	}

	for (tU16 i = 0; i<numberOfOperationHistoryElementsToDeliver; i++) {
		TouchStatusHistoryElements.push_back(mTouchStatusHistoryInfo.at(i));
	}

	DIA_TR_INF("dia_InputHistory::getTouchStatus. Delivering size %d", TouchStatusHistoryElements.size());

	return TouchStatusHistoryElements;

}

std::string dia_InputHistory::getInternalKeyName(dia_eVdInuptHandlingKeyCodePrj enKeyCode)
{
	std::string internalKeyIDStr = "";

	switch (enKeyCode)
	{
	case DIA_PRJ_KEY_CODE_PHONE:
		internalKeyIDStr = std::string("INPUT_HK_PHONE");
		break;
	case DIA_PRJ_KEY_CODE_CD:
		internalKeyIDStr = std::string("INPUT_HK_CD");
		break;
	case DIA_PRJ_KEY_CODE_CAMERA:
		internalKeyIDStr = std::string("INPUT_HK_CAMERA");
		break;
	case DIA_PRJ_KEY_CODE_AUX:
		internalKeyIDStr = std::string("INPUT_HK_AUX");
		break;
	case DIA_PRJ_KEY_CODE_PREV:
		internalKeyIDStr = std::string("INPUT_HK_PREV");
		break;
	case DIA_PRJ_KEY_CODE_NEXT:
		internalKeyIDStr = std::string("INPUT_HK_NEXT");
		break;
	case DIA_PRJ_KEY_CODE_RADIO:
		internalKeyIDStr = std::string("INPUT_HK_RADIO");
		break;
	case DIA_PRJ_KEY_CODE_INFO:
		internalKeyIDStr = std::string("INPUT_HK_INFO");
		break;
	case DIA_PRJ_KEY_CODE_SETUP:
		internalKeyIDStr = std::string("INPUT_HK_SETUP");
		break;
	case DIA_PRJ_KEY_CODE_MAP:
		internalKeyIDStr = std::string("INPUT_HK_MAP");
		break;
	case DIA_PRJ_KEY_CODE_BACK:
		internalKeyIDStr = std::string("INPUT_HK_BACK");
		break;
	case DIA_PRJ_KEY_CODE_DAY_NIGHT:
		internalKeyIDStr = std::string("INPUT_HK_DAY_NIGHT");
		break;
	case DIA_PRJ_KEY_CODE_NAV:
		internalKeyIDStr = std::string("INPUT_HK_NAV");
		break;
	case DIA_PRJ_KEY_CODE_ENTER:
		internalKeyIDStr = std::string("INPUT_HK_ENTER");
		break;
	case DIA_PRJ_KEY_CODE_XM:
		internalKeyIDStr = std::string("INPUT_HK_XM");
		break;
	case DIA_PRJ_KEY_CODE_AM_FM:
		internalKeyIDStr = std::string("INPUT_HK_FM_AM");
		break;
	case DIA_PRJ_KEY_CODE_MENU:
		internalKeyIDStr = std::string("INPUT_HK_MENU");
		break;
	case DIA_PRJ_KEY_CODE_APP:
		internalKeyIDStr = std::string("INPUT_HK_APP");
		break;
	case DIA_PRJ_KEY_CODE_AUDIO:
		internalKeyIDStr = std::string("INPUT_HK_AUDIO");
		break;
	case DIA_PRJ_KEY_CODE_DISP:
		internalKeyIDStr = std::string("INPUT_HK_DISP");
		break;
	case DIA_PRJ_KEY_VIRTUAL_STM:
		internalKeyIDStr = std::string("INPUT_HK_VIRT_SRV_TEST");
		break;
	case DIA_PRJ_KEY_CODE_FOLDER_NEXT:
		internalKeyIDStr = std::string("INPUT_HK_FOLDER_NEXT");
		break;
	case DIA_PRJ_KEY_CODE_FOLDER_PREV:
		internalKeyIDStr = std::string("INPUT_HK_FOLDER_PREV");
		break;
	case DIA_PRJ_KEY_CODE_PIVI_CLIMATE:
		internalKeyIDStr = std::string("INPUT_HK_PIVI_CLIMATE");
		break;
	case DIA_PRJ_KEY_CODE_POWER:
		internalKeyIDStr = std::string("INPUT_SYS_KEY_POWER");
		break;
	case DIA_PRJ_KEY_CODE_EJECT:
		internalKeyIDStr= std::string("INPUT_SYS_KEY_EJECT");
		break;
	case DIA_PRJ_SWC_KEY_CODE_MODE:
		internalKeyIDStr = std::string("INPUT_SWC_MODE");
		break;
	case DIA_PRJ_SWC_KEY_CODE_OK:
		internalKeyIDStr = std::string("INPUT_SWC_OK");
		break;
	case DIA_PRJ_SWC_KEY_CODE_SEEK_UP:
		internalKeyIDStr = std::string("INPUT_SWC_SEEK_UP");
		break;
	case DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN:
		internalKeyIDStr = std::string("INPUT_SWC_SEEK_DOWN");
		break;
	case DIA_PRJ_SWC_KEY_CODE_TEL_VR:
		internalKeyIDStr = std::string("INPUT_SWC_TEL_VR");
		break;
	case DIA_PRJ_SWC_KEY_CODE_VOL_DOWN:
		internalKeyIDStr = std::string("INPUT_SWC_VOL_DOWN");
		break;
	case DIA_PRJ_SWC_KEY_CODE_VOL_UP:
		internalKeyIDStr = std::string("INPUT_SWC_VOL_UP");
		break;
	case DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP:
		internalKeyIDStr = std::string("INPUT_SWC_TEL_HANG_UP");
		break;
	case DIA_PRJ_SWC_KEY_CODE_BACK:
		internalKeyIDStr = std::string("INPUT_SWC_BACK");
		break;
	case DIA_PRJ_SWC_KEY_CODE_UP:
		internalKeyIDStr = std::string("INPUT_SWC_UP");
		break;
	case DIA_PRJ_SWC_KEY_CODE_DOWN:
		internalKeyIDStr = std::string("INPUT_SWC_DOWN");
		break;
	case DIA_PRJ_SWC_KEY_CODE_MUTE:
		internalKeyIDStr = std::string("INPUT_SWC_MUTE");
		break;
	case DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_UP:
		internalKeyIDStr = std::string("INPUT_SWC_AUDIO_SRC_UP");
		break;
	case DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_DOWN:
		internalKeyIDStr = std::string("INPUT_SWC_AUDIO_SRC_DOWN");
		break;
	case DIA_PRJ_SWC_KEY_CODE_RADIO:
		internalKeyIDStr = std::string("INPUT_SWC_RADIO");
		break;
	case DIA_PRJ_SWC_KEY_CODE_ENTER:
		internalKeyIDStr = std::string("INPUT_SWC_ENTER");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UP:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_UP");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DOWN:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_DOWN");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LEFT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_LEFT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_RIGHT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_UPPER_LEFT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_UPPER_RIGHT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_LOWER_LEFT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_LOWER_RIGHT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_ENTER:
		internalKeyIDStr  = std::string("INPUT_JOYSTICK_ENTER");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_MAP:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_MAP");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_HOME:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_HOME");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_BACK:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_BACK");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_DAY_NIGHT");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DISP:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_DISP");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_OPTION_LONGPRESS");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_HOME_LONGPRESS");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_BACK_LONGPRESS");
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS:
		internalKeyIDStr = std::string("INPUT_JOYSTICK_ENTER_LONGPRESS");
		break;
	default:
		DIA_TR_ERR("dia_InputHistory::getInternalKeyID. No valid keyID for keyCode: %d", enKeyCode);
		break;
	}

	return internalKeyIDStr;
}

tU16 dia_InputHistory::getExternalKeyID(dia_eVdInuptHandlingKeyCodePrj enKeyCode)
{
	tU16 externalKeyID = 0;
	switch (enKeyCode)
	{
	case DIA_PRJ_KEY_CODE_PHONE:
		externalKeyID = INPUT_HK_PHONE;
		break;
	case DIA_PRJ_KEY_CODE_CD:
		externalKeyID = INPUT_HK_CD;
		break;
	case DIA_PRJ_KEY_CODE_CAMERA:
		externalKeyID = INPUT_HK_CAMERA;
		break;
	case DIA_PRJ_KEY_CODE_AUX:
		externalKeyID = INPUT_HK_AUX;
		break;
	case DIA_PRJ_KEY_CODE_PREV:
		externalKeyID = INPUT_HK_PREV;
		break;
	case DIA_PRJ_KEY_CODE_NEXT:
		externalKeyID = INPUT_HK_NEXT;
		break;
	case DIA_PRJ_KEY_CODE_RADIO:
		externalKeyID = INPUT_HK_RADIO;
		break;
	case DIA_PRJ_KEY_CODE_INFO:
		externalKeyID = INPUT_HK_INFO;
		break;
	case DIA_PRJ_KEY_CODE_SETUP:
		externalKeyID = INPUT_HK_SETUP;
		break;
	case DIA_PRJ_KEY_CODE_MAP:
		externalKeyID = INPUT_HK_MAP;
		break;
	case DIA_PRJ_KEY_CODE_BACK:
		externalKeyID = INPUT_HK_BACK;
		break;
	case DIA_PRJ_KEY_CODE_DAY_NIGHT:
		externalKeyID = INPUT_HK_DAY_NIGHT;
		break;
	case DIA_PRJ_KEY_CODE_NAV:
		externalKeyID = INPUT_HK_NAV;
		break;
	case DIA_PRJ_KEY_CODE_ENTER:
		externalKeyID = INPUT_HK_ENTER;
		break;
	case DIA_PRJ_KEY_CODE_XM:
		externalKeyID = INPUT_HK_XM;
		break;
	case DIA_PRJ_KEY_CODE_AM_FM:
		externalKeyID = INPUT_HK_FM_AM;
		break;
	case DIA_PRJ_KEY_CODE_MENU:
		externalKeyID = INPUT_HK_MENU;
		break;
	case DIA_PRJ_KEY_CODE_APP:
		externalKeyID = INPUT_HK_APP;
		break;
	case DIA_PRJ_KEY_CODE_AUDIO:
		externalKeyID = INPUT_HK_AUDIO;
		break;
	case DIA_PRJ_KEY_CODE_DISP:
		externalKeyID = INPUT_HK_DISP;
		break;
	case DIA_PRJ_KEY_VIRTUAL_STM:
		externalKeyID = INPUT_HK_VIRT_SRV_TEST;
		break;
	case DIA_PRJ_KEY_CODE_FOLDER_NEXT:
		externalKeyID = INPUT_HK_FOLDER_NEXT;
		break;
	case DIA_PRJ_KEY_CODE_FOLDER_PREV:
		externalKeyID = INPUT_HK_FOLDER_PREV;
		break;
	case DIA_PRJ_KEY_CODE_PIVI_CLIMATE:
		externalKeyID = INPUT_HK_PIVI_CLIMATE;
		break;
	case DIA_PRJ_KEY_CODE_POWER:
		externalKeyID = INPUT_SYS_KEY_POWER;
		break;
	case DIA_PRJ_KEY_CODE_EJECT:
		externalKeyID= INPUT_SYS_KEY_EJECT;
		break;
	case DIA_PRJ_SWC_KEY_CODE_MODE:
		externalKeyID = INPUT_SWC_MODE;
		break;
	case DIA_PRJ_SWC_KEY_CODE_OK:
		externalKeyID = INPUT_SWC_OK;
		break;
	case DIA_PRJ_SWC_KEY_CODE_SEEK_UP:
		externalKeyID = INPUT_SWC_SEEK_UP;
		break;
	case DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN:
		externalKeyID = INPUT_SWC_SEEK_DOWN;
		break;
	case DIA_PRJ_SWC_KEY_CODE_TEL_VR:
		externalKeyID = INPUT_SWC_TEL_VR;
		break;
	case DIA_PRJ_SWC_KEY_CODE_VOL_DOWN:
		externalKeyID = INPUT_SWC_VOL_DOWN;
		break;
	case DIA_PRJ_SWC_KEY_CODE_VOL_UP:
		externalKeyID = INPUT_SWC_VOL_UP;
		break;
	case DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP:
		externalKeyID = INPUT_SWC_TEL_HANG_UP;
		break;
	case DIA_PRJ_SWC_KEY_CODE_BACK:
		externalKeyID = INPUT_SWC_BACK;
		break;
	case DIA_PRJ_SWC_KEY_CODE_UP:
		externalKeyID = INPUT_SWC_UP;
		break;
	case DIA_PRJ_SWC_KEY_CODE_DOWN:
		externalKeyID = INPUT_SWC_DOWN;
		break;
	case DIA_PRJ_SWC_KEY_CODE_ENTER:
		externalKeyID = INPUT_SWC_ENTER;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UP:
		externalKeyID = INPUT_JOYSTICK_UP;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DOWN:
		externalKeyID = INPUT_JOYSTICK_DOWN;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LEFT:
		externalKeyID = INPUT_JOYSTICK_LEFT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT:
		externalKeyID = INPUT_JOYSTICK_RIGHT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT:
		externalKeyID = INPUT_JOYSTICK_UPPER_LEFT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT:
		externalKeyID = INPUT_JOYSTICK_UPPER_RIGHT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT:
		externalKeyID = INPUT_JOYSTICK_LOWER_LEFT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT:
		externalKeyID = INPUT_JOYSTICK_LOWER_RIGHT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_ENTER:
		externalKeyID = INPUT_JOYSTICK_ENTER;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_MAP:
		externalKeyID = INPUT_JOYSTICK_MAP;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_HOME:
		externalKeyID = INPUT_JOYSTICK_HOME;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_BACK:
		externalKeyID = INPUT_JOYSTICK_BACK;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT:
		externalKeyID = INPUT_JOYSTICK_DAY_NIGHT;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_DISP:
		externalKeyID = INPUT_JOYSTICK_DISP;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS:
		externalKeyID = INPUT_JOYSTICK_OPTION_LONGPRESS;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS:
		externalKeyID = INPUT_JOYSTICK_HOME_LONGPRESS;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS:
		externalKeyID = INPUT_JOYSTICK_BACK_LONGPRESS;
		break;
	case DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS:
		externalKeyID = INPUT_JOYSTICK_ENTER_LONGPRESS;
		break;
	default:
		DIA_TR_ERR("dia_InputHistory::getInternalKeyID. No valid keyID for keyCode: %d", enKeyCode);
		break;
	}

	return externalKeyID;
}

std::vector<dia_TouchCoordinatesHistory> dia_InputHistory::getPIVITouchStatus(tU16 maxNumberOfOperationHistoryElements)
{
	DIA_TR_INF("dia_InputHistory::getPIVITouchStatus");

	std::vector<dia_TouchCoordinatesHistory> piviTouchStatusHistoryElements;
	tU16 numberOfOperationHistoryElementsToDeliver = (tU16)mPIVITouchStatusHistoryInfo.size();

	if (maxNumberOfOperationHistoryElements <= mPIVITouchStatusHistoryInfo.size()) {
		numberOfOperationHistoryElementsToDeliver = maxNumberOfOperationHistoryElements;
	}

	for (tU16 i = 0; i<numberOfOperationHistoryElementsToDeliver; i++) {
		piviTouchStatusHistoryElements.push_back(mPIVITouchStatusHistoryInfo.at(i));
	}

	DIA_TR_INF("dia_InputHistory::getPIVITouchStatus. Delivering size %d", piviTouchStatusHistoryElements.size());

	return piviTouchStatusHistoryElements;

}
//************************************************************************************************************************************************

void dia_InputHistory::vOnPIVITouchInfohistory(const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo)
{
	DIA_TR_INF("dia_InputHistory::vOnPIVITouchInfohistory(). Size: %d", vecTouchPressInfo.size());

	mPIVITouchStatusHistoryInfo.clear();
	if (!vecTouchPressInfo.empty())
	{
		for (tU8 i = 0;i < vecTouchPressInfo.size();i++)
		{
			dia_TouchCoordinatesHistory touchStatusHistoryElement;
			switch (vecTouchPressInfo[i].mType)
			{
			case DIA_EN_PRJ_TOUCH_INFO_TOUCHED:
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_TOUCHED;
				touchStatusHistoryElement.xCoord = (tU16) vecTouchPressInfo[i].mXCoord;
				touchStatusHistoryElement.yCoord = (tU16) vecTouchPressInfo[i].mYCoord;
				DIA_TR_INF("dia_InputHistory::vOnPIVITouchInfohistory PRESSED xCoord: %d yCoord: %d", vecTouchPressInfo[i].mXCoord, vecTouchPressInfo[i].mYCoord);
				break;
			case DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED:
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED;
				touchStatusHistoryElement.xCoord = (tU16) vecTouchPressInfo[i].mXCoord;
				touchStatusHistoryElement.yCoord = (tU16) vecTouchPressInfo[i].mYCoord;
				DIA_TR_INF("dia_InputHistory::vOnPIVITouchInfohistory RELEASED xCoord: %d yCoord: %d", vecTouchPressInfo[i].mXCoord, vecTouchPressInfo[i].mYCoord);
				break;
			default :
				DIA_TR_ERR("dia_InputHistory::vOnPIVITouchInfohistory. No valid touch type for: %d", vecTouchPressInfo[i].mType);
				touchStatusHistoryElement.status = (tU8) DIA_EN_PRJ_TOUCH_INFO_UNKNOWN;
				break;
			}

			mPIVITouchStatusHistoryInfo.push_back(touchStatusHistoryElement);
		}

		m_PIVITouchInfoAvailable = TRUE;
	}
}
