/**
 * \file      dia_ILMInfo.h
 *
 * \brief     Utility class for getting different information from LayerManager
 *
 *
 *  Created on: Nov 23, 2015
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */


#ifndef DIA_ILMINFO_H_
#define DIA_ILMINFO_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

enum SurfaceStates
{
   VISIBLE,
   VISIBLE_INPUT_KEY
};

enum SurfaceIdent
{
   SURFACE_ID,
   CREATOR_PID
};

class dia_ILMInfo {
public:
	dia_ILMInfo();
	virtual ~dia_ILMInfo();

	tBool isIlmInitialized() const;
	tDiaResult getPropertiesOfKeyboardFocusSurface(tU16& surfaceID, tU16& fpsOfKeyboardFocusSurface, std::string& surfaceName);

private:
//	tVoid getVisibleAndActiveSurfaceId(std::vector<tS32>& surfaceVector, tS32 surfaceState = VISIBLE, tS32 surfaceIdent = SURFACE_ID);

	std::map<tU32, std::string> m_surfaceIdMap;
	typedef std::map<tU32, std::string>::iterator mSurfaceIdMapIteratorType;
};

#endif /* DIA_ILMINFO_H_ */
