/*
 * dia_HMINavigationInfo.h
 *
 *  Created on: May 17, 2016
 *      Author: jas1hi
 /*********************************************************************************************
 * REVISION HISTORY:
 * ------------------------------------------------------------------------------------------------
 * Date 				| Rev. 				| Author 		   	| Modification
 * ------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------
 * 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file
*--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status

 *--------------------------------------------------------------------------------------------------------------------
 *******************************************************************************************************************************/

#ifndef DIA_HMINAVIGATIONINFO_H_
#define DIA_HMINAVIGATIONINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__
#include "project/interfaces/dia_IHMINavigationListener.h"
#endif

#define MAX_FILE_PATH_LENGTH           (tU16) 40

typedef struct HMINavigationInfoElement_ {

	tU32 routeCalDurationToFinalDest; // Route calculation duration to final destination
	tU32 routeCalDurationToNextDest; // Route calculation duration to next destination

	HMINavigationInfoElement_()
	{
		routeCalDurationToFinalDest = 0;
		routeCalDurationToNextDest = 0;
	}

} HMINavigationInfoElement;

class dia_HMINavigationInfo: public dia_IHMINavigationListenerImpl {
public:
	dia_HMINavigationInfo();
	virtual ~dia_HMINavigationInfo();

	/**
	 * \brief    	subscribe for HMI Navigation Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the HMI Navigation Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForHMINavigationInfo();

	tVoid vOnRouteCalculationDuration(tU32 routeCalDurationToFinalDest, tU32 routeCalDurationToNextDest);

	 tDiaResult startTripFileReplayRequest(const std::string&  tripFileName);
	 tDiaResult stopTripFileReplayRequest();
	 virtual tVoid vOnStartTripFileReplayResponse(tDiaResult eDiaResult);
	 virtual tVoid vOnStopTripFileReplayResponse(tDiaResult eDiaResult);
	 virtual tVoid vOnTripReplayStatusInfoUpdate(dia_TripReplayStatus status);
	virtual tBool isRouteCalDurationAvailable() {return m_routeCalDurationAvailable;}

	virtual HMINavigationInfoElement getHMINavigationInfoElement();
	tU8 getTripReplaystatus();
	tU8 m_TripReplaystatus;
private:
	dia_IHMINavigation* m_pHMINavigation;

	tBool m_HMINavigationInfoSubscriptionDone;
	tBool m_routeCalDurationAvailable;

	// Trip replay
	tBool m_tripReplayingRunning;
	tBool m_tripReplayStartRequested;

	HMINavigationInfoElement m_hmiNavigationInfoElement;
	


};

#endif /* DIA_HMINAVIGATIONINFO_H_ */
