/*
 * dia_HMIMonitorInfo.cpp
 *
 *  Created on: Apr 11, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-28509  secondary Screen Name
 *--------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_HMIMonitorInfo.h"

dia_HMIMonitorInfo::dia_HMIMonitorInfo()
:	m_pHMIMonitor(OSAL_NULL),
 	m_HMIMonitorInfoSubscriptionDone(FALSE),
 	m_startupTimeIntervalAvailable(FALSE),
 	m_activeSceneNameAvailable(FALSE),
 	m_startupTimeInterval(0),
	m_setHMIMonitorInfoDone(FALSE),
	m_activeSceneNameUpperAvailable(FALSE),
	m_nextActiveUpperSceneNameAvailable(FALSE),
	m_nextActiveLowerSceneNameAvailable(FALSE)
{
	 dia_tclFnctTrace trc("dia_HMIMonitorInfo::dia_HMIMonitorInfo()");
}

dia_HMIMonitorInfo::~dia_HMIMonitorInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_HMIMonitorInfo::~dia_HMIMonitorInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pHMIMonitor)
		m_pHMIMonitor = OSAL_NULL;
}

tDiaResult dia_HMIMonitorInfo::subscribeForHMIMonitorInfo()
{
	dia_tclFnctTrace trc("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo");

	if (m_HMIMonitorInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo()");

		if (querySysAdapterInterface<dia_IHMIMonitor>(&m_pHMIMonitor) == DIA_SUCCESS) {
			 if (m_pHMIMonitor) {
				 (tVoid) setSysAdapterListener<dia_IHMIMonitorListener>(this);

				 if (m_pHMIMonitor->getHMIStartUpTimeInterval() == DIA_SUCCESS) { // One time request to get the actual value
					 DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getHMIStartUpTimeInterval() OK!");
				 } else {
					DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getHMIStartUpTimeInterval() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
					return DIA_FAILED;
				 }

				 if (m_pHMIMonitor->registerToActiveRenderedViewName() == DIA_SUCCESS) {
					 if (m_pHMIMonitor->getHMIActiveForegroundScene() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo registerToActiveRenderedViewName() OK!");
					 } else {
						DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getHMIActiveForegroundScene() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
						return DIA_FAILED;
					 }
				 }
				 else {
					 DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo registerToActiveRenderedViewName() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
					return DIA_FAILED;
				 }

				 if (m_pHMIMonitor->registerToActiveRenderedUpperViewName() == DIA_SUCCESS)
				 {
					 if (m_pHMIMonitor->getActiveForegroundSceneUpper() == DIA_SUCCESS)
					 { // One time request to get the actual value
						 DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getActiveForegroundSceneUpper() OK!");
					 }
					 else
					 {
						DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getActiveForegroundSceneUpper() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
						return DIA_FAILED;
					 }
				 }
				 else
				 {
					 DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo registerToActiveRenderedUpperViewName() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
					return DIA_FAILED;
				 }
				if (m_pHMIMonitor->registerToNextActiveAppUpper() == DIA_SUCCESS)
				{
					if (m_pHMIMonitor->getNextActiveForegroundSceneUpper() == DIA_SUCCESS)
					{ // One time request to get the actual value
						 DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getNextActiveForegroundSceneUpper() OK!");
					 }
					else
					{
						DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getNextActiveForegroundSceneUpper() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
						return DIA_FAILED;
					 }
				 }	
				 else
				 {
					 DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo registerToActiveRenderedUpperViewName() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
					return DIA_FAILED;
				 }	 
                 if (m_pHMIMonitor->registerToNextActiveAppLower() == DIA_SUCCESS)
                 {
					 if (m_pHMIMonitor->getNextActiveForegroundSceneLower() == DIA_SUCCESS)
					 { // One time request to get the actual value
						 DIA_TR_INF("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getNextActiveForegroundSceneLower() OK!");
					 }
					 else
					 {
						DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getNextActiveForegroundSceneLower() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
						return DIA_FAILED;
					 }	
                 }
				 else
				{
						DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo getNextActiveForegroundSceneLower() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
						return DIA_FAILED;
				}


				 m_HMIMonitorInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_HMIMonitorInfo::subscribeForHMIMonitorInfo querySysAdapterInterface<dia_IHMIMonitorListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_HMIMonitorInfo::vOnHMIStartupTimeIntervalStatus ( tU32 startupTimeInterval )
{
	if (startupTimeInterval > 0) {
		m_startupTimeInterval = startupTimeInterval;
		m_startupTimeIntervalAvailable = TRUE;
		DIA_TR_INF("dia_HMIMonitorInfo::vOnHMIStartupTimeIntervalStatus. startupTimeInterval: %d", m_startupTimeInterval);
	}
}

tVoid dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneStatus ( std::string activeSceneName )
{
	m_activeSceneNameAvailable = TRUE;

	if (activeSceneName.size() > 0) {
		memset(m_hmiScreenInfoElement.activeScreenName, '\0', sizeof(tChar)*MAX_SCREEN_NAME_STR_LENGTH); // Invalidate any previous state

		if (activeSceneName.size() > MAX_SCREEN_NAME_STR_LENGTH) {
			memcpy(m_hmiScreenInfoElement.activeScreenName, activeSceneName.c_str(), sizeof(tChar)*MAX_SCREEN_NAME_STR_LENGTH);
		}
		else {
			memcpy(m_hmiScreenInfoElement.activeScreenName, activeSceneName.c_str(), activeSceneName.size());
		}
		DIA_TR_INF("dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneStatus. activeScreenName: '%s'", activeSceneName.c_str());
	}
}

tU32 dia_HMIMonitorInfo::getStartupTimeInterval()
{
	return m_startupTimeInterval;
}

HMIScreenInfoElement dia_HMIMonitorInfo::getHMIScreenInfoElement()
{
	if (m_activeSceneNameAvailable) {
		m_activeSceneNameAvailable = FALSE;
	}

	return m_hmiScreenInfoElement;
}
tDiaResult dia_HMIMonitorInfo::setHMIMonitorInfo(tBool hmiMonitorInfoStatus)
{
	dia_tclFnctTrace trc("dia_HMIMonitorInfo::setHMIMonitorInfo");

	if (m_setHMIMonitorInfoDone == FALSE)
	{
		DIA_TR_INF("dia_HMIMonitorInfo::setHMIMonitorInfo()");

		if (querySysAdapterInterface<dia_IHMIMonitor>(&m_pHMIMonitor) == DIA_SUCCESS) {
			if (m_pHMIMonitor) {
				(tVoid)setSysAdapterListener<dia_IHMIMonitorListener>(this);

				if (m_pHMIMonitor->setHMIMonitorInfoServiceStatus(hmiMonitorInfoStatus) == DIA_SUCCESS) { // One time request to get the actual value
					DIA_TR_INF("dia_HMIMonitorInfo::setHMIMonitorInfo setHMIMonitorInfoServiceStatus() OK!");
				}
				else {
					DIA_TR_ERR("dia_HMIMonitorInfo::setHMIMonitorInfo setHMIMonitorInfoServiceStatus() with ERRORS!");
					(tVoid)unsetSysAdapterListener<dia_IHMIMonitorListener>(this);
					return DIA_FAILED;
				}

				m_setHMIMonitorInfoDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_HMIMonitorInfo::setHMIMonitorInfo querySysAdapterInterface<dia_IHMIMonitorListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}


tVoid dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneUpperStatus ( std::string activeUpperSceneName )
{
	m_activeSceneNameUpperAvailable = TRUE;

	if (activeUpperSceneName.size() > 0) {
		memset(m_hmiScreenInfoElement.activeScreenNameUpper, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH); // Invalidate any previous state

		if (activeUpperSceneName.size() > MAX_SCREEN_DATA_LENGTH) {
			memcpy(m_hmiScreenInfoElement.activeScreenNameUpper, activeUpperSceneName.c_str(), sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		}
		else {
			memcpy(m_hmiScreenInfoElement.activeScreenNameUpper, activeUpperSceneName.c_str(), activeUpperSceneName.size());
		}
		DIA_TR_INF("dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneStatus. activeUpperSceneName: '%s'", activeUpperSceneName.c_str());
	}
}
tVoid dia_HMIMonitorInfo::vOnHMINextActiveForegroundSceneUpperStatus ( std::string nextActiveUpperSceneName )
{
	DIA_TR_INF("dia_HMIMonitorInfo::vOnHMINextActiveForegroundSceneUpperStatus. nextActiveUpperSceneName: '%s'", nextActiveUpperSceneName.c_str());
	m_nextActiveUpperSceneNameAvailable = TRUE;

	if (nextActiveUpperSceneName.size() > 0) {
		memset(m_hmiScreenInfoElement.nextActiveUpperScreenName, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH); // Invalidate any previous state

		if (nextActiveUpperSceneName.size() > MAX_SCREEN_DATA_LENGTH) {
			memcpy(m_hmiScreenInfoElement.nextActiveUpperScreenName, nextActiveUpperSceneName.c_str(), sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		}
		else {
		memcpy(m_hmiScreenInfoElement.nextActiveUpperScreenName, nextActiveUpperSceneName.c_str(), nextActiveUpperSceneName.size());
		}
		DIA_TR_INF("dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneStatus. nextActiveUpperSceneName: '%s'", nextActiveUpperSceneName.c_str());
		}

}

tVoid dia_HMIMonitorInfo::vOnHMINextActiveForegroundSceneLowerStatus ( std::string nextActiveLowerSceneName )
{
	m_nextActiveLowerSceneNameAvailable = TRUE;

	if (nextActiveLowerSceneName.size() > 0) {


		memset(m_hmiScreenInfoElement.nextActiveLowerScreenName, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH); // Invalidate any previous state

		if (nextActiveLowerSceneName.size() > MAX_SCREEN_DATA_LENGTH) {
	    memcpy(m_hmiScreenInfoElement.nextActiveLowerScreenName, nextActiveLowerSceneName.c_str(), sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		}
		else {
		memcpy(m_hmiScreenInfoElement.nextActiveLowerScreenName, nextActiveLowerSceneName.c_str(), nextActiveLowerSceneName.size());
		}
		DIA_TR_INF("dia_HMIMonitorInfo::vOnHMIActiveForegroundSceneStatus. nextActiveLowerSceneName: '%s'", nextActiveLowerSceneName.c_str());

		}
}
