/**
 * \file      dia_GnssInfo.h
 *
 * \brief     Utility class for getting the GNSS related information (e.g. speed, date, etc..)
 *
 *
 *  Created on: Mar 2, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_GNSSINFO_H_
#define DIA_GNSSINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#define MAX_DATE_STR_LENGTH (tU16) 20

typedef struct GnssInfoElement_ {
	// Fix status
	tU8 fixStatus; // 2-D, 3-D, ...

	// Speed vector
	tS16 velocityNorth;
	tS16 velocityEast;

	//	Date in format: 2015-12-31 00:00:01
	tChar dateStr[MAX_DATE_STR_LENGTH];

//#ifdef VARIANT_S_FTR_ENABLE_RIVIE
	// GPS Position
	tS32 latitudeMSeconds;
	tS32 longitudeMSeconds;
	tS16 altitude;
//#endif

	GnssInfoElement_()
	{
		fixStatus = 0;
		velocityNorth = 0;
		velocityEast = 0;
		memset(dateStr, '\0', sizeof(tChar)*MAX_DATE_STR_LENGTH);
		latitudeMSeconds = 0;
		longitudeMSeconds = 0;
		altitude = 0;
	}

} GnssInfoElement;


class dia_GnssInfo: public dia_IGNSSListenerImpl
{
public:
	dia_GnssInfo();
	virtual ~dia_GnssInfo();

	/**
	 * \brief    	subscribe for GNSS Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the GNSS Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForGnssInfo();

	virtual tVoid vOnGNSSReceiverStatus(const dia_tGNSSReceiverState& gnssReceiverState);
	virtual tVoid vOnGNSSTimeDate(tU16 Y, tU8 M, tU8 D, tU8 h, tU8 m, tU8 s, tU16 ms);
	virtual tVoid vOnGNSSVelocity (tS16 s16VelocityNorth, tS16 s16VelocityEast, tS16 s16VelocityUp);
	virtual tVoid vOnGNSSPosition(tS32 LatitudeMSeconds, tS32 LongitudeMSeconds, tS16 Altitude);

	virtual tBool isGnssInfoAvailable();
	virtual tBool isGnssInfoSubscriptionDone() {return m_gnssInfoSubscriptionDone;}

	virtual GnssInfoElement getGnssInfoElement();

private:
    dia_IGNSS* m_pGnss;

    tBool m_gnssInfoSubscriptionDone;

    tBool m_gnssReceiverStateAvailable;
    tBool m_gnssTimeDateAvailable;
    tBool m_gnssVelocityAvailable;
    tBool m_gpsPositionAvailable;

    GnssInfoElement m_gnssInfoElement;
};

#endif /* DIA_GNSSINFO_H_ */
