/**
 * \file      dia_GPUInfo.h
 *
 * \brief     Utility class for reading different information from /sys related to GPU
 *
 *
 *  Created on: Nov 27, 2015
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */


#ifndef DIA_GPUINFO_H_
#define DIA_GPUINFO_H_


#ifndef MAX_NAME_GPU_PROCESS
#define MAX_NAME_GPU_PROCESS 64
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

struct GPUMemInfo {
	tULong mTotalMem;
	tULong mUsedMem;
	tULong mFreeMem;
};

struct GPUProcess {
   pid_t m_pid;
   tChar command[MAX_NAME_GPU_PROCESS+1];
   tULong m_currentMemByte;
   tULong m_maximumMemKByte;
};

class dia_GPUInfo {
public:
	dia_GPUInfo();
	virtual ~dia_GPUInfo();

	virtual tDiaResult scanMemInfo(tULong& usedMem);
	virtual tDiaResult updateProcessList(); // Gets the list of processes that are using video memory
	virtual std::map<tULong, struct GPUProcess> getTopProcessSortedViaVideoMemoryUsage(tU16 numberOfProcess);
	virtual tDiaResult getGPUIdleTime(tFloat& gpuIdleTimePercent); // Returns the GPU usage since the last query in percent

private:
	struct GPUMemInfo mMemInfo;
//	struct GPUProcess mGPUProcess;
	std::map<tULong, struct GPUProcess> mTopProcessSortedViaGPUMemoryUsage;
	std::map<tULong, struct GPUProcess>::reverse_iterator mTopProcessReverseIterator;
};

#endif /* DIA_GPUINFO_H_ */
