/*
 * dia_CardStatus.cpp
 *
 *  Created on: Jan 18, 2016
 *      Author: jas1hi
 */
 /*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 02.09.2016		| 1.1	| NLK1KOR (RBEI)	| Implemented feature AIVINS2-19070 Connection status - Optic Disk 
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************/
#include "dia_CardStatus.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

tCString   COMMAND_HDPARM_MMCBLK1 = "hdparm -t /dev/mmcblk1";
const tU16 MAX_BUFF_LEN_FOR_LINE  = 128;
tCString   THREAD_NAME_CARDSTATUS = "CARD_STATUS";
#define DIA_OPTIC_DISK_NOT_CONNECTED 0
#define DIA_OPTIC_DISK_CONNECTED 1

dia_CardStatus::dia_CardStatus()
:	dia_ActiveObject(THREAD_NAME_CARDSTATUS),
 	m_pDeviceMGR(OSAL_NULL),
 	m_USBStatusAvailable(FALSE),
	m_eMMCStatusAvailable(FALSE),
 	m_cardStatusSubscriptionDone(FALSE),
 	m_eMMCReadSpeed(0.0),
 	m_threadStarted(FALSE),
	//m_cardStatusAvailable(FALSE),
 	//m_cardStatusSubscriptionDone(FALSE),
	m_OpticDiskStatusAvailable(FALSE),
	m_OpticDiskStatusSubscriptionDone(FALSE),
	m_u8OpticDiskConnectionStatus(DIA_OPTIC_DISK_NOT_CONNECTED)
{
	 dia_tclFnctTrace trc("dia_CardStatus::dia_CardStatus()");
}

dia_CardStatus::~dia_CardStatus()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_CardStatus::~dia_CardStatus !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pDeviceMGR)
		m_pDeviceMGR = OSAL_NULL;
}

tDiaResult dia_CardStatus::subscribeForCardStatus()
{
	if (m_cardStatusSubscriptionDone == FALSE) {
		DIA_TR_INF("dia_CardStatus::subscribeForCardStatus()");

		// Make subscription for the first time
		if (m_pDeviceMGR == OSAL_NULL) {
			if ((querySysAdapterInterface<dia_IDeviceMGR>(&m_pDeviceMGR) != DIA_SUCCESS))
			{
				DIA_TR_ERR("dia_CardStatus::subscribeForCardStatus. Querying a SystemAdapterd failed...");
				return DIA_FAILED;
			}

			(void) setSysAdapterListener<dia_IDeviceMGRListener>(this); // Activate the subscription
		}

		if (m_pDeviceMGR) {
			if (m_USBStatusAvailable == FALSE) {
		 		if (m_pDeviceMGR->getDevicesValues() != DIA_SUCCESS) { // One time request to get the actual value
					DIA_TR_ERR("dia_CardStatus::subscribeForCardStatus getDevicesValues with ERRORS!");
	//				(tVoid) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
					return DIA_FAILED;
		 		}
		    }
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
			if (m_OpticDiskStatusSubscriptionDone == FALSE) {
				 if (m_pDeviceMGR->regOpticDiskConnectionStatusValues() != DIA_SUCCESS) {
					 DIA_TR_ERR("dia_CardStatus::subscribeForCardStatus regOpticDiskConnectionStatusValues with ERRORS!");
	//					 (tVoid) unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
					 return DIA_FAILED;
				 }
				 m_OpticDiskStatusSubscriptionDone = TRUE;
			}
#endif
			if (m_eMMCStatusAvailable == FALSE && m_threadStarted == FALSE) {
				// Start a new thread for testing eMMC read speed via "hdparm" command line tool
				if (this->startThread() != DIA_SUCCESS){
					DIA_TR_ERR("dia_CardStatus::subscribeForCardStatus : Failed to start a new THREAD for hdparm!");
		//			return DIA_FAILED;
				}
				else {
					m_threadStarted = TRUE;
				}
			}

			m_cardStatusSubscriptionDone = TRUE;
		}

	}

	return DIA_SUCCESS;
}

void dia_CardStatus::vOnUSBDeviceInfo (const std::vector<dia_tDeviceInfo>& deviceInfoList)
{
	DIA_TR_INF( "dia_CardStatus::vOnUSBDeviceInfo: deviceInfoList.size() = %d", deviceInfoList.size());

	m_deviceInfoList.clear();

    if(!deviceInfoList.empty())
    {
		std::vector<dia_tDeviceInfo>::const_iterator it = deviceInfoList.begin();
		for (tU8 i=0; it != deviceInfoList.end(); ++it, ++i)
		{
			// Should be filtered already in dia_SAFeatureDeviceMGR::vHandleDeviceState(...)
			if( ( (*it).DeviceType !=  DIA_EN_DEVMGR_DEVICE_TYPE_CDROM ) && ( (*it).DeviceType !=  DIA_EN_DEVMGR_DEVICE_TYPE_SDCARD ) && ( (*it).DeviceType !=  DIA_EN_DEVMGR_DEVICE_TYPE_USB_NOT_SUPPORTED ))
			{
				DIA_TR_INF("dia_CardStatus::vOnUSBDeviceInfo: Make a copy for index %d and deviceType: %d", i, (*it).DeviceType);
				m_deviceInfoList.push_back(*it);
			}
			else
			{
			   // !!!! Not a USB device !!! -> check filter in dia_SAFeatureDeviceMGR::vHandleDeviceState(...)
			   DIA_TR_ERR( "dia_CardStatus::vOnUSBDeviceInfo: ERROR: !!!! Device is not a USB device !!! -> check filter in dia_SAFeatureDeviceMGR::vHandleDeviceState(...)" );
			   DIA_ASSERT_ALWAYS();
			}
		}
    }

    m_USBStatusAvailable = TRUE;
}

dia_tDeviceInfo dia_CardStatus::getUSBCardStatus()
{
	dia_tDeviceInfo deviceInfoUSB;

	dia_IDeviceMGR* pDeviceMGR = 0;
	if (querySysAdapterInterface<dia_IDeviceMGR>(&pDeviceMGR) == DIA_SUCCESS) {
	  if (pDeviceMGR) {
		 if (pDeviceMGR->getDevicesValues() == DIA_SUCCESS) { // One time request to get the actual value
		 }
		 else {
			DIA_TR_ERR("dia_CardStatus::getUSBCardStatus getDevicesValues with ERRORS!");
			return deviceInfoUSB;
		 }
	  }
	}

	if (!m_deviceInfoList.empty()) {
		deviceInfoUSB = m_deviceInfoList.at(0); // index 0 contains device property of last notified device
	}
	else {
		 DIA_TR_ERR( "dia_CardStatus::getUSBCardStatus: m_deviceInfoList.empty()");
	}

	return deviceInfoUSB;
}

void dia_CardStatus::vThreadEntrypointObject(void)
{
   DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject ## ENTERING TO NEW THREAD ##");

   FILE *pFile;
   dia_CardStatus* pDia_CardStatus = (this);

   DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject: ## NEW THREAD ## cmd = %s", COMMAND_HDPARM_MMCBLK1);

	if ((pFile = popen(COMMAND_HDPARM_MMCBLK1, "r")) != NULL)
	{
	   DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject: ## NEW THREAD ## popen successful");

	   tU8 i = 0;
	   char buff[MAX_BUFF_LEN_FOR_LINE] = {0};
	   while (fgets(buff, MAX_BUFF_LEN_FOR_LINE, pFile) != NULL)
	   {
		  size_t len = strlen(buff);
		  // skip empty strings
		  if (len>0)
		  {
//			 DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject: Line[%02d]%s", i, buff);

			 if (i==2) {
				 sscanf(buff, " Timing buffered disk reads: %*lu MB in  %*lf seconds =  %lf MB/sec", &pDia_CardStatus->m_eMMCReadSpeed); // Read in eMMC Read Speed from line

				 DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject: eMMCReadSpeed: %lf MB/sec", pDia_CardStatus->m_eMMCReadSpeed);

				 pDia_CardStatus->m_eMMCStatusAvailable = TRUE;
			 }
		  }
		  i++;
	   }

	   tS32 pCloseReturnValue = pclose(pFile);

	   DIA_TR_INF("dia_CardStatus::vThreadEntrypointObject: ## NEW THREAD ## pCloseReturnValue = 0x%08X", pCloseReturnValue);
	}

	pDia_CardStatus->m_threadStarted = FALSE;
}

tDouble dia_CardStatus::geteMMCReadSpeed()
{
	if (m_eMMCStatusAvailable) {
		m_eMMCStatusAvailable = FALSE; // Avoid permanent reading of this data
	}

	return m_eMMCReadSpeed;
}
/*******************************************************************************************
* FUNCTION:		vOnOpticDiskConnectionStatus
* DESCRIPTION:	Service handler function for handling the response from System adapter for 
                DevManagerNotifySlotStateOpticalDisc property change update request
* PARAMETER:	const  tU8	
*
* RETURNVALUE:	void
*
********************************************************************************************/
//#ifdef VARIANT_S_FTR_ENABLE_RIVIE
 void dia_CardStatus::vOnOpticDiskConnectionStatus (const  dia_eOpticalDiscSlotState eOpticDiskStatus )
{
	DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d", eOpticDiskStatus);

    switch (eOpticDiskStatus)
    {	       
		case DIA_EN_OPTDISC_INITIALISING:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INITIALISING", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INITIALISED:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INITIALISED", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_LASTMODE_EMTPY:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_LASTMODE_EMTPY", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_LASTMODE_INSERTED_CDDA:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_LASTMODE_INSERTED_CDDA", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_LASTMODE_INSERTED_CDROM:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_LASTMODE_INSERTED_CDROM", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_LASTMODE_INSERTED_CDERROR:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_LASTMODE_INSERTED_CDERROR", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTING:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTING", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_CDAUDIO:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_CDAUDIO ", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_CDROM:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_CDROM", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_CDERROR:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_CDERROR", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDAUDIO:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_AUTOMATIC_CDAUDIO ", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDROM:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_AUTOMATIC_CDROM", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDERROR:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_INSERTED_AUTOMATIC_CDERROR ", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_EJECTING:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d -DM_OPTDISC_EJECTING", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_EJECTED_EMPTY:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_EJECTED_EMPTY", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_EJECTED_READY_TO_REMOVE:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_EJECTED_READY_TO_REMOVE", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		case DIA_EN_OPTDISC_UNDEFINED_STATE:
			 DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_UNDEFINED_STATE ", eOpticDiskStatus);
			 m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			 break;
		default:
			DIA_TR_INF( "dia_CardStatus::vOnOpticDiskConnectionStatus: m_u8OpticDiskConnectionStatus= %d - DM_OPTDISC_UNDEFINED_STATE", eOpticDiskStatus);
			m_u8OpticDiskConnectionStatus = DIA_OPTIC_DISK_NOT_CONNECTED;
			break;
	}

    m_OpticDiskStatusAvailable = TRUE;
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

tU8 dia_CardStatus::getOpticDiskConStatusResult()
{
	if (m_OpticDiskStatusAvailable){
		m_OpticDiskStatusAvailable = FALSE;
	}

    return 	m_u8OpticDiskConnectionStatus;
}
