/*
 * dia_CANSignalLogging.h
 *
 *  Created on: Sep 27, 2016
 *      Author: jas1hi
 */

#ifndef DIA_CANSIGNALLOGGING_H_
#define DIA_CANSIGNALLOGGING_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// forward declaration
class csm_tclCsmAccessUser;


class dia_CANSignalLogging
{
public:

	DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_CANSignalLogging);

	/**
	 * \brief    	subscribe for CAN-Signals
	 *
	 *				Function subscribes to the SystemAdapter for getting the desired CAN-Signals
	 */
//	tDiaResult subscribeForCANSignals();

	tDiaResult registerCANSignals(const std::vector<tU16>& canSignalList); // Updates the local reference (m_canSignalList) of CAN-Signals to register
	tDiaResult unregisterAllCANSignals() const;

	static tVoid signalIndCallback(tVoid* /*pHandle*/, tU32 signalId, tU32 /*state*/);

private:
	static csm_tclCsmAccessUser*   s_pCsmAccessUser; // pointer to CMS_proxy object

	std::vector<tU16> m_canSignalList;

	tDiaResult signalRead(tU32 signalId) const;
	tVoid printSignalBytes(tU32 signalId, const std::vector<tU8>& signalBytes, tU16 sizeOfArray) const;
};

#endif /* DIA_CANSIGNALLOGGING_H_ */
