/**
 * \file      dia_CardStatus.h
 *
 * \brief     Utility class for getting different CAN Signals per subscription from CSM
 *
 *
 *  Created on: Sep 27, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_CSM_IF__
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#endif

#ifndef DIA_TRACEPROJECT_H_
#include "project/framework/trace/dia_traceProject.h"
#endif

#include "dia_CANSignalLogging.h"

// Get the normal signal ID out of abstract signal ID
#define MAKE_SIG_ID(aidx)     ((aidx)>>16)

DIA_IMPL_SINGLETON(dia_CANSignalLogging)

csm_tclCsmAccessUser*   dia_CANSignalLogging::s_pCsmAccessUser = OSAL_NULL;

tDiaResult dia_CANSignalLogging::unregisterAllCANSignals() const
{
	DIA_TR_CUS_INF("dia_CANSignalLogging::unregisterAllCANSignals...");

	_BP_TRY_BEGIN
	{
		if(s_pCsmAccessUser)
		{
			if (s_pCsmAccessUser->s32SignalCallbackDeInitAll() != CSM_C_NO_ERROR) {
				DIA_TR_CUS_ERR("dia_CANSignalLogging::unregisterAllCANSignals, Failed to deinit Signal callbacks!!!");
				return DIA_FAILED;
			}

//			if (s_pCsmAccessUser->s32ApplCallbackDeInit() != CSM_C_NO_ERROR) {
//				DIA_TR_ERR("dia_CANSignalLogging::unregisterAllCANSignals, Failed to deinit App callbacks!!!");
//				return DIA_FAILED;
//			}

//			delete s_pCsmAccessUser;
//			s_pCsmAccessUser = OSAL_NULL;

//			for (tU16 i=0; i<m_canSignalList.size(); i++) {
//				DIA_TR_INF("dia_CANSignalLogging::unregisterAllCANSignals, Unsubscribing CAN-Signal: 0x%04X", m_canSignalList.at(i));
//
//				tU32 signalID = (tU32) CBR_AL_MAKE_ASIG_ID((tU32)m_canSignalList.at(i));
//
//				DIA_TR_INF("dia_CANSignalLogging::unregisterAllCANSignals, Calculated CAN-Signal-ID: %d", signalID);
//
//				tS32 deInitCallbackStatus = s_pCsmAccessUser->s32SignalCallbackDeInit(signalID);
//				DIA_TR_INF("dia_CANSignalLogging::unregisterAllCANSignals: Deinit callback status: %d", deInitCallbackStatus);
//				if (deInitCallbackStatus != CSM_C_NO_ERROR){
//					DIA_TR_ERR("dia_CANSignalLogging::unregisterAllCANSignals, Failed to deinit callback for signal-ID: %d", signalID);
////					return DIA_FAILED;
//				}
//			}
//			m_canSignalList.clear();
		}
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_CANSignalLogging::unregisterAllCANSignals !!!");
		NORMAL_M_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	return DIA_SUCCESS;
}

tDiaResult dia_CANSignalLogging::registerCANSignals(const std::vector<tU16>& canSignalList)
{
	if (canSignalList.size() == 0) {
		DIA_TR_CUS_ERR("dia_CANSignalLogging::registerCANSignals, Size of CAN-Signals must be > 0");
		return DIA_FAILED;
	}

	DIA_TR_CUS_INF("dia_CANSignalLogging::registerCANSignals, Received request for total %d CAN-Signal(s)", canSignalList.size());

	m_canSignalList = canSignalList;

	if (m_canSignalList.size() != canSignalList.size()) {
		DIA_TR_CUS_ERR("dia_CANSignalLogging::registerCANSignals, Failed to assign new CAN-Signals!!!");
		return DIA_FAILED;
	}

	// Object creation and registration only during the first call of this function
	if (s_pCsmAccessUser == OSAL_NULL) {
		s_pCsmAccessUser = new csm_tclCsmAccessUser();

		// register with CSM_Proxy
	   s_pCsmAccessUser->vApplCallbackPreInit();

	}
//	else {
//		// Cancel previous subscription
//		if (s_pCsmAccessUser->s32SignalCallbackDeInitAll() != CSM_C_NO_ERROR) {
//			DIA_TR_CUS_ERR("dia_CANSignalLogging::registerCANSignals, Failed to deinit previous callbacks!!!");
//			return DIA_FAILED;
//		}
//	}

	// Subscribe for each requested CAN-Signal
	for (tU16 i=0; i<m_canSignalList.size(); i++) {
		DIA_TR_CUS_INF("dia_CANSignalLogging::registerCANSignals, Subscribing for CAN-Signal: 0x%04X", m_canSignalList.at(i));

		tU32 signalID = (tU32) 0x00;//CBR_AL_MAKE_ASIG_ID((tU32)m_canSignalList.at(i));Task 239541

		DIA_TR_CUS_INF("dia_CANSignalLogging::registerCANSignals, Calculated CAN-Signal-ID: %d", signalID);

		// Manually reading the signal for the first time
		if (signalRead(signalID) != DIA_SUCCESS) {
			DIA_TR_CUS_ERR("dia_CANSignalLogging::registerCANSignals, Failed to read CAN-signal-ID: %d", signalID);
			return DIA_FAILED;
		}
//Task 239541
#if 0
//		s32SignalCallbackInit( tU32 u32SignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd )
		tS32 initCallbackStatus = s_pCsmAccessUser->s32SignalCallbackInit(signalID, signalIndCallback);
		DIA_TR_CUS_INF("dia_CANSignalLogging::signalIndCallback: Init callback status: %d", initCallbackStatus);
		if (initCallbackStatus != CSM_C_NO_ERROR){
			DIA_TR_CUS_ERR("dia_CANSignalLogging::registerCANSignals, Failed to init callback for signal-ID: %d", signalID);
			return DIA_FAILED;
		}
#endif
	}

	return DIA_SUCCESS;
}

tVoid dia_CANSignalLogging::signalIndCallback(tVoid* /*pHandle*/, tU32 signalId, tU32 /*state*/)
{
	DIA_TR_CUS_INF("dia_CANSignalLogging::signalIndCallback: Signal (%d) received", signalId);

	dia_CANSignalLogging::getInstance()->signalRead(signalId);
}

tDiaResult dia_CANSignalLogging::signalRead(tU32 signalId) const
{
	DIA_TR_CUS_INF("dia_CANSignalLogging::signalRead: Reading CAN-Signal: %d", MAKE_SIG_ID(signalId));

	if (s_pCsmAccessUser == OSAL_NULL) {
		DIA_TR_CUS_ERR("dia_CANSignalLogging::signalRead: pointer s_pCsmAccessUser = NULL");
		return DIA_FAILED;
	}

	std::vector<tU8> buf(8, 0);
	tU32 signalStatus = 0;
	tS32 result = s_pCsmAccessUser->s32SignalRead(signalId, (tVoid*)&buf[0], static_cast<tU8>(buf.size() & 0xff), &signalStatus);
	if ((result == CSM_C_NO_ERROR) && ((signalStatus & CSM_C_SIGNAL_TIMEOUT) == 0) && (((signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) == CSM_C_SIGNAL_ARRIVED_FIRST) || ((signalStatus & CSM_C_SIGNAL_ARRIVED) == CSM_C_SIGNAL_ARRIVED)))
	{
//		DIA_TR_INF("dia_CANSignalLogging::signalRead: Bytes: 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X", buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);

		// Convert Signal to the numerical value

		// 1. Determine the first non-zero byte relevant for this Signal
		for (tU8 i=7; i>0; i--) {
			if (buf.at(i) != 0) {
				DIA_TR_INF("dia_CANSignalLogging::signalRead: First nonzero index: %d", i);
				printSignalBytes(signalId, buf, i);
				break;
			}
		}
	}
	else
	{
		DIA_TR_CUS_ERR("dia_CANSignalLogging::signalRead: FAILED with result: %d and signalStatus: %d", result, signalStatus);
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}


tVoid dia_CANSignalLogging::printSignalBytes(tU32 signalId, const std::vector<tU8>& signalBytes, tU16 sizeOfArray) const
{
	switch (sizeOfArray)
	{
		case 0:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X", signalId, signalBytes[0]);
			break;

		case 1:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1]);
			break;

		case 2:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2]);
			break;

		case 3:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2], signalBytes[3]);
			break;

		case 4:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2], signalBytes[3], signalBytes[4]);
			break;

		case 5:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2], signalBytes[3], signalBytes[4], signalBytes[5]);
			break;

		case 6:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2], signalBytes[3], signalBytes[4], signalBytes[5], signalBytes[6]);
			break;

		case 7:
			DIA_TR_CUS_INF("dia_CANSignalLogging::printSignalBytes (ID: %d): 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X", signalId, signalBytes[0], signalBytes[1], signalBytes[2], signalBytes[3], signalBytes[4], signalBytes[5], signalBytes[6], signalBytes[7]);
			break;

		default:
			DIA_TR_CUS_ERR("dia_CANSignalLogging::printSignalBytes (ID: %d): ERROR: Unsupported array size: %d", signalId, sizeOfArray);
			break;
	}
}
