/**
 * \file      dia_BTConnectionStatusInfo.h
 *
 * \brief     Utility class for getting the BT Phone connection info (e.g. connections status, device name, signal quality, etc..)
 *
 *
 *  Created on: Oct 2, 2016
 *      Author: nlk1kor
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_BTCONNECTIONSTATUSINFO_H_
#define DIA_BTCONNECTIONSTATUSINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST_LISTENER__
#include "project/interfaces/dia_IBluetoothMostListener.h"
#endif

#define MAX_BT_NAME_STR_LENGTH (tU16) 20  //max length of the BT device name

typedef struct BTDeviceInfo_ {
	// Connection status
	tU8 btDevConnectionStatus;
	// Reason for the disconnected phone
	tU8 btDevDisconnectedReason;
	//	BT device Name
	tChar btDevName[MAX_BT_NAME_STR_LENGTH];

	BTDeviceInfo_()
	{
		btDevConnectionStatus = 0;
		btDevDisconnectedReason = 0;
		memset(btDevName, '\0', sizeof(tChar)*MAX_BT_NAME_STR_LENGTH);
	}

}BTDeviceInfo;

typedef struct BTSignalQualityInfo_ {
	tU8 signalQuality;
	tU8 linkQuality;

	BTSignalQualityInfo_()
	{
		signalQuality = 0;
		linkQuality = 0;
	}

}BTSignalQualityInfo;

class dia_BTConnectionStatusInfo : public dia_IBluetoothMostListenerImpl
{
public:
	dia_BTConnectionStatusInfo();
	virtual ~dia_BTConnectionStatusInfo();
	/**
	 * \brief    	subscribe for BT Phone connection info
	 *
	 *				Function subscribes to the SystemAdapter for getting the phone connection Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForBTConnectionInfo();

	/**
	 * \brief    	request for BT Signal quality
	 *
	 *				Function subscribes to the SystemAdapter for getting the BT signal quality Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult requestBTSignalQuality();

	tBool isSubscribeForBTConnectionStatusInfoDone() {return mBTConnectionStatusInfoSubscriptionDone;}
	tBool isBTConnectionInfoAvailable() {return mBTConnectionInfoAvailable;}
	tBool isBTSignalQualityInfoAvailable() {return mBTSignalQualityInfoAvailable;}

	void vOnBTConnectedDeviceList(tU8 numOfPairedDev, const dia_tBTExtendedDeviceInfo* devInfo);
	void vOnCustBTLinkQualityResult (tU8 signalQuality, tU8 linkQuality);
	void vOnCustBTLinkQualityError (tDiaResult result);

	std::vector<BTDeviceInfo> getBTConnectedDeviceList(tU16 maxNumberOfBTDeviceElements);
	BTSignalQualityInfo getBTSignalQuality();

private :
	tBool mBTConnectionStatusInfoSubscriptionDone;
	tBool mBTConnectionInfoAvailable;
	std::vector<BTDeviceInfo> mBTDeviceInfo;

	tBool mBTSignalQualityInfoAvailable;
	BTSignalQualityInfo mBTSignalQualityInfo; // TODO: Extend it to support List
};
#endif /* DIA_BTCONNECTIONSTATUSINFO_H_ */

