/*
 * dia_BTConnectionStatusInfo.cpp
 *
 *  Created on: Oct 2, 2016
 *      Author: nlk1kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_BTConnectionStatusInfo.h"

//#define MAX_CONNECTED_BT_DEVICES 2
//**********************************************************************************************************************************************

dia_BTConnectionStatusInfo::dia_BTConnectionStatusInfo()
	: /*m_pBTdevInfo(NULL),*/
	  mBTConnectionStatusInfoSubscriptionDone(FALSE),
	  mBTConnectionInfoAvailable(FALSE),
	  mBTSignalQualityInfoAvailable(FALSE)
{
	dia_tclFnctTrace trc("dia_ConnectionStatusInfo::dia_ConnectionStatusInfo()");
}


//*************************************************************************************************************************************************

dia_BTConnectionStatusInfo::~dia_BTConnectionStatusInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IBluetoothMostListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_BTConnectionStatusInfo::~dia_BTConnectionStatusInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

//	delete m_pBTdevInfo;
}

//*************************************************************************************************************************************************

tDiaResult dia_BTConnectionStatusInfo::subscribeForBTConnectionInfo()
{
	dia_tclFnctTrace trc("dia_BTConnectionStatusInfo::subscribeForBTConnectionInfo");

	if (mBTConnectionStatusInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_BTConnectionStatusInfo::subscribeForBTConnectionInfo()");
        dia_IBluetoothMost* pBluetoothMost = 0;
		if (querySysAdapterInterface<dia_IBluetoothMost>(&pBluetoothMost) == DIA_SUCCESS)
		{
			 if (pBluetoothMost)
			 {
				 (tVoid) setSysAdapterListener<dia_IBluetoothMostListener>(this);
				 if (pBluetoothMost->registerToBTConnectionStatus() != DIA_SUCCESS)
				 {
					 (tVoid)unsetSysAdapterListener<dia_IBluetoothMostListener>(this);
					 DIA_TR_ERR("dia_BTConnectionStatusInfo::subscribeForBTConnectionInfo registerToBTConnectionStatus() with ERRORS!");
					 return DIA_FAILED;
				 }
				 DIA_TR_INF("dia_BTConnectionStatusInfo::subscribeForBTConnectionInfo DONE!!!");

				 mBTConnectionStatusInfoSubscriptionDone = TRUE;
			}
		}
	}

	return DIA_SUCCESS;
}

//***********************************************************************************************************************************************************

void dia_BTConnectionStatusInfo::vOnBTConnectedDeviceList(tU8 numOfPairedDev, const dia_tBTExtendedDeviceInfo* devInfo)
{
  DIA_TR_INF("dia_BTConnectionStatusInfo::vOnBTConnectedDeviceList. numOfPairedDev: %d", numOfPairedDev);

  mBTConnectionInfoAvailable = FALSE;

  if ((numOfPairedDev > 0) && (devInfo != NULL))
  {
	  mBTDeviceInfo.clear();
	  for (tU16 i = 0; i < numOfPairedDev;i++)
	  {
		  BTDeviceInfo btDeviceElement;
		  btDeviceElement.btDevConnectionStatus = devInfo[i].btDevConnectionStatus;
		  btDeviceElement.btDevDisconnectedReason = (tU8)devInfo[i].btDevDisconnectedReason;
		  memcpy(btDeviceElement.btDevName, devInfo[i].btDevName, sizeof(tChar)*MAX_BT_NAME_STR_LENGTH);
		  mBTDeviceInfo.push_back(btDeviceElement);
	  }

	  mBTConnectionInfoAvailable = TRUE;
  }

}
//************************************************************************************************************************************************

void dia_BTConnectionStatusInfo::vOnCustBTLinkQualityResult (tU8 signalQuality, tU8 linkQuality)
{
	DIA_TR_INF("dia_BTConnectionStatusInfo::vOnCustBTLinkQualityResult => signalQuality: 0x%X, linkQuality: 0x%X", signalQuality, linkQuality);

	mBTSignalQualityInfo.signalQuality = signalQuality;
	mBTSignalQualityInfo.linkQuality = linkQuality;

	mBTSignalQualityInfoAvailable = TRUE;
}

//************************************************************************************************************************************************

void dia_BTConnectionStatusInfo::vOnCustBTLinkQualityError (tDiaResult result)
{
	DIA_TR_INF("dia_BTConnectionStatusInfo::vOnCustBTLinkQualityError");

	mBTSignalQualityInfoAvailable = FALSE;
}

//************************************************************************************************************************************************

std::vector<BTDeviceInfo> dia_BTConnectionStatusInfo::getBTConnectedDeviceList(tU16 maxNumberOfBTDeviceElements)
{
	DIA_TR_INF("dia_BTConnectionStatusInfo::getBTConnectedDeviceList");

	std::vector<BTDeviceInfo> BTDeviceElements;
	tU16 numberOfBTDeviceElemetsToDeliver = (tU16)mBTDeviceInfo.size();

	if (maxNumberOfBTDeviceElements <= mBTDeviceInfo.size()) {
		numberOfBTDeviceElemetsToDeliver = maxNumberOfBTDeviceElements;
	}

	for (tU16 i = 0; i<numberOfBTDeviceElemetsToDeliver; i++) {
		BTDeviceElements.push_back(mBTDeviceInfo.at(i));
	}

	DIA_TR_INF("dia_BTConnectionStatusInfo::getBTConnectedDeviceList. Delivering size %d", BTDeviceElements.size());
	
    return BTDeviceElements;
}

tDiaResult dia_BTConnectionStatusInfo::requestBTSignalQuality()
{
	DIA_TR_INF("dia_BTConnectionStatusInfo::requestBTSignalQuality");

	dia_IBluetoothMost* pBluetoothMost = 0;
	if (querySysAdapterInterface<dia_IBluetoothMost>(&pBluetoothMost) == DIA_SUCCESS)
	{
		 if (pBluetoothMost)
		 {
			 if (pBluetoothMost->getBTSignalQuality() != DIA_SUCCESS)
			 {
				 DIA_TR_ERR("dia_BTConnectionStatusInfo::requestBTSignalQuality getBTSignalQuality() with ERRORS!");
				 return DIA_FAILED;
			 }
		}
	}

	return DIA_SUCCESS;
}

BTSignalQualityInfo dia_BTConnectionStatusInfo::getBTSignalQuality()
{
	DIA_TR_INF("dia_BTConnectionStatusInfo::getBTSignalQuality");

	mBTSignalQualityInfoAvailable = FALSE;

	return mBTSignalQualityInfo;
}
