/*
 * dia_SrvHandler_XCPMonitoring.h
 *
 *  Created on: Sep 30, 2015
 *      Author: jas1hi
 */
 /*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 02.09.2016		| 1.1	| NLK1KOR (RBEI)	| Implemented feature AIVINS2-19070 Connection status - Optic Disk 
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
* 19.01.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented feature AIVI-35187  Performance indicator (Interrupt latency and frequency)
                                                  Connection Status
*-------------------------------------------------------------------------------------------------------------------
* 01.02.2017		| 1.3	| JAS1HI (RBCM  )	| Implemented feature AIVI-28134  Copy of DTC
*--------------------------------------------------------------------------------------------------------------------
* 09.02.2017		| 1.4	| NLK1KOR (RBEI)	| Implemented : 
                                                  * AIVI-42494 Worker class for the tuning of lighting timing
                                                  * AIVI-28703 Worker class for the Sensor simulation via sensor log file
                                                  * updated feature AIVI-35187  Performance indicator (Interrupt latency and frequency)
                                                    
*-------------------------------------------------------------------------------------------------------------------
* 08.02.2017		| 1.5	| JAS1HI (RBCM  )	| Utilizing the new worker class dia_InputHistory
*--------------------------------------------------------------------------------------------------------------------
* 24.02.2017		| 1.6	| NLK1KOR (RBEI  )	| implemented feature AIVI-28127 XCP_Provider : P-IVI: Worker class for the power status
*--------------------------------------------------------------------------------------------------------------------
* 24.02.2017		| 1.7	| NLK1KOR (RBEI  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication (connection) status
*-------------------------------------------------------------------------------------------------------------------
* 01.03.2017		| 1.8	| JAS1HI  (RBCM)	| Implemented: AIVI-28129 - Configuration information
* 												  Implemented: AIVI-28131 - Configuration information of neighboring devices
*-------------------------------------------------------------------------------------------------------------------
* 09.03.2017		| 1.9	| JAS1HI (RBCM)	    | Added new member variables to avoid subsequent subscriptions to already failed items
*--------------------------------------------------------------------------------------------------------------------
* NCG3D-44304      | 2.0	| NLK1KOR (RBEI  )	|  fix for A2L Parameter value of Power status is always 0
*--------------------------------------------------------------------------------------------------------------------
* NCG3D-44304      | 2.1	| NLK1KOR (RBEI  )	| Implemented PIVI-4292 Communication (connection) status
*--------------------------------------------------------------------------------------------------------------------
* 06.06.2017       | 2.2	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
*--------------------------------------------------------------------------------------------------------------------												
* 26.06.2017       | 2.3	| NLK1KOR (RBEI  )	| Implemented Encoder Push key simulation.
                                                  Implemented reset historz 20 elements.
*--------------------------------------------------------------------------------------------------------------------												
* 18.08.2017       | 2.4	| NLK1KOR (RBEI  )	| Implemented     AIVI-58793 Worker class for Bose Amplifier ANC and ASC SW Version.

*--------------------------------------------------------------------------------------------------------------------
* 05.09.2017       | 2.5	| NLK1KOR (RBEI  )	| Implemented     AIVI-28508 P-IVI: Worker class for different VR steps

*--------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************/

#ifndef DIA_SRV_HANDLER_XCPMONITORING_H_
#define DIA_SRV_HANDLER_XCPMONITORING_H_


#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef DIA_PROCINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_ProcInfo.h"
#endif

#ifndef DIA_ILMINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_ILMInfo.h"
#endif

#ifndef DIA_GPUINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_GPUInfo.h"
#endif

#ifndef DIA_RESETHISTORYINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_ResetHistoryInfo.h"
#endif

#ifndef DIA_POWERSTATUSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_PowerStatusInfo.h"
#endif

#ifndef DIA_VEHICLESIGNALSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_VehicleSignalsInfo.h"
#endif

#ifndef DIA_COMMUNICATIONSTATUS_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_CommunicationStatus.h"
#endif

#ifndef DIA_CARDSTATUS_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_CardStatus.h"
#endif

#ifndef DIA_STARTUPSTATUSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_StartupStatusInfo.h"
#endif

#ifndef DIA_GNSSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_GnssInfo.h"
#endif

#ifndef DIA_WLANINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_WlanInfo.h"
#endif

#ifndef DIA_SENSORINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_SensorInfo.h"
#endif

#ifndef DIA_HEATCONTROLINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_HeatControlInfo.h"
#endif

#ifndef DIA_HMIMONITORINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_HMIMonitorInfo.h"
#endif

#ifndef DIA_SDSGUIPOPUPINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_SdsGuiPopupInfo.h"
#endif

#ifndef DIA_HMINAVIGATIONINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_HMINavigationInfo.h"
#endif

#ifndef DIA_PHONECONNECTIONINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_PhoneConnectionInfo.h"
#endif

#ifndef DIA_INPUTSIMULATION_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_InputSimulation.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#ifndef DIA_BTCONNECTIONSTATUSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_BTConnectionStatusInfo.h"
#endif
#ifndef DIA_WIFIPOWERCHANGE_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_WifiPowerChange.h"
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
#ifndef DIA_DTCINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_DTCInfo.h"
#endif
#ifndef DIA_CONFIGINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_ConfigInfo.h"
#endif
#ifndef DIA_VERSIONINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_VersionInfo.h"
#endif
#endif

#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)
#ifndef DIA_INPUTHISTORY_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_InputHistory.h"
#endif
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#ifndef DIA_LIGHTINGDIMMING_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_LightingDimming.h"
#endif
#ifndef DIA_CLOCKSWCCONNECTIONSTATUSINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_ClockSWCConnectionStatusInfo.h"
#endif
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#ifndef DIA_BOSEAMPINFO_H_
#include "project/services/customer/MonitoringCalibration/worker/dia_BoseAmpInfo.h"
#endif
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#include "project/services/customer/MonitoringCalibration/config/dia_defsDebugTraceConfig.h"
#endif

class dia_SrvHandler_XCPMonitoring: public dia_ServiceHandlerUDS
{
public:
	//! class constructor
		dia_SrvHandler_XCPMonitoring();

	//! class destructor
		virtual ~dia_SrvHandler_XCPMonitoring();

	//! handle the received request
		virtual tVoid vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ );

//protected:
//		DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandler_XCPMonitoring);

private:
		dia_enRunlevel mRunLevel;
		tU8 mAllianceVariantType;

		/*********** MONITORING ***********/

		tDiaResult getGPUInfo();
		tDiaResult getProcInfo(); // Delivers the CPU idle time, the load of top 5 processes and memory usage of top processes
		tDiaResult getSurfaceProperties();

		tDiaResult getResetInfo();
		tDiaResult getPowerStatusInfo();
		tDiaResult getVehicleSignalsInfo();
		tDiaResult getCommunicationStatus();
		tDiaResult getCardStatus();
		tDiaResult getStartupStatus();
		tDiaResult getGnssInfo();
		tDiaResult getWlanInfo();
		tDiaResult getSensorInfo();
		tDiaResult getHeatControlInfo();
		tDiaResult getHMIMonitorInfo();
		tDiaResult getSdsGuiPopupInfo();
		tDiaResult getHMINavigationInfo();
		tDiaResult getPhoneConnectionInfo();
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
        tDiaResult getBTConnectionStatusInfo(); // connection status
        tDiaResult getProcInterruptInfo();
		tDiaResult getSystemStatusInfo();
		tDiaResult getSWCConnectionStatus();
#endif
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
        tDiaResult getDTCInfo();
        tDiaResult getConfigInfo();
        tDiaResult getVersionInfo();
#endif
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)
		tDiaResult getOperationHistoryInfo();
#endif
		tDiaResult getStartAndEndTime();
        tDiaResult getCalibrationStatusInfo();

		dia_ProcInfo mProcInfo;
		dia_ILMInfo mILMInfo;
		dia_GPUInfo mGPUInfo;
		dia_ResetHistoryInfo mResetInfo;
		dia_PowerStatusInfo mPowerStatusInfo;
		dia_VehicleSignalsInfo mVehicleSignalsInfo;
		dia_CommunicationStatus mCommunicationStatus;
		dia_CardStatus mCardStatus;
		dia_StartupStatusInfo mStartupStatusInfo;
		dia_GnssInfo mGnssInfo;
		dia_WlanInfo mWlanInfo;
		dia_SensorInfo mSensorInfo;
		dia_HeatControlInfo mHeatControlInfo;
		dia_HMIMonitorInfo mHMIMonitorInfo;
		dia_SdsGuiPopupInfo mSdsGuiPopupInfo;
		dia_HMINavigationInfo mHMINavigationInfo;
		dia_PhoneConnectionInfo mPhoneConnectionInfo;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		dia_BTConnectionStatusInfo mBTConnectionStatusInfo;
		dia_ClockSWCConnectionStatusInfo mClockSWCConnectionStatusInfo;
		dia_BoseAmpInfo mBoseAmpInfo;
#endif
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
		dia_DTCInfo mDTCInfo;
		dia_ConfigInfo mConfigInfo;
		dia_VersionInfo mVersionInfo;
#endif
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)
		dia_InputHistory mInputHistory;
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	   tDiaResult getSdsDiagnosisServiceInfo();
#endif
		std::multimap<tFloat, std::string> mTopProcessSortedViaCpuUsage; // in percent
		typedef std::multimap<tFloat, std::string>::reverse_iterator mTopProcessSortedReverseIteratorType;

		std::map<tULong, struct CPUProcessMemory> mTopProcessSortedViaMemoryUsage; // in KByte
		typedef std::map<tULong, struct CPUProcessMemory>::reverse_iterator mTopProcessSortedViaMemoryUsageReverseIteratorType;

		std::map<tULong, struct GPUProcess> mTopProcessSortedViaGPUMemoryUsage;
		typedef std::map<tULong, struct GPUProcess>::reverse_iterator mTopProcessSortedViaGPUMemoryUsageReverseIteratorType;

		std::vector<ResetHistoryElement> mResetHistoryElements;

		dia_MessageXCPMonitoring mMessageXCPMonitoring;

		tU32 mMaxDataPayload;

		//! offset within the whole data structure that is relevant
		tU32 mPayloadTransferOffset;

		std::map<tU32, std::string> mXcpMonitoringItemAddressMap;
		typedef std::map<tU32, std::string>::iterator tXcpMonitoringItemAddressMapIter;

		tBool mAddressUpdated;
		tBool mResetHistoryUpdated;
		tBool mResetCounterUpdated;
		tBool mStartupTimeUpdated;
		tBool mCardInfoAvailable;
		tBool mConfigInfoUpdated;
		tBool mVersionInfoUpdated;
		tBool mStartupStatusUpdated;
		tBool mWakeupStatusUpdated;

		// List of possible payload transfer offsets
		std::vector<tU32> mPayloadTransferOffsetList;
		// Index of actual transfer offset element in above List
		tU32 mPayloadTransferOffsetIndex;
		tBool mPayloadTransferOffsetListUpdated;

		struct timespec mTimeSpecStart;
		struct timespec mTimeSpecEnd;
		time_t mNumericMaxTime;

		// Variables to avoid subsequent subscriptions to already failed items
		tBool mHMINavigationInfoFailed;
		tBool mHMIMonitorInfoFailed;

		/*********** CALIBRATION ***********/
		tVoid updateAddressOfCalibrationParameters();

		tDiaResult simulateKeyInjection();
		tDiaResult simulateEncRotation();
		tDiaResult simulateSingleTouch();
		tDiaResult simulateTouchSlide();
		tDiaResult startGestureRecord();
		tDiaResult stopGestureRecord();
		tDiaResult startGestureReplay();
		tDiaResult stopGestureReplay();
		tDiaResult simulateEncoderPush();
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		tDiaResult simulateSinglePIVITouch();
#endif
        dia_PowerStatusInfo cPowerStatusInfo;
		dia_InputSimulation cInputSimulation;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		tDiaResult changeWifiPower();
		dia_WifiPowerChange cWifiPowerChange;
		dia_LightingDimming mLightingDimming;
		tDiaResult simulateLightingDimming();
		tDiaResult startTripFileReplay();
		tDiaResult stopTripFileReplay();
		tDiaResult getBoseAmpANCversion();
		tDiaResult getBoseAmpASCversion();
#endif
		dia_MessageXCPCalibration cMessageXCPCalibration;
		tBool cResponseWithCalibrationData;

		tU16 cMaxDataPayload;
		//! offset within the whole data structure that is relevant
		tU16 cPayloadTransferOffset;

		std::map<tU32, std::string> cXcpCalibrationItemAddressMap;
		typedef std::map<tU32, std::string>::iterator tXcpCalibrationItemAddressMapIter;
};

#endif /* DIA_SRV_HANDLER_XCPMONITORING_H_ */
