/*
 * dia_BaseStream.cpp
 *
 *  Created on: Oct 20, 2015
 *      Author: jas1hi
 */

#include "dia_BaseStream.h"


const tU8 LF = '\n';
const tU8 CR = '\r';
const std::string CRLF = "\r\n";

#define GET_VECTOR_PTR_DATA( var )   (  &var->at(0)  )
#define GET_VECTOR_DATA( var )   	 (  &var[ 0 ]    )


tS32 dia_BaseStream::readByte( tU8* data )const{
	return readBytes( data, sizeof( *data ) );
}

tS32 dia_BaseStream::readBuffer( std::vector<tU8>* outBuffer, tSize numberToRead )const {
	DIA_ASSERT(outBuffer != NULL);

	tS32 readNumberOfBytes = 0;

	if( numberToRead == 0 ){
		return 0;
	}

	if (outBuffer) {
		if( outBuffer->capacity() < numberToRead ){
			outBuffer->reserve( numberToRead );
		}

		outBuffer->resize ( numberToRead );
		readNumberOfBytes = this->readBytes( static_cast<tPVoid>( GET_VECTOR_PTR_DATA( outBuffer ) ), numberToRead);
		if( readNumberOfBytes == DIA_STREAM_ERROR ){
			return DIA_STREAM_ERROR;
		}
		outBuffer->resize ( (tSize)readNumberOfBytes );
	}

	return readNumberOfBytes;
}

tS32 dia_BaseStream::readString( std::string* str, tSize numberToRead )const {
	DIA_ASSERT( str != NULL );

	std::vector<tU8> buffer( numberToRead );

	tS32 readNumberOfBytes =  readBytes( GET_VECTOR_DATA( buffer ), numberToRead );
    if( readNumberOfBytes == DIA_STREAM_EOF){
    	return 0;
    }

	if (str)
		str->assign( (tCString)GET_VECTOR_DATA( buffer ), buffer.size() );

	if( (tSize)readNumberOfBytes != numberToRead  /*&& readNumberOfBytes != 0*/){ // readNumberOfBytes = 0-> EOF reached
		return DIA_STREAM_ERROR;
	}

	return readNumberOfBytes;
}

tS32 dia_BaseStream::readLine( std::string& str ) const {
//	DIA_ASSERT( str != NULL );

	tS32 readNumberOfBytes = 0;
	tBool lf_found = false;
	tBool cr_found = false;

//	if (str) {
		str.clear();

		for( ;; ){
			tU8 byte = 0;
			tS32 successRead = readByte( &byte );

			if( successRead == DIA_STREAM_ERROR ){
				if( readNumberOfBytes == 0 ){
					// if no bytes was read, then report error
					readNumberOfBytes = DIA_STREAM_ERROR;
				}
				break;
			}
			else if( successRead == DIA_STREAM_EOF){
				if( readNumberOfBytes == 0 ){
					// if no bytes was read, then report EOF
					readNumberOfBytes = DIA_STREAM_EOF;
				}
				break;
			}

			if( byte == LF ){
				lf_found = true;
			}
			if(  byte == CR ){
				cr_found = true;
			}
			if( byte != LF && byte != CR && ( cr_found || lf_found ) ){
				tSize position		= (tSize) getPosition();
				tSize new_position	= position - 1;

				dia_BaseStream* thisInstance = const_cast<dia_BaseStream*>( this );
				thisInstance->setPosition( new_position );

				break;
			}
			if( byte != LF && byte != CR) {
				str.append( 1, byte );
			}
			readNumberOfBytes++;
		}
//	}

	return readNumberOfBytes;
}

tS32 dia_BaseStream::writeBuffer( const std::vector<tU8>& buffer ) {
	return writeBytes( GET_VECTOR_DATA( buffer ), buffer.size()  );
}

tS32 dia_BaseStream::writeString( const std::string& str ) {
	return writeBytes( str.c_str(), str.size() );
}

tS32 dia_BaseStream::writeLine( const std::string& str ) {
	tS32 bytesWritten = writeString( str  );
	if (bytesWritten != -1) {
//		bytesWritten = writeString( std::string((tCString)LF) ); // TODO: Check if CR would not be a better solution for Windows files
		bytesWritten = writeString( CRLF );
	}

	return bytesWritten;
}
