/*
 * dia_Helper.cpp
 *
 *  Created on: Oct 21, 2015
 *      Author: Samir Jafarov (BOSCH Car Multimedia GmbH)
 */

#ifdef  __cplusplus
extern "C" {
#endif
//#include <arpa/inet.h>
//#include <stdio.h>
#include <sys/stat.h>
#ifdef  __cplusplus
}
#endif

//#include <algorithm> // std::set_difference
//#include <set>
#include <sstream>
//#include <iomanip>      // std::setw, std::setfill


#include "dia_Helper.h"


std::vector<std::string> dia_Helper::SplitString(const std::string& s, tChar delim)
{
	std::stringstream ss(s);
	std::vector<std::string> elems;
	std::string item;

	while (std::getline(ss, item, delim))
	{
		elems.push_back(item);
	}

	return elems;
}

//std::vector<tU8> dia_Helper::GetBytesFromHexString(const std::string& s) // "AA BB CC 12 8B"
//{
//	std::vector<tU8> bytes;
//	std::istringstream hex_chars_stream(s);
//
//	tU32 c;
//	while (hex_chars_stream >> std::hex >> c)
//	{
//	    bytes.push_back(c);
//	}
//
//	return bytes;
//}

std::string dia_Helper::tS32ToString(tS32 value)
{
	std::stringstream ss;
	ss << value;

	return ss.str();
}

std::string dia_Helper::tU16ToString(tU16 value)
{
	std::stringstream ss;
	ss << value;

	return ss.str();
}

tBool dia_Helper::isDirectory(tCString dirPath)
{
	tBool result = FALSE;

    struct stat statbuf;
	if (stat(dirPath, &statbuf) != -1) {
	   if (S_ISDIR(statbuf.st_mode)) {
		   result = TRUE;
	   }
	}

   return result;
}

tBool dia_Helper::isFileExists(tCString filePath)
{
	tBool result = FALSE;

	struct stat statbuf;
	if (stat(filePath, &statbuf) != -1) {
		result = TRUE;
	}



	return result;
}

tVoid dia_Helper::mountFileSystemRw(tCString mountPoint)
{
	std::string mountSystemCallRw = std::string("mount -o remount,rw ") + std::string(mountPoint);
	system(mountSystemCallRw.c_str());
}

tVoid dia_Helper::mountFileSystemRo(tCString mountPoint)
{
	std::string mountSystemCallRo = std::string("mount -o remount,ro ") + std::string(mountPoint);
	system(mountSystemCallRo.c_str());
}

//tS32 dia_Helper::StringTotS32(const std::string& s)
//{
//	tS32 number = -1;
//	std::istringstream (s) >> number;
//
//	return number;
//}

//tU32 dia_Helper::HexStringToUtS32(const std::string& s)
//{
//	tU32 number = 0;
//	std::stringstream  ss;
//	ss << std::hex << s;
//	ss >> number;
//
//	return number;
//}

//std::string dia_Helper::UIntToHexString(tU32 value)
//{
//	std::stringstream  ss;
//	ss << std::setfill ('0') << std::setw(sizeof(value)*2)
//	   << std::hex << value;
//
//	return ss.str();
//}

//std::vector<std::string> dia_Helper::GetDifferenceOfVectors(const std::vector<std::string>& model, const std::vector<std::string>& pattern)
//{
//    std::set<std::string> setOfModel(model.begin(), model.end());
//    std::set<std::string> setOfPattern(pattern.begin(), pattern.end());
//    std::vector<std::string> difference;
//
//    std::set_difference(setOfModel.begin(), setOfModel.end(), setOfPattern.begin(), setOfPattern.end(), std::back_inserter(difference));
//
//    return difference;
//}

//tBool dia_Helper::IsElementExist(const std::vector<std::string>& array, const std::string& element)
//{
//	tBool result = false;
//
//	if(std::find(array.begin(), array.end(), element) != array.end())
//	{
//		result = true;
//	}
//
//	return result;
//}
