/*
 * dia_defsDebugTraceConfig.h
 *
 *  Created on: 15.03.2017
 *      Author: nlk1kor
 D:\views\nlk1kor_AI_PRJ_RN_AIVI_17.0V14.vws\di_middleware_server\components\fc_diagnosis\project\services\customer\MonitoringCalibration\config
 */

#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#define __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__

#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#include "project/services/customer/MonitoringCalibration/config/dia_defsDebugTraceConfig.h"
#endif





// Data used for Monitoring and Calibration (MC) purposes

/*********** MONITORING ***********/

//error codes internal to Monitoring Calibration Module
#define DIA_ERR_INVALID_REQUEST               2
#define DIA_ERR_INVALID_RESPONSE              3
#define DIA_ERR_REQUEST_SEND                  4 
#define DIA_ERR_RESPONSE_RECEIVE              5

#define DIA_ERR_INPUT_FILE_INVALID            6
#define DIA_ERR_UNKNOWN                       7

#define DIA_TRIP_REPLAY_STATUS_ACTIVE         8
#define DIA_TRIP_REPLAY_STATUS_NOT_ACTIVE     9
#define DIA_TRIP_REPLAY_STATUS_RESERVED       10
#define DIA_ERR_TRIP_REPLAY_FILE_NOT_FOUND    11
#define DIA_ERR_TRIP_REPLAY_INTERNAL          12



#define MAX_NUMBER_OF_PROCESS         				(tU16) 5
#define MAX_LENGTH_PROCESS_NAME        				(tU16) 15 // max. 15 chars for the name of process
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#define MAX_LENGTH_PROCESS_STATE                    (tU16) 3  // max. 3  chars for state of the process
#endif
#define MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS        (tU16) 3
#define MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS_FOR_TRACE  (tU16) 20
#define MAX_LENGTH_DATE        						(tU16) 20 // max. 20 chars for the date (e.g. 2015-12-31 00:00:01)

#define MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS       (tU16) 55 // max. number of processes that are under control of SPM (or systemd)
#define MAX_NUMBER_OF_WAKEUP_STATUS_ELEMENTS        (tU16) 5  // max. number of latest wakeup history elements

#define MAX_LENGTH_WIFI_ESSID						(tU16) 15 // max. 15 chars for the ESSID name

#define MAX_LENGTH_HMI_SCREEN_NAME					(tU16) 50 // max. 50 chars for the HMI screen name

#define MAX_LENGTH_SDS_SCREEN_NAME					(tU16) 15 // max. 15 chars for the SDS Gui Popup screen name

#define MAX_BT_NAME_STR_LENGTH                      (tU16) 20  //max length of the BT device name
#define MAX_CONNECTED_BT_DEVICES                    (tU16) 2  // max no of Bt devices connected

#define MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY    (tU16) 2 // max elements for Operation History category
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#define MAX_NUMBER_OF_INTERRUPT_INFO_OF_DEVICES    (tU16) 5 // max elements for Interrupt info
#define MAX_DEVICE_INTERRUPT_INFO_LENGTH            (tU16) 25  //max length of Interrupt info string 
#endif
#define MAX_LENGTH_HMI_DATA_LENGTH					(tU16) 20 // max. 50 chars for the HMI screen name
//--------------------------------------------------------------------------------------------------------------------------------

struct dia_ProcessLoad
{
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI 
	tU8 mLoadTopProcessName[MAX_LENGTH_PROCESS_NAME+ MAX_LENGTH_PROCESS_STATE];
#else
	tU8 mLoadTopProcessName[MAX_LENGTH_PROCESS_NAME];
#endif

	tU8 mLoadTopProcess;
} __attribute__((packed));

struct dia_ProcessMemory
{
	tU8 mMemoryTopProcessName[MAX_LENGTH_PROCESS_NAME];
	tU32 mCurrentMemoryTopProcess; // in KByte
	tU32 mMaximumMemoryTopProcess; // in KByte
} __attribute__((packed));

struct dia_ResetHistory
{
	 tU8 reason;
	 tChar dateStr[MAX_LENGTH_DATE];
} __attribute__((packed));

struct dia_ResetCounter
{
	 tU16 ApApplicationError;
	 tU16 ApECUReset;
	 tU16 ApUser;
	 tU16 ApDownload;
	 tU16 ApDownloadError;
	 tU16 ApSoftware;
	 tU16 ApUnknown;
	 tU16 ApOverTemperature;
	 tU16 ApLCMIntern;
	 tU16 ApPowerOnReset;
	 tU16 ApPowerLoss;
	 tU16 ApPowerOff;
	 tU16 ApScc;
	 tU16 ApWarmStart;
	 tU16 SccHWWdt;
	 tU16 SccPowerOn;
	 tU16 SccColdStart;
	 tU16 SccAppModeChange;
	 tU16 SccDuringLpw;
	 tU16 SccDuringPllOsz;
	 tU16 SccDuringSW;
	 tU16 SccWarmStart;
} __attribute__((packed));

struct dia_CardInfo
{
	// USB
	tU8  USBconnectionState;
	tU8  USBdeviceSpeed;
	tU8  USBfileSystem;
	tU32 USBsize; // MB
	tU8  USBReadWriteState; // Read / Write

	// eMMC
	tU8  eMMCReadWriteState; // Read / Write
	tU8  eMMCReadSpeed; // in MB/sec
	//Optic Disk Connection State
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	tU8  OpticDiskConnectionStatus;
    #endif
} __attribute__((packed));

struct dia_StartupStatus
{
//	tU64 startupStatus64; // Bitcoded ("Started"=1, "Not Started"=0) list processes configured in start configuration of SPM
	tU32 startupStatus0_31;
	tU32 startupStatus32_63;
	tU16 startTimeSinceStart[MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS]; // start time [ms] for each process

} __attribute__((packed));

struct dia_SurfaceProperties
{
	tU16 surfaceFPS;
	tU16 surfaceID;

} __attribute__((packed));

struct dia_GnssData
{
	tU8 fixStatus;
	tS16 velocityNorth;
	tS16 velocityEast;
	tChar dateStr[MAX_LENGTH_DATE];
} __attribute__((packed));

struct dia_WiFiData
{
	tChar essIdStr[MAX_LENGTH_WIFI_ESSID];
	tU16 frequency; // e.g. 2412 Hz
	tU16 bitRate; // e.g. 54 MBit/s
} __attribute__((packed));

struct dia_SensorData
{
	tU32 rAxisVal; //adc-value of the gyro/acc r-coordinate
	tU32 sAxisVal; //adc-value of the gyro/acc s-coordinate
	tU32 tAxisVal; //adc-value of the gyro/acc t-coordinate

	tU8 rAxisStatus; //status codes associated with a gyro/acc r-coordinate
	tU8 sAxisStatus; //status codes associated with a gyro/acc s-coordinate
	tU8 tAxisStatus; //status codes associated with a gyro/acc t-coordinate
} __attribute__((packed));

struct dia_HeatControlData
{
	tS16 cpuTemperature; // temperature [deg C]
	tU8  cpuFanSpeed; // FAN speed in percent [%]. e.g.: value 10 means 10%
} __attribute__((packed));

struct dia_SdsGuiPopupData
{
	tChar screenID[MAX_LENGTH_SDS_SCREEN_NAME]; // e.g. SR_INF_MAIN
//#ifdef VARIANT_S_FTR_ENABLE_NPIVI 
	tU8 sdsSpeechInputStatus;
//#endif
} __attribute__((packed));
#ifdef VARIANT_S_FTR_ENABLE_NPIVI 
struct dia_SdsDiagData
{
	tU8 sdsSpeechEventStatus;
	tU16 sdsSpeechEventTimeStamp;

} __attribute__((packed));
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
struct BTConnectionStatusInfo
{
	// Interface device
	tChar BTConnectionName[MAX_BT_NAME_STR_LENGTH]; 
	tU8   BTConnectionStatusValue;
}__attribute__((packed));

struct dia_OperationHistoryData
{
	tU16 mKeyCode;
	tU8  mKeyStatus; // 2: Released, 1: Pressed

	tU16 mTouchCordinate_X; // X coordinate value
	tU16 mTouchCordinate_Y; // Y Coordinate Value
//	tU8  mTouchStatus;      // 0: Released, 1: Pressed

	tU8 mEncoderType;	  // Left or Right
	tS8 mEncoderDirSteps; // value range from -128 to 127
} __attribute__((packed));

struct dia_TopInterruptDeviceInfo
{
	tChar TopInterruptDevice[MAX_DEVICE_INTERRUPT_INFO_LENGTH];
}__attribute__((packed));
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
struct dia_CalibrationStatus
{
	tU8 mKeyInjectionstatus; 
	tU8 mEncRotationStatus; 
	tU8 mTouchSimulationStatus; 
	tU8 mGestureRecordStatus; 
	tU8 mGestureReplayStatus; 
	tU8 mTripReplayStatus; 
	tU8 mWifiPowerStatus; 
	
} __attribute__((packed));


struct dia_ANCSWVersion
{
	tU8 mANCLargeVersion; 
	tU8 mANCMiddleVersion; 
	tU8 mANCSmallVersion; 


	
} __attribute__((packed));

struct dia_ASCSWVersion
{

	tU8 mASCLargeVersion; 
	tU8 mASCMiddleVersion; 
	tU8 mASCSmallVersion; 

	
} __attribute__((packed));

#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
struct dia_OperationHistoryDataPIVI
{


	tU16 mPIVIPrimaryCordinate_X; // X coordinate value
	tU16 mPIVIPrimaryCordinate_Y; // Y Coordinate Value
	tU16 mPIVISecondaryCordinate_X; // X coordinate value
	tU16 mPIVISecondaryCordinate_Y; // Y Coordinate Value

} __attribute__((packed));
#endif
// Message structure related to the XCP-Monitoring parameters
struct dia_MessageXCPMonitoring
{
   // Members of the whole message
	//#####24########
	struct dia_ResetCounter mResetCounter;

	//#####8########
	struct dia_ResetHistory mResetHistory[MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS]; // structure for last MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS Reset History Elements from LCM

	//#####13########
	struct dia_StartupStatus mStartupStatus;

	//#####23########
	tU32 mStartTimestamp; // Timestamp taken at the start of MC ServiceHandler
	tU32 mEndTimestamp; // Timestamp taken at the end of MC ServiceHandler
	

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	//#####26########
	struct dia_OperationHistoryData mOperationHistoryData[MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY];

	//#####25########
	struct BTConnectionStatusInfo mBTConnectionStatus[MAX_CONNECTED_BT_DEVICES]; // structure for MAX_CONNECTED_BT_DEVICES BT Connection Status
    #endif  
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	struct dia_OperationHistoryDataPIVI mOperationHistoryDataPIVI[MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY];
	struct dia_SdsDiagData  mSdsDiagStatus;
	#endif
	//#####27########
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	tU8 mTCUCommunicationErrorCode; // TCU COMMUNICATION ERROR CODE 
	struct dia_TopInterruptDeviceInfo mTopInterruptDevice[MAX_NUMBER_OF_INTERRUPT_INFO_OF_DEVICES]; //structure for Interrupt info 
#endif
	//#####22########
	tU32 mPhoneConnectionEstablishmentDuration; // Duration of connection establishment to BT Phone

	//#####21########
	tU16 mHmiNavigationRouteCalDurationToFinalDest;
	tU16 mHmiNavigationRouteCalDurationToNextDest;

	//#####20########
	struct dia_SdsGuiPopupData mSdsGuiPopupStatus;

	//#####19########
	tU32 mHmiMonitorStartupTime; // Updated only once
	tChar mHmiMonitorScreenName[MAX_LENGTH_HMI_SCREEN_NAME];

	//#####18########
	struct dia_HeatControlData mHeatControlData;

	//#####17########
	struct dia_SensorData mGyroData;
	struct dia_SensorData mAccData;

	//#####16########
	struct dia_WiFiData mWiFiData;

	//#####15########
	struct dia_GnssData mGnssData;

	//#####14########
	struct dia_SurfaceProperties mSurfaceProperties;

    //#####12########
    struct dia_CardInfo mCardInfo;

    //#####11########
    tU8 mCommunicationStatus; // MCAN_METER_CONNECTION, MCAN_TCU_CONNECTION

    //#####10########
   	tU8 mVehicleSignals; // Parking Brake, Reverse Gear, RVC

   	 //#####9########
   	tU8 mPowerStatus; // IGN, ACC, AUTO_ACC

	//#####1########
	tU32 mTotalCPUMemoryConsumption; // in KByte
	//#####2########
	tU8 mCpuIdleTime; // Total CPU load: ~idle time (in percent)
	//#####3########
	struct dia_ProcessLoad mLoadTopProcessCPU[MAX_NUMBER_OF_PROCESS]; // structure for MAX_NUMBER_OF_PROCESS top CPU consuming processes
	//#####4########
	struct dia_ProcessMemory mMemoryTopProcessCPU[MAX_NUMBER_OF_PROCESS]; // structure for MAX_NUMBER_OF_PROCESS top RAM consuming processes

	//#####5########
    tU32 mTotalGPUMemoryConsumption; // in KByte
    //#####6########
    tU8 mGpuIdleTime; // Total GPU load: ~idle time (in percent)
    //#####7########
    struct dia_ProcessMemory mMemoryTopProcessGPU[MAX_NUMBER_OF_PROCESS]; // structure for MAX_NUMBER_OF_PROCESS top GPU memory consuming processes

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	//#####28########
	tU8 mTCUConnectionStatus;   //TCU MCAN Connection Status

	//#####30########
	tU8 mMeterConStatusNAV;   //MCAN Meter NAV Channel Connection Status
	tU8 mMeterConStatusAUDIO; //MCAN Meter AUDIO Channel Connection Status
	tU8 mMeterConStatusSWC;   //MCAN Meter SWC Channel Connection Status
	struct dia_CalibrationStatus mCalibrationStatus;
	struct dia_ANCSWVersion   mANCSWVersion;
	struct dia_ASCSWVersion   mASCSWVersion;
#endif

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	//#####31########
    tChar mHmiMonitorSecondaryScreenName[MAX_LENGTH_HMI_DATA_LENGTH];
	tChar mHmiMonitorNextUpperAppName[MAX_LENGTH_HMI_DATA_LENGTH];
	tChar mHmiMonitorNextLowerAppName[MAX_LENGTH_HMI_DATA_LENGTH];
	//#####29########
	tU8 mSystemStatus; // ON ,DOOR_OPEN,BACKGROUND,STANDBY
#endif

} __attribute__((packed)); // to avoid an alignment problems when transferring over network (INC)



/*********** CALIBRATION ***********/

#define GESTURE_RECORD_REPLAY_FILE_MAX_STR_LENGTH (tU16) 20
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#define TRIP_REPLAY_FILE_MAX_STR_LENGTH (tU16) 20
#endif

struct dia_KeyInjection
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation
	tU16 keyCode;
	tU16 releaseTime;
} __attribute__((packed));

struct dia_EncRotation
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation
	tU8 encType; // Encoder type: Left or Right
	tS8 encSteps; // No of steps with +ve/-ve value indicating direction of rotation
} __attribute__((packed));

struct dia_SingleTouch
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation
	tU16 xCoord;
	tU16 yCoord;
	tU16 releaseTime;
} __attribute__((packed));

struct dia_TouchSlide
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation
	tU16 xCoordStart;
	tU16 yCoordStart;
	tU16 xCoordEnd;
	tU16 yCoordEnd;
	tU16 duration; // duration of slide operation in milliseconds
} __attribute__((packed));

struct dia_GestureRecord
{
	tU8 start; // Used to indicate that the user wanted effectively to start this operation
	tU8 stop;  // Used to indicate that the user wanted effectively to stop this operation
	tU8 onUSB; // Save the recorded file on USB?
	tChar fileName[GESTURE_RECORD_REPLAY_FILE_MAX_STR_LENGTH];
} __attribute__((packed));

struct dia_GestureReplay
{
	tU8 start; // Used to indicate that the user wanted effectively to start this operation
	tU8 stop;  // Used to indicate that the user wanted effectively to stop this operation
	tU8 fromUSB; // Replay the recorded file from USB?
	tChar fileName[GESTURE_RECORD_REPLAY_FILE_MAX_STR_LENGTH];
} __attribute__((packed));

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
struct dia_WifiPowerAttenuation
{
	tU8 startStop;  // Used to indicate that the user wanted effectively to execute this operation
	tU8 value;  // Desired value for WiFi power attenuation in [dB]
} __attribute__((packed));

struct dia_lightingTiming
{
	tU8 startStop; //Used to indicate that the user wanted effectively to execute this operation
	tU32 lightingTimingvalue; // Desired value for Lighting Timing delay

} __attribute__((packed));

struct dia_TripReplay
{
	tU8 start; // Used to indicate that the user wanted effectively to start this operation
	tU8 stop;  // Used to indicate that the user wanted effectively to stop this operation
	tU8 status;
	tChar fileName[TRIP_REPLAY_FILE_MAX_STR_LENGTH];
} __attribute__((packed));
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
struct dia_SinglePIVITouch
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation
	tU16 xCoord;
	tU16 yCoord;
	tU16 screenNumber;
	tU16 releaseTime;
} __attribute__((packed));
#endif

struct dia_EncoderPush
{
	tU8 startStop; // Used to indicate that the user wanted effectively to execute this operation

} __attribute__((packed));

// Message structure related to the XCP-Calibration parameters
struct dia_MessageXCPCalibration
{
	//#####1########
	struct dia_KeyInjection cKeyInjection;
	//#####2########
	struct dia_EncRotation cEncRotation;
	//#####3########
	struct dia_SingleTouch cSingleTouch;
	//#####4########
	struct dia_TouchSlide cTouchSlide;
	//#####5########
	struct dia_GestureRecord cGestureRecord;
	//#####6########
	struct dia_GestureReplay cGestureReplay;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	//#####7########
	struct dia_WifiPowerAttenuation cWifiPowerChange;
	//#####8########
	struct dia_lightingTiming cLightingDimmingSet;
	//#####9########
	struct dia_TripReplay cTripReplay;
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	//#####10########
	struct dia_SinglePIVITouch cSinglePIVITouch;
#endif
	//#####11########
	struct dia_EncoderPush cEncoderPush;
} __attribute__((packed)); // to avoid an alignment problems when transferring over network (INC)

#endif
