/*****************************************************************************************
*
* \file       dia_IWifiMostListener.h
*
* \brief      Definition of the listener interface to the wifi most feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       28 November 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFIMOST_LISTENER__
#define __INCLUDED_DIA_INTERFACE_WIFIMOST_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_WIFIMOST__
#include "dia_IWifiMost.h"
#endif

/**
 *
 *  \class dia_IWifiMostListener
 *
 */

class dia_IWifiMostListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_WIFIMOST_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! Tells whether the request for ChangeWifiTransmitPower can be processed or not.
   virtual void vOnChangeWifiTransmitPower ( tDiaResult eDiaResult ) = 0;
   //! MOST Default ErrorCode
   virtual void vOnChangeWifiTransmitPowerError ( const tU8 errCode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiMostListener ( void ) {}
};

/**
 *
 *  \class dia_IWifiMostListenerImpl
 *
 */

class dia_IWifiMostListenerImpl
   : public dia_IWifiMostListener
{
public:
   //! Tells whether the request for ChangeWifiTransmitPower can be processed or not.
   virtual void vOnChangeWifiTransmitPower ( tDiaResult /*eDiaResult*/ ) {}
   //! MOST Default ErrorCode
   virtual void vOnChangeWifiTransmitPowerError ( const tU8 /*errCode*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiMostListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IWifiMostNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IWifiMostNotifier
   : public dia_IWifiMostListener,
     public dia_Notifier<dia_IWifiMostListener>
{
public:
   //! Tells whether the request for ChangeWifiTransmitPower can be processed or not.
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnChangeWifiTransmitPower,tDiaResult)
   //! MOST Default ErrorCode
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnChangeWifiTransmitPowerError,const tU8)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_WIFIMOST_LISTENER__ */

