/*****************************************************************************************
*
* \file       dia_IWifiConnmanListener.h
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     stc2hi (generated with dia_igen tool)
*
* \date       28 September 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__
#define __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__
#include "dia_IWifiConnman.h"
#endif

/**
 *
 *  \class dia_IWifiConnmanListener
 *
 */

class dia_IWifiConnmanListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_WIFI_CONNMAN_LISTENER_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnWifiStations ( const std::vector<dia_tWifiStation>& stationList ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnmanListener ( void ) {}
};

/**
 *
 *  \class dia_IWifiConnmanListenerImpl
 *
 */

class dia_IWifiConnmanListenerImpl
   : public dia_IWifiConnmanListener
{
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnWifiStations ( const std::vector<dia_tWifiStation>& /*stationList*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnmanListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IWifiConnmanNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IWifiConnmanNotifier
   : public dia_IWifiConnmanListener,
     public dia_Notifier<dia_IWifiConnmanListener>
{
public:
   //! List of currently active wifi setups (wlan devices).
   DIA_M_ADD_NOTIFIER_ONE_ARG(OnWifiStations,const std::vector<dia_tWifiStation>&)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__ */

