/*****************************************************************************************
*
* \file       dia_IWifiConnman.h
*
* \brief      interface of dia_IWifiConnman
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     stc2hi (generated with dia_igen tool)
*
* \date       28 September 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__
#define __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif


//------------------------------------------------------------------------------

enum dia_eWifiState
{
   DIA_EN_WIFI_STATE_UNKNOWN = 0,
   DIA_EN_WIFI_STATE_IDLE,
   DIA_EN_WIFI_STATE_READY,
   DIA_EN_WIFI_STATE_ONLINE,
   DIA_EN_WIFI_STATE_COUNT
};

//------------------------------------------------------------------------------

struct dia_tWifiStation
{
public:
   //! default constructor
   dia_tWifiStation ( void )
      : mState(DIA_EN_WIFI_STATE_UNKNOWN),
        mStrength(0)
   {}

   //! copy constructor
   dia_tWifiStation ( const dia_tWifiStation& obj )
      : mState(obj.mState),
        mName(obj.mName),
        mAddress(obj.mAddress),
        mStrength(obj.mStrength)
   {}

   //! assignment operator
   dia_tWifiStation& operator = ( const dia_tWifiStation& obj )
   {
      if ( this != &obj )
      {
         mState = obj.mState;
         mName = obj.mName;
         mAddress = obj.mAddress;
         mStrength = obj.mStrength;
      }
      return *this;
   }

   //! class constructor
   dia_tWifiStation (
         dia_eWifiState state
      )
      : mState(state),
        mStrength(0)
   {}

   void reset ( void )
   {
      mState = DIA_EN_WIFI_STATE_UNKNOWN;
      mName.clear();
      mAddress.clear();
      mStrength = 0;
   }

public:
   dia_eWifiState mState;
   std::string mName;
   std::string mAddress;
   tU8 mStrength;
};

//------------------------------------------------------------------------------

class dia_IWifiConnman
{
   DIA_DECL_INTERFACE_IID(IID_WIFI_CONNMAN_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! Request currently active wifi network connections.
   virtual tDiaResult GetWifiStations ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnman ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__ */

