/*****************************************************************************************
*
* \file    dia_ITunerTestmodeListener.h
*
* \brief   Definition of the listener interface to the AMFMTuner feature
*
* The listener-class covers methods with requested diagnosis responses from SAFeature to service handler. The reception and processing on service handler side is not verified with a return value.
* For details about the available methods see the list below.
*
* \author  shw2abt (generated with dia_igen tool)
*
* \date    24 February 2016
*
* (c) 2016 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_TESTMODE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TUNER_TESTMODE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AMFMTUNER__
#include "common/interfaces/dia_ITunerAMFM.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_TESTMODE__
#include "dia_ITunerTestmode.h"
#endif


struct dia_ITunerTestmodeData
{
   dia_eTunerNr ePhysicalTuner;
   dia_eBandAMFM eBand;
   tU32 u32AFFrequency;
   tU8 u8Fieldstrength;
   tU8 u8Multipath;
   tU8 u8Quality;
};

/**
 *
 *  \class dia_ITunerTestmodeListener
 *
 */

class dia_ITunerTestmodeListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_TUNER_TESTMODE_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnControlTestmode() = 0;
   virtual void vOnTestmodeData(const dia_ITunerTestmodeData&) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerTestmodeListener ( void ) {}
};

/**
 *
 *  \class dia_ITunerTestmodeListenerImpl
 *
 */

class dia_ITunerTestmodeListenerImpl
   : public dia_ITunerTestmodeListener
{
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnControlTestmode() {}
   virtual void vOnTestmodeData(const dia_ITunerTestmodeData&) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerTestmodeListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ITunerTestmodeNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITunerTestmodeNotifier
   : public dia_ITunerTestmodeListener,
     public dia_Notifier<dia_ITunerTestmodeListener>
{
public:
   //! result on the selectActiveTuner_Get call
   DIA_M_ADD_NOTIFIER_NO_ARG(vOnControlTestmode)
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnTestmodeData, const dia_ITunerTestmodeData&)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TUNER_TESTMODE_LISTENER__ */

