/*****************************************************************************************
*
* \file       dia_ITunerAMFMPrjListener.h
*
* \brief      Definition of the listener interface to the AMFMWBTuner feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     urm7kor (generated with dia_igen tool)
*
* \date       28 February 2019
*
* \copyright  (c) 2019 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ__
#include "dia_ITunerAMFMPrj.h"
#endif

/**
 *
 *  \class dia_ITunerAMFMPrjListener
 *
 */

class dia_ITunerAMFMPrjListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_TUNER_AMFM_PRJ_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! result on the tunerAMFMWB_BandFieldStrength_Get call
   virtual void vOnTunerAMFMFWB_BandFieldStrength_Get ( dia_eBandAMFMWB activeBand, tU8 strength ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFMPrjListener ( void ) {}
};

/**
 *
 *  \class dia_ITunerAMFMPrjListenerImpl
 *
 */

class dia_ITunerAMFMPrjListenerImpl
   : public dia_ITunerAMFMPrjListener
{
public:
   //! result on the tunerAMFMWB_BandFieldStrength_Get call
   virtual void vOnTunerAMFMFWB_BandFieldStrength_Get ( dia_eBandAMFMWB /*activeBand*/, tU8 /*strength*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFMPrjListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ITunerAMFMPrjNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITunerAMFMPrjNotifier
   : public dia_ITunerAMFMPrjListener,
     public dia_Notifier<dia_ITunerAMFMPrjListener>
{
public:
   //! result on the tunerAMFMWB_BandFieldStrength_Get call
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnTunerAMFMFWB_BandFieldStrength_Get,dia_eBandAMFMWB,tU8)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ_LISTENER__ */

