/*
 * dia_ITCUListener.h
 *
 *  Created on: 07.12.2015
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_TCU_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TCU_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TCU__
#include "dia_ITCU.h"
#endif

//-----------------------------------------------------------------------------
enum dia_eTCUConnectionStatusType
{
	DIA_EN_COMM_STATUS_OFF = 0,
	DIA_EN_COMM_STATUS_NOT_CONNECTED,
	DIA_EN_COMM_STATUS_CONNECTION_WAIT,
	DIA_EN_COMM_STATUS_CONNECTED,
	DIA_EN_COMM_STATUS_CONNECTION_ERROR,
	DIA_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR
};

class dia_TCUConnectionInfo
{
public:
    //! class constructor
    dia_TCUConnectionInfo ( void )
    {
		m_AbsentState = 0xff;
		m_TCUConnectionStatusType = DIA_EN_COMM_STATUS_OFF;
    }
    //! class destructor
    ~dia_TCUConnectionInfo ( void ) {}

    //! check if the given ECU is absent
    tU8 getAbsentState ( ) const { return m_AbsentState; }

	//! set absent mode for the given ECU
    void setAbsentState ( tU8 absentState ) { m_AbsentState = absentState; }
	void setTCUConnectionStatus(dia_eTCUConnectionStatusType connectiontype) { m_TCUConnectionStatusType = connectiontype; }
	dia_eTCUConnectionStatusType getTCUConnectionStatus() const { return m_TCUConnectionStatusType; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_AbsentState;

	dia_eTCUConnectionStatusType m_TCUConnectionStatusType;
};

class dia_TCUVersionInfo
{
public:
    //! class constructor
	dia_TCUVersionInfo ( void )
    {
		m_Upper = 0x00;
		m_Mid   = 0x00;
		m_Lower = 0x00;
    }
    //! class destructor
    ~dia_TCUVersionInfo ( void ) {}

public:
	//! Upper (= Major) version number
	tU8 m_Upper;
	//! Mid (= Minor) version number
	tU8 m_Mid;
	//! Lower (= Patch) version number
	tU8 m_Lower;
};

//-----------------------------------------------------------------------------

class dia_ITCUListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_TCU_LISTENER)

public:
    //! notify the network status
    virtual void vOnConnectionInfo ( const dia_TCUConnectionInfo& ) = 0;
    //! notify the Software Version
    virtual void vOnSoftwareVersion ( const dia_TCUVersionInfo& ) = 0;
    //! notify the Hardware Version
    virtual void vOnHardwareVersion ( const dia_TCUVersionInfo& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ITCUListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_TCUListenerImpl
    : public dia_ITCUListener
{
public:
    //! notify connection state of ECUs connected to the MCAN
    virtual void vOnConnectionInfo ( const dia_TCUConnectionInfo& ) {}
    //! notify the Software Version
    virtual void vOnSoftwareVersion ( const dia_TCUVersionInfo& ) {}
	//! notify the Hardware Version
	virtual void vOnHardwareVersion ( const dia_TCUVersionInfo& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_TCUListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_TCUNotifier
    : public dia_ITCUListener,
      public dia_Notifier<dia_ITCUListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectionInfo,const dia_TCUConnectionInfo&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSoftwareVersion,const dia_TCUVersionInfo&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnHardwareVersion,const dia_TCUVersionInfo&)
};


#endif /* __INCLUDED_DIA_INTERFACE_TCU_LISTENER__ */
