/*
 * dia_ISubsystemDiagnosisListener.h
 *
 *  Created on: 23.09.2019
 *      Author: mky6kor
 */

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__
#include "project/interfaces/dia_ISubsystemDiagnosis.h"
#endif

//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisListener
    : public virtual dia_Listener
{
    DIA_DECL_INTERFACE_IID(IID_SUBSYSTEM_DIAGNOSIS_LISTENER)

public:

    //! there was an update about the session request
    virtual void vOnSessionRequestUpdate (const tBool& state ) = 0;

    //! there was an update in the identified subsystems
    virtual void vOnIdentifySubsystemsRequestUpdate ( const std::list<dia_tSubsystemInfo>& /*nodeList*/ , dia_eIdentifyEntitiesRoutineStatus status ) = 0;

    //! there was an update in the subsystems node list
    virtual void vOnReadSubsystemsNodeListRequestUpdate ( const std::list<dia_tSubsystemInfo>& /*nodeList*/) = 0;

    //! there was an update in the connected request
    virtual void vOnConnectToSubsystemRequestUpdate ( tDiaResult& success ) = 0;

    //! there was an update in the routing request
    virtual void vOnRouteRequestUpdate ( std::vector<tU8>& responseData ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ISubsystemDiagnosisListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisListenerImpl
    : public dia_ISubsystemDiagnosisListener
{
public:
    //! there was an update about the download request
    virtual void vOnSessionRequestUpdate (const tBool& /*state*/ ) {}

    //! there was an update in the identified subsystems
     virtual void vOnIdentifySubsystemsRequestUpdate (const std::list<dia_tSubsystemInfo>& /*nodeList*/ , dia_eIdentifyEntitiesRoutineStatus status ) {}

     //! there was an update in the subsystems node list
     virtual void vOnReadSubsystemsNodeListRequestUpdate ( const std::list<dia_tSubsystemInfo>& /*nodeList*/) {}

     //! there was an update in the connected request
     virtual void vOnConnectToSubsystemRequestUpdate ( tDiaResult& /*success*/ ) {}

     //! there was an update in the routing request
     virtual void vOnRouteRequestUpdate ( std::vector<tU8>& /*responseData*/ ) {}


protected:
    //! virtual base class destructor
    virtual ~dia_ISubsystemDiagnosisListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisNotifier
    : public dia_ISubsystemDiagnosisListener,
      public dia_Notifier<dia_ISubsystemDiagnosisListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSessionRequestUpdate,const tBool&)
    DIA_M_ADD_NOTIFIER_TWO_ARG(vOnIdentifySubsystemsRequestUpdate,const std::list<dia_tSubsystemInfo>&, dia_eIdentifyEntitiesRoutineStatus)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReadSubsystemsNodeListRequestUpdate,const std::list<dia_tSubsystemInfo>&)
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectToSubsystemRequestUpdate,tDiaResult& )
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnRouteRequestUpdate,std::vector<tU8>& )

};


#endif /* __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__ */
