/*****************************************************************************************
*
* \file    dia_ISdsGuiPopup.h
*
* \brief   interface of dia_ISdsGuiPopup
*
* The interface-class covers methods for sending requests and data to SAFeature. The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author  jas1hi (generated with dia_igen tool)
*
* \date    19 April 2016
*
* (c) 2016 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP__
#define __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eSpeechInputStatus
{
   DIA_EN_SPEECH_INPUT_STATUS_UNKNOWN = 0,
   DIA_EN_SPEECH_INPUT_STATUS_IDLE,
   DIA_EN_SPEECH_INPUT_STATUS_DIALOGOPEN,
   DIA_EN_SPEECH_INPUT_STATUS_LOADING,
   DIA_EN_SPEECH_INPUT_STATUS_ERROR,
   DIA_EN_SPEECH_INPUT_STATUS_LISTENING,
   DIA_EN_SPEECH_INPUT_STATUS_ACTIVE,
   DIA_EN_SPEECH_INPUT_STATUS_PAUSE,
   DIA_EN_SPEECH_INPUT_STATUS_COUNT
};

//------------------------------------------------------------------------------

class dia_ISdsGuiPopup
{
   DIA_DECL_INTERFACE_IID(IID_SDS_GUI_POPUP)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! retrieve the speech input state
   virtual tDiaResult getSdsSpeechInputStatus ( void ) = 0;
   //! register for the sdsSpeechInputStatus property update
   virtual tDiaResult registerToSdsSpeechInputStatus ( void ) = 0;
   //! retrieve the sdsScreenID
   virtual tDiaResult getSdsScreenID ( void ) = 0;
   //! register for the screenID property update
   virtual tDiaResult registerToSdsScreenID ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsGuiPopup ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP__ */

