/*****************************************************************************************
*
* \file       dia_ISdsDiagnosisServiceListener.h
*
* \brief      listener of dia_ISdsDiagnosisServiceListener
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     nlk1kor (generated with dia_igen tool)
*
* \date       31 August 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE__
#include "dia_ISdsDiagnosisService.h"
#endif

/**
 *
 *  \class dia_ISdsDiagnosisServiceListener
 *
 */

class dia_ISdsDiagnosisServiceListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SDS_DIAGNOSIS_SERVICE_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to registerToExtendedSDSLoggingDataUpdate
   virtual void vOnSdsDiagnosisServiceUpdate ( dia_eExtendedSDSLoggingData extendedSDSLoggingData, tU16 sdsTimestamp ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsDiagnosisServiceListener ( void ) {}
};

/**
 *
 *  \class dia_ISdsDiagnosisServiceListenerImpl
 *
 */

class dia_ISdsDiagnosisServiceListenerImpl
   : public dia_ISdsDiagnosisServiceListener
{
public:
   //! response to registerToExtendedSDSLoggingDataUpdate
   virtual void vOnSdsDiagnosisServiceUpdate ( dia_eExtendedSDSLoggingData /*extendedSDSLoggingData*/, tU16 /*sdsTimestamp*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsDiagnosisServiceListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ISdsDiagnosisServiceNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISdsDiagnosisServiceNotifier
   : public dia_ISdsDiagnosisServiceListener,
     public dia_Notifier<dia_ISdsDiagnosisServiceListener>
{
public:
   //! response to registerToExtendedSDSLoggingDataUpdate
   DIA_M_ADD_NOTIFIER_TWO_ARG(vOnSdsDiagnosisServiceUpdate,dia_eExtendedSDSLoggingData,tU16)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE_LISTENER__ */

