/*****************************************************************************************
*
* \file       dia_ISdsDiagnosisService.h
*
* \brief      interface of dia_ISdsDiagnosisService
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     nlk1kor (generated with dia_igen tool)
*
* \date       31 August 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE__
#define __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eExtendedSDSLoggingData
{
   DIA_EN_SDS_UNKNOWN = 0,
   DIA_EN_SDS_BEGIN_OF_SPEECH,
   DIA_EN_SDS_END_OF_SPEECH,
   DIA_EN_SDS_CALLING_PP,
   DIA_EN_SDS_START_OF_PROMPT,
   DIA_EN_SDS_END_OF_PROMPT,
   DIA_EN_SDS_RECOGNIZER_RESULT,
   DIA_EN_SDS_COUNT
};

//------------------------------------------------------------------------------

class dia_ISdsDiagnosisService
{
   DIA_DECL_INTERFACE_IID(IID_SDS_DIAGNOSIS_SERVICE)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! register for the ExtendedSDSLoggingData property update
   virtual tDiaResult registerToExtendedSDSLoggingDataUpdate ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsDiagnosisService ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE__ */

